/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.DatagramChannelImpl;
import gnu.java.nio.SelectionKeyImpl;
import gnu.java.nio.ServerSocketChannelImpl;
import gnu.java.nio.SocketChannelImpl;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SelectorImpl
extends AbstractSelector {
    boolean closed;
    Set keys;
    Set selected;
    Set canceled;

    private /* synthetic */ void finit$() {
        this.closed = false;
    }

    public SelectorImpl(SelectorProvider provider) {
        super(provider);
        this.finit$();
        this.keys = new HashSet();
        this.selected = new HashSet();
        this.canceled = new HashSet();
    }

    public Set keys() {
        return this.keys;
    }

    public int selectNow() {
        return this.select(1L);
    }

    public int select() {
        return this.select(-1);
    }

    private static native int java_do_select(int[] var0, int[] var1, int[] var2, long var3);

    private int[] getFDsAsArray(int ops) {
        SelectionKeyImpl key;
        int counter = 0;
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            key = (SelectionKeyImpl)it.next();
            if ((key.interestOps() & ops) == 0) continue;
            ++counter;
        }
        int[] result = new int[counter];
        counter = 0;
        it = this.keys.iterator();
        while (it.hasNext()) {
            key = (SelectionKeyImpl)it.next();
            if ((key.interestOps() & ops) == 0) continue;
            result[counter] = key.fd;
            ++counter;
        }
        return result;
    }

    public int select(long timeout) {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        if (this.keys == null) {
            return 0;
        }
        int ret = 0;
        this.deregisterCanceledKeys();
        int[] read = this.getFDsAsArray(17);
        int[] write = this.getFDsAsArray(12);
        int[] except = new int[]{};
        int anzahl = read.length + write.length + except.length;
        ret = SelectorImpl.java_do_select(read, write, except, timeout);
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            int i;
            int ops = 0;
            SelectionKeyImpl key = (SelectionKeyImpl)it.next();
            if (this.selected.contains(key)) {
                ops = key.readyOps();
            }
            for (i = 0; i < read.length; ++i) {
                if (key.fd != read[i]) continue;
                if (key.channel() instanceof ServerSocketChannelImpl) {
                    ops |= 0x10;
                    continue;
                }
                ops |= 1;
            }
            for (i = 0; i < write.length; ++i) {
                if (key.fd != write[i]) continue;
                ops |= 4;
            }
            if (!this.selected.contains(key)) {
                this.add_selected(key);
            }
            key.readyOps(key.interestOps() & ops);
        }
        this.deregisterCanceledKeys();
        return ret;
    }

    public Set selectedKeys() {
        return this.selected;
    }

    public Selector wakeup() {
        return null;
    }

    public void add(SelectionKeyImpl k) {
        this.keys.add(k);
    }

    void add_selected(SelectionKeyImpl k) {
        this.selected.add(k);
    }

    protected void implCloseSelector() {
        this.closed = true;
    }

    private void deregisterCanceledKeys() {
        Iterator it = this.canceled.iterator();
        while (it.hasNext()) {
            this.keys.remove((SelectionKeyImpl)it.next());
            it.remove();
        }
    }

    protected SelectionKey register(SelectableChannel ch, int ops, Object att) {
        return this.register((AbstractSelectableChannel)ch, ops, att);
    }

    protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        if (ch instanceof SocketChannelImpl) {
            SocketChannelImpl sc = (SocketChannelImpl)ch;
            SelectionKeyImpl impl = new SelectionKeyImpl(ch, this, sc.fd);
            this.add(impl);
            impl.interestOps(ops);
            impl.attach(att);
            return impl;
        }
        if (ch instanceof DatagramChannelImpl) {
            DatagramChannelImpl dc = (DatagramChannelImpl)ch;
            SelectionKeyImpl impl = new SelectionKeyImpl(ch, this, dc.fd);
            this.add(impl);
            impl.interestOps(ops);
            impl.attach(att);
            return impl;
        }
        if (ch instanceof ServerSocketChannelImpl) {
            ServerSocketChannelImpl ssc = (ServerSocketChannelImpl)ch;
            SelectionKeyImpl impl = new SelectionKeyImpl(ch, this, ssc.fd);
            this.add(impl);
            impl.interestOps(ops);
            impl.attach(att);
            return impl;
        }
        System.err.println("INTERNAL ERROR, no known channel type");
        return null;
    }
}

