/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.text;

import gnu.java.text.BaseBreakIterator;
import java.text.CharacterIterator;

public class WordBreakIterator
extends BaseBreakIterator {
    public Object clone() {
        return new WordBreakIterator(this);
    }

    public WordBreakIterator() {
        this.iter = null;
    }

    private WordBreakIterator(WordBreakIterator other) {
        this.iter = (CharacterIterator)other.iter.clone();
    }

    private final boolean isHira(char c) {
        return c > '\u303f' && c <= '\u309f';
    }

    private final boolean isKata(char c) {
        return c > '\u309f' && c <= '\u30ff';
    }

    private final boolean isHan(char c) {
        return c > '\u4dff' && c <= '\u9fff';
    }

    public int next() {
        char c;
        int end = this.iter.getEndIndex();
        if (this.iter.getIndex() == end) {
            return -1;
        }
        while (this.iter.getIndex() < end && (c = this.iter.current()) != '\uffff') {
            int type = Character.getType(c);
            char n = this.iter.next();
            if (n == '\uffff' || type == 14 || type == 13) break;
            boolean is_letter = Character.isLetter(c);
            if (c != '\'' && !is_letter && type != 6 && Character.isLetter(n) || c != '\'' && (type == 20 || type == 21 || type == 22 || type == 23 || type == 24 || type == 25 || type == 26 || type == 27 || type == 28 || type == 16 || type == 15)) break;
            boolean is_hira = this.isHira(c);
            boolean is_kata = this.isKata(c);
            boolean is_han = this.isHan(c);
            if (!is_hira && !is_kata && !is_han && type != 6 && (this.isHira(n) || this.isKata(n) || this.isHan(n))) break;
            if (!is_hira && !is_kata && !is_han && !is_letter) continue;
            int save = this.iter.getIndex();
            while (n != '\uffff' && Character.getType(n) == 6) {
                n = this.iter.next();
            }
            if (n == '\uffff' || is_hira && !this.isHira(n) || is_kata && !this.isHira(n) && !this.isKata(n) || is_han && !this.isHira(n) && !this.isHan(n) || is_letter && !Character.isLetter(n) && n != '\'') break;
            this.iter.setIndex(save);
        }
        return this.iter.getIndex();
    }

    public int previous() {
        char c;
        int start = this.iter.getBeginIndex();
        if (this.iter.getIndex() == start) {
            return -1;
        }
        while (this.iter.getIndex() >= start && (c = this.iter.previous()) != '\uffff') {
            boolean is_hira = this.isHira(c);
            boolean is_kata = this.isKata(c);
            boolean is_han = this.isHan(c);
            boolean is_letter = Character.isLetter(c);
            char n = this.iter.previous();
            if (n == '\uffff') break;
            this.iter.next();
            int type = Character.getType(n);
            if (type == 14 || type == 13 || n != '\'' && !Character.isLetter(n) && type != 6 && is_letter || n != '\'' && (type == 20 || type == 21 || type == 22 || type == 23 || type == 24 || type == 25 || type == 26 || type == 27 || type == 28 || type == 16 || type == 15) || (is_hira || is_kata || is_han) && !this.isHira(n) && !this.isKata(n) && !this.isHan(n) && type != 6) break;
            if (is_hira && (is_letter || c == '\'')) continue;
            int save = this.iter.getIndex();
            while (n != '\uffff' && Character.getType(n) == 6) {
                n = this.iter.previous();
            }
            this.iter.setIndex(save);
            if (!(n == '\uffff' || this.isHira(n) && !is_hira || this.isKata(n) && !is_hira && !is_kata || this.isHan(n) && !is_hira && !is_han) && (is_letter || c == '\'' || !Character.isLetter(n))) continue;
            break;
        }
        return this.iter.getIndex();
    }
}

