/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import gnu.java.rmi.RMIMarshalledObjectInputStream;
import gnu.java.rmi.RMIMarshalledObjectOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class MarshalledObject
implements Serializable {
    private static final long serialVersionUID = 8988374069173025854L;
    byte[] objBytes;
    byte[] locBytes;
    int hash;

    public MarshalledObject(Object obj) throws IOException {
        int i;
        ByteArrayOutputStream objStream = new ByteArrayOutputStream();
        RMIMarshalledObjectOutputStream stream = new RMIMarshalledObjectOutputStream(objStream);
        stream.writeObject(obj);
        stream.flush();
        this.objBytes = objStream.toByteArray();
        this.locBytes = stream.getLocBytes();
        this.hash = 0;
        for (i = 0; i < this.objBytes.length; ++i) {
            this.hash = this.hash * 31 + this.objBytes[i];
        }
        if (this.locBytes != null) {
            for (i = 0; i < this.locBytes.length; ++i) {
                this.hash = this.hash * 31 + this.locBytes[i];
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MarshalledObject)) {
            return false;
        }
        if (obj.hashCode() != this.hash) {
            return false;
        }
        MarshalledObject aobj = (MarshalledObject)obj;
        if (this.objBytes == null || aobj.objBytes == null) {
            return this.objBytes == aobj.objBytes;
        }
        if (this.objBytes.length != aobj.objBytes.length) {
            return false;
        }
        for (int i = 0; i < this.objBytes.length; ++i) {
            if (this.objBytes[i] == aobj.objBytes[i]) continue;
            return false;
        }
        return true;
    }

    public Object get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        RMIMarshalledObjectInputStream stream = new RMIMarshalledObjectInputStream(this.objBytes, this.locBytes);
        return stream.readObject();
    }

    public int hashCode() {
        return this.hash;
    }
}

