// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 4
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +xsfmmbase \
// RUN:   -target-feature +zve64x \
// RUN:   -disable-O0-optnone -emit-llvm %s -o - | \
// RUN:   opt -S -passes=mem2reg | FileCheck --check-prefix=CHECK-RV64 %s

#include <sifive_vector.h>

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtzero_t_e8w1(
// CHECK-RV64-SAME: i64 noundef [[TM:%.*]], i64 noundef [[TN:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtzero.t.i64(i64 0, i64 [[TM]], i64 [[TN]], i64 3, i64 1)
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtzero_t_e8w1(size_t tm, size_t tn) {
  return __riscv_sf_vtzero_t_e8w1(0, tm, tn);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtzero_t_e8w2(
// CHECK-RV64-SAME: i64 noundef [[TM:%.*]], i64 noundef [[TN:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtzero.t.i64(i64 0, i64 [[TM]], i64 [[TN]], i64 3, i64 2)
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtzero_t_e8w2(size_t tm, size_t tn) {
  return __riscv_sf_vtzero_t_e8w2(0, tm, tn);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtzero_t_e8w4(
// CHECK-RV64-SAME: i64 noundef [[TM:%.*]], i64 noundef [[TN:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtzero.t.i64(i64 0, i64 [[TM]], i64 [[TN]], i64 3, i64 4)
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtzero_t_e8w4(size_t tm, size_t tn) {
  return __riscv_sf_vtzero_t_e8w4(0, tm, tn);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtzero_t_e16w1(
// CHECK-RV64-SAME: i64 noundef [[TM:%.*]], i64 noundef [[TN:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtzero.t.i64(i64 0, i64 [[TM]], i64 [[TN]], i64 4, i64 1)
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtzero_t_e16w1(size_t tm, size_t tn) {
  return __riscv_sf_vtzero_t_e16w1(0, tm, tn);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtzero_t_e16w2(
// CHECK-RV64-SAME: i64 noundef [[TM:%.*]], i64 noundef [[TN:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtzero.t.i64(i64 0, i64 [[TM]], i64 [[TN]], i64 4, i64 2)
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtzero_t_e16w2(size_t tm, size_t tn) {
  return __riscv_sf_vtzero_t_e16w2(0, tm, tn);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtzero_t_e16w4(
// CHECK-RV64-SAME: i64 noundef [[TM:%.*]], i64 noundef [[TN:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtzero.t.i64(i64 0, i64 [[TM]], i64 [[TN]], i64 4, i64 4)
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtzero_t_e16w4(size_t tm, size_t tn) {
  return __riscv_sf_vtzero_t_e16w4(0, tm, tn);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtzero_t_e32w1(
// CHECK-RV64-SAME: i64 noundef [[TM:%.*]], i64 noundef [[TN:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtzero.t.i64(i64 0, i64 [[TM]], i64 [[TN]], i64 5, i64 1)
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtzero_t_e32w1(size_t tm, size_t tn) {
  return __riscv_sf_vtzero_t_e32w1(0, tm, tn);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtzero_t_e32w2(
// CHECK-RV64-SAME: i64 noundef [[TM:%.*]], i64 noundef [[TN:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtzero.t.i64(i64 0, i64 [[TM]], i64 [[TN]], i64 5, i64 2)
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtzero_t_e32w2(size_t tm, size_t tn) {
  return __riscv_sf_vtzero_t_e32w2(0, tm, tn);
}

// CHECK-RV64-LABEL: define dso_local void @test_sf_vtzero_t_e64w1(
// CHECK-RV64-SAME: i64 noundef [[TM:%.*]], i64 noundef [[TN:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vtzero.t.i64(i64 0, i64 [[TM]], i64 [[TN]], i64 6, i64 1)
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vtzero_t_e64w1(size_t tm, size_t tn) {
  return __riscv_sf_vtzero_t_e64w1(0, tm, tn);
}

