//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @class Extender plasma/extender.h <Plasma/Extender>
    ///  An Extender is a widget that visually extends the normal contents of an applet with
    ///  additional dynamic widgets called ExtenderItems. These ExtenderItems can be
    ///  detached by the user and dropped either on another Extender or on the canvas directly.
    ///  This widget allows using ExtenderItems in your applet. Extender takes care of the presentation
    ///  of a collection of ExtenderItems and keeps track of ExtenderItems that originate in it.
    ///  The default Extender implementation displays extender items in a vertical layout with
    ///  spacers that appear when dropping an ExtenderItem over it.
    ///  If you wish to have a different presentation of extender items, you can choose to subclass
    ///  Extender and reimplement the extenderItem events and, optionally, the saveState function.
    ///  To use an Extender in you applet, you'll have to instantiate one. A call to extender() in your
    ///  applet will create an extender on your applet if you haven't got one already. Every applet can
    ///  contain only one extender. Think of it as a decorator that adds some functionality to applets
    ///  that require it. Never instantiate an Extender before init() in your applet. This won't work
    ///  correctly since a scene is required when an Extender is instantiated.
    ///  As soon as an Extender is instantiated, ExtenderItems contained previously in this Extender are
    ///  restored using the initExtenderItem function from the applet the items originally came from. For
    ///  more information on how this works and how to use ExtenderItems in general, see the ExtenderItem
    ///  API documentation.
    ///   See <see cref="IExtenderSignals"></see> for signals emitted by Extender
    /// </remarks>        <short> Extends applets to allow detachable parts.</short>
    [SmokeClass("Plasma::Extender")]
    public class Extender : QGraphicsWidget, IDisposable {
        protected Extender(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Extender), this);
        }
        /// <remarks>
        ///  Description on how to render the extender's items.
        ///          </remarks>        <short>    Description on how to render the extender's items.</short>
        public enum Appearance {
            NoBorders = 0,
            BottomUpStacked = 1,
            TopDownStacked = 2,
        }
        [Q_PROPERTY("QString", "emptyExtenderMessage")]
        public string EmptyExtenderMessage {
            get { return (string) interceptor.Invoke("emptyExtenderMessage", "emptyExtenderMessage()", typeof(string)); }
            set { interceptor.Invoke("setEmptyExtenderMessage$", "setEmptyExtenderMessage(QString)", typeof(void), typeof(string), value); }
        }
        /// <remarks>
        ///  Creates an extender. Note that extender expects applet to have a config(), and needs a
        ///  scene because of that. So you should only instantiate an extender in init() or later, not
        ///  in an applet's constructor.
        ///  The constructor also takes care of restoring ExtenderItems that were contained in this
        ///  extender before, so ExtenderItems are persistent between sessions.
        ///  Note that a call to extender() in an applet will instantiate an Extender for you if one
        ///  isn't already associated with your applet.
        /// <param> name="applet" The applet this extender is part of. Null is not allowed here.
        ///          </param></remarks>        <short>    Creates an extender.</short>
        public Extender(Plasma.Applet applet) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Extender#", "Extender(Plasma::Applet*)", typeof(void), typeof(Plasma.Applet), applet);
        }
        /// <remarks>
        /// </remarks>        <return> a list of all extender items (attached AND detached) where the source applet is
        ///  this applet.
        ///          </return>
        ///         <short>   </short>
        public List<Plasma.ExtenderItem> Items() {
            return (List<Plasma.ExtenderItem>) interceptor.Invoke("items", "items() const", typeof(List<Plasma.ExtenderItem>));
        }
        /// <remarks>
        /// </remarks>        <return> a list of all attached extender items.
        ///          </return>
        ///         <short>   </short>
        public List<Plasma.ExtenderItem> AttachedItems() {
            return (List<Plasma.ExtenderItem>) interceptor.Invoke("attachedItems", "attachedItems() const", typeof(List<Plasma.ExtenderItem>));
        }
        /// <remarks>
        /// </remarks>        <return> a list of all detached extender items.
        ///          </return>
        ///         <short>   </short>
        public List<Plasma.ExtenderItem> DetachedItems() {
            return (List<Plasma.ExtenderItem>) interceptor.Invoke("detachedItems", "detachedItems() const", typeof(List<Plasma.ExtenderItem>));
        }
        /// <remarks>
        ///  This function can be used for obtaining the extender item specified by name. For checking
        ///  whether or not an item already exists, you should use hasItem instead: while plasma is
        ///  starting up, not all detached items might have been instantiated yet. hasItem returns true
        ///  even if the requested item isn't instantiated yet.
        /// </remarks>        <return> the requested item
        ///          </return>
        ///         <short>    This function can be used for obtaining the extender item specified by name.</short>
        public Plasma.ExtenderItem Item(string name) {
            return (Plasma.ExtenderItem) interceptor.Invoke("item$", "item(const QString&) const", typeof(Plasma.ExtenderItem), typeof(string), name);
        }
        /// <remarks>
        ///  Extra convenience function for obtaining groups specified by name. This will avoid needed
        ///  to call item and casting to ExtenderGroup, which is otherwise quite common.
        /// </remarks>        <return> the requested group
        /// </return>
        ///         <short>    Extra convenience function for obtaining groups specified by name.</short>
        public Plasma.ExtenderGroup Group(string name) {
            return (Plasma.ExtenderGroup) interceptor.Invoke("group$", "group(const QString&) const", typeof(Plasma.ExtenderGroup), typeof(string), name);
        }
        /// <remarks>
        ///  This function can be used for easily determining if a certain item is already displayed
        ///  in an extender item somewhere, so your applet doesn't duplicate this item. This is needed
        ///  because ExtenderItems are persistent, so you can't blindly add new extender items in all
        ///  cases.
        /// </remarks>        <return> whether or not this item already exists.
        /// </return>
        ///         <short>    This function can be used for easily determining if a certain item is already displayed  in an extender item somewhere, so your applet doesn't duplicate this item.</short>
        public bool HasItem(string name) {
            return (bool) interceptor.Invoke("hasItem$", "hasItem(const QString&) const", typeof(bool), typeof(string), name);
        }
        /// <remarks>
        /// </remarks>        <return> true if the Extender is visually empty (though it may have items such as
        ///  empty groups or detached items associatd with it)
        ///          </return>
        ///         <short>   </short>
        public bool IsEmpty() {
            return (bool) interceptor.Invoke("isEmpty", "isEmpty() const", typeof(bool));
        }
        /// <remarks>
        ///  Use this function to instruct the extender on how to render its items. Usually you will
        ///  want to call this function in your applet's constraintsEvent, allthough this is already
        ///  done for you when using PopupApplet as base class for your applet. Defaults to NoBorders.
        /// <param> name="appearance" the way this extender should look.
        ///          </param></remarks>        <short>    Use this function to instruct the extender on how to render its items.</short>
        public void SetAppearance(Plasma.Extender.Appearance appearance) {
            interceptor.Invoke("setAppearance$", "setAppearance(Plasma::Extender::Appearance)", typeof(void), typeof(Plasma.Extender.Appearance), appearance);
        }
        /// <remarks>
        /// </remarks>        <return> the current way of rendering extender items that is used.
        ///          </return>
        ///         <short>   </short>
        public Plasma.Extender.Appearance appearance() {
            return (Plasma.Extender.Appearance) interceptor.Invoke("appearance", "appearance() const", typeof(Plasma.Extender.Appearance));
        }
        /// <remarks>
        /// </remarks>        <return> a list of groups that are contained in this extender.
        /// </return>
        ///         <short>   </short>
        public List<Plasma.ExtenderGroup> Groups() {
            return (List<Plasma.ExtenderGroup>) interceptor.Invoke("groups", "groups() const", typeof(List<Plasma.ExtenderGroup>));
        }
        /// <remarks>
        /// </remarks>        <return> the Applet this Extender is associated with
        /// </return>
        ///         <short>   </short>
        public Plasma.Applet Applet() {
            return (Plasma.Applet) interceptor.Invoke("applet", "applet() const", typeof(Plasma.Applet));
        }
        /// <remarks>
        ///  Get's called after an item has been added to this extender. The bookkeeping has already
        ///  been done when this function get's called. The only thing left to do is put it somewhere
        ///  appropriate. The default implementation adds the extenderItem to the appropriate place in
        ///  a QGraphicsLinearLayout.
        /// <param> name="item" The item that has just been added.
        /// </param><param> name="pos" The location the item has been dropped in local coordinates.
        ///          </param></remarks>        <short>    Get's called after an item has been added to this extender.</short>
        [SmokeMethod("itemAddedEvent(Plasma::ExtenderItem*, const QPointF&)")]
        protected virtual void ItemAddedEvent(Plasma.ExtenderItem item, QPointF pos) {
            interceptor.Invoke("itemAddedEvent##", "itemAddedEvent(Plasma::ExtenderItem*, const QPointF&)", typeof(void), typeof(Plasma.ExtenderItem), item, typeof(QPointF), pos);
        }
        [SmokeMethod("itemAddedEvent(Plasma::ExtenderItem*)")]
        protected virtual void ItemAddedEvent(Plasma.ExtenderItem item) {
            interceptor.Invoke("itemAddedEvent#", "itemAddedEvent(Plasma::ExtenderItem*)", typeof(void), typeof(Plasma.ExtenderItem), item);
        }
        /// <remarks>
        ///  Get's called after an item has been removed from this extender. All bookkeeping has
        ///  already been done when this function get's called.
        /// <param> name="item" The item that has just been removed.
        ///          </param></remarks>        <short>    Get's called after an item has been removed from this extender.</short>
        [SmokeMethod("itemRemovedEvent(Plasma::ExtenderItem*)")]
        protected virtual void ItemRemovedEvent(Plasma.ExtenderItem item) {
            interceptor.Invoke("itemRemovedEvent#", "itemRemovedEvent(Plasma::ExtenderItem*)", typeof(void), typeof(Plasma.ExtenderItem), item);
        }
        /// <remarks>
        ///  Get's called when an ExtenderItem that get's dragged enters this extender. Default
        ///  implementation does nothing.
        ///          </remarks>        <short>    Get's called when an ExtenderItem that get's dragged enters this extender.</short>
        [SmokeMethod("itemHoverEnterEvent(Plasma::ExtenderItem*)")]
        protected virtual void ItemHoverEnterEvent(Plasma.ExtenderItem item) {
            interceptor.Invoke("itemHoverEnterEvent#", "itemHoverEnterEvent(Plasma::ExtenderItem*)", typeof(void), typeof(Plasma.ExtenderItem), item);
        }
        /// <remarks>
        ///  Gets called when an ExtenderItem is hovering over this extender. Implement this function
        ///  to give some visual feedback about what will happen when the mouse button is released at
        ///  that position. The default implementation shows a spacer at the appropriate location in
        ///  the layout.
        /// <param> name="item" The item that's hovering over this extender. Most useful for obtaining the
        ///  size of the spacer.
        /// </param><param> name="pos" The location the item is hovering.
        ///          </param></remarks>        <short>    Gets called when an ExtenderItem is hovering over this extender.</short>
        [SmokeMethod("itemHoverMoveEvent(Plasma::ExtenderItem*, const QPointF&)")]
        protected virtual void ItemHoverMoveEvent(Plasma.ExtenderItem item, QPointF pos) {
            interceptor.Invoke("itemHoverMoveEvent##", "itemHoverMoveEvent(Plasma::ExtenderItem*, const QPointF&)", typeof(void), typeof(Plasma.ExtenderItem), item, typeof(QPointF), pos);
        }
        /// <remarks>
        ///  Get's called when an ExtenderItem that was previously hovering over this extender moves
        ///  away from this extender. The default implementation removes any spacer from the layout.
        ///          </remarks>        <short>    Get's called when an ExtenderItem that was previously hovering over this extender moves  away from this extender.</short>
        [SmokeMethod("itemHoverLeaveEvent(Plasma::ExtenderItem*)")]
        protected virtual void ItemHoverLeaveEvent(Plasma.ExtenderItem item) {
            interceptor.Invoke("itemHoverLeaveEvent#", "itemHoverLeaveEvent(Plasma::ExtenderItem*)", typeof(void), typeof(Plasma.ExtenderItem), item);
        }
        /// <remarks>
        ///  This function get's called for every extender when plasma exits. Implement this function
        ///  to store the current state of this extender (position in a layout for example), so this
        ///  can be restored when applet starts again. The default implementation stores the y
        ///  coordinate of every extender item in the config field extenderItemPos.
        ///          </remarks>        <short>    This function get's called for every extender when plasma exits.</short>
        [SmokeMethod("saveState()")]
        protected virtual void SaveState() {
            interceptor.Invoke("saveState", "saveState()", typeof(void));
        }
        /// <remarks>
        ///  This function get's called on every item to determine which background border's to
        ///  render.
        /// <param> name="item" the item for which its position or extender has changed.
        /// </param></remarks>        <return> the borders that have to be enabled on its background.
        ///          </return>
        ///         <short>    This function get's called on every item to determine which background border's to  render.</short>
        [SmokeMethod("enabledBordersForItem(Plasma::ExtenderItem*) const")]
        protected virtual uint EnabledBordersForItem(Plasma.ExtenderItem item) {
            return (uint) interceptor.Invoke("enabledBordersForItem#", "enabledBordersForItem(Plasma::ExtenderItem*) const", typeof(uint), typeof(Plasma.ExtenderItem), item);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsWidget
        ///          </remarks>        <short>    Reimplemented from QGraphicsWidget          </short>
        [SmokeMethod("itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)")]
        protected override QVariant ItemChange(QGraphicsItem.GraphicsItemChange change, QVariant value) {
            return (QVariant) interceptor.Invoke("itemChange$#", "itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)", typeof(QVariant), typeof(QGraphicsItem.GraphicsItemChange), change, typeof(QVariant), value);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsWidget
        ///          </remarks>        <short>    Reimplemented from QGraphicsWidget          </short>
        [SmokeMethod("resizeEvent(QGraphicsSceneResizeEvent*)")]
        protected override void ResizeEvent(QGraphicsSceneResizeEvent arg1) {
            interceptor.Invoke("resizeEvent#", "resizeEvent(QGraphicsSceneResizeEvent*)", typeof(void), typeof(QGraphicsSceneResizeEvent), arg1);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsWidget
        ///          </remarks>        <short>    Reimplemented from QGraphicsWidget          </short>
        [SmokeMethod("mousePressEvent(QGraphicsSceneMouseEvent*)")]
        protected override void MousePressEvent(QGraphicsSceneMouseEvent arg1) {
            interceptor.Invoke("mousePressEvent#", "mousePressEvent(QGraphicsSceneMouseEvent*)", typeof(void), typeof(QGraphicsSceneMouseEvent), arg1);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsWidget
        ///          </remarks>        <short>    Reimplemented from QGraphicsWidget          </short>
        [SmokeMethod("dragEnterEvent(QGraphicsSceneDragDropEvent*)")]
        protected override void DragEnterEvent(QGraphicsSceneDragDropEvent arg1) {
            interceptor.Invoke("dragEnterEvent#", "dragEnterEvent(QGraphicsSceneDragDropEvent*)", typeof(void), typeof(QGraphicsSceneDragDropEvent), arg1);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsWidget
        ///          </remarks>        <short>    Reimplemented from QGraphicsWidget          </short>
        [SmokeMethod("dragMoveEvent(QGraphicsSceneDragDropEvent*)")]
        protected override void DragMoveEvent(QGraphicsSceneDragDropEvent arg1) {
            interceptor.Invoke("dragMoveEvent#", "dragMoveEvent(QGraphicsSceneDragDropEvent*)", typeof(void), typeof(QGraphicsSceneDragDropEvent), arg1);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsWidget
        ///          </remarks>        <short>    Reimplemented from QGraphicsWidget          </short>
        [SmokeMethod("dragLeaveEvent(QGraphicsSceneDragDropEvent*)")]
        protected override void DragLeaveEvent(QGraphicsSceneDragDropEvent arg1) {
            interceptor.Invoke("dragLeaveEvent#", "dragLeaveEvent(QGraphicsSceneDragDropEvent*)", typeof(void), typeof(QGraphicsSceneDragDropEvent), arg1);
        }
        /// <remarks>
        ///  Reimplemented from QGraphicsWidget
        ///          </remarks>        <short>    Reimplemented from QGraphicsWidget          </short>
        [SmokeMethod("dropEvent(QGraphicsSceneDragDropEvent*)")]
        protected override void DropEvent(QGraphicsSceneDragDropEvent arg1) {
            interceptor.Invoke("dropEvent#", "dropEvent(QGraphicsSceneDragDropEvent*)", typeof(void), typeof(QGraphicsSceneDragDropEvent), arg1);
        }
        ~Extender() {
            interceptor.Invoke("~Extender", "~Extender()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Extender", "~Extender()", typeof(void));
        }
        protected new IExtenderSignals Emit {
            get { return (IExtenderSignals) Q_EMIT; }
        }
    }

    public interface IExtenderSignals : IQGraphicsWidgetSignals {
        /// <remarks>
        ///  Fires when an extender item is added to this extender.
        ///          </remarks>        <short>    Fires when an extender item is added to this extender.</short>
        [Q_SIGNAL("void itemAttached(Plasma::ExtenderItem*)")]
        void ItemAttached(Plasma.ExtenderItem arg1);
        /// <remarks>
        ///  Fires when an extender item is removed from this extender.
        ///          </remarks>        <short>    Fires when an extender item is removed from this extender.</short>
        [Q_SIGNAL("void itemDetached(Plasma::ExtenderItem*)")]
        void ItemDetached(Plasma.ExtenderItem arg1);
        /// <remarks>
        ///  Fires when an extender's preferred size changes.
        ///          </remarks>        <short>    Fires when an extender's preferred size changes.</short>
        [Q_SIGNAL("void geometryChanged()")]
        void GeometryChanged();
    }
}
