/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-François Wauthy (pollux@xfce.org) 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFPRINT_OPTION_H__
#define __XFPRINT_OPTION_H__

#include <glib.h>

typedef struct _XfprintOption XfprintOption;
struct _XfprintOption
{
	const gchar	*alias;
	const gchar	*name;
};

extern const gchar	*xfprint_option(const XfprintOption *, const gchar *);
extern const gchar	*xfprint_option_alias(const XfprintOption *, const gchar *);
extern GList		*xfprint_option_list(const XfprintOption *);
extern const gchar	*xfprint_option_name(const XfprintOption *, const gchar *);

#endif	/* !__XFPRINT_OPTION_H__ */
