/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.server.repository.QueryResultView;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryResultUtil;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQueryResultView
extends QueryResultView {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final GraphQueryResultView INSTANCE = new GraphQueryResultView();

    public static GraphQueryResultView getInstance() {
        return INSTANCE;
    }

    private GraphQueryResultView() {
    }

    public String getContentType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)model.get("factory");
        RDFFormat rdfFormat = rdfWriterFactory.getRDFFormat();
        response.setStatus(200);
        this.setContentType(response, rdfFormat);
        this.setContentDisposition(model, response, rdfFormat);
        ServletOutputStream out = response.getOutputStream();
        try {
            RDFWriter rdfWriter = rdfWriterFactory.getWriter((OutputStream)out);
            GraphQueryResult graphQueryResult = (GraphQueryResult)model.get("queryResult");
            QueryResultUtil.report(graphQueryResult, rdfWriter);
        }
        catch (QueryInterruptedException e) {
            this.logger.error("Query interrupted", (Throwable)e);
            response.sendError(503, "Query evaluation took too long");
        }
        catch (QueryEvaluationException e) {
            this.logger.error("Query evaluation error", (Throwable)e);
            response.sendError(500, "Query evaluation error: " + e.getMessage());
        }
        catch (RDFHandlerException e) {
            this.logger.error("Serialization error", (Throwable)e);
            response.sendError(500, "Serialization error: " + e.getMessage());
        }
        finally {
            out.close();
        }
        this.logEndOfRequest(request);
    }
}

