.\" Copyright (c) 2008, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.TH xkbvleds __appmansuffix__ __xorgversion__
.SH NAME
xkbvleds \- XKB extension user utility
.SH SYNOPSIS
.B xkbvleds
[\-indpy <name>]
[\-watch <leds>]
[[\-+]automatic]
[[\-+]explicit]
[[\-+]name]
[[\-+]real]
[[\-+]virtual]
[\-intersection]
[\-union]
.SH DESCRIPTION
This program is used to display the state of LEDs on an XKB keyboard.
It reports the changes in the fundamental components of the XKB state
which includes the effective compatibility state. The default set of LEDs
is \-union +name +automatic +real.
.SH OPTIONS
.PP
.TP 8
.B \-indpy <name>
Mask of LEDs to watch
.TP 8
.B \-watch <leds>
turn on synchronization
.PP
.TP 8
.B \[-+]automatic
(Don't) watch automatic LEDs
.PP
.TP 8
.B \[-+]explicit
(Don't) watch explicit LEDs
.PP
.TP 8
.B \[-+]name
(Don't) watch named LEDs
.PP
.TP 8
.B \[-+]real
(Don't) watch real LEDs
.PP
.TP 8
.B \[-+]virtual
(Don't) watch virtual LEDs
.PP
.TP 8
.B \-intersection
Watch only LEDs in all desired sets
.PP
.TP 8
.B \-union
Watch LEDs in any desired sets
.PP
.TP 8
.B \-help
print list of options and exit
.PP
.TP 8
.B \-version
print program version and exit
