#!/usr/bin/perl -T
# ----------------------------------------------------------------------
# Web interface for Mon.
# Arthur K. Chan <artchan@uidzero.com> <artchan@zsp.com>
#   Based on the Mon program by Jim Trocki <trockij@transmeta.com>. 
#   http://consult.ml.org/~trockij/mon/
# ----------------------------------------------------------------------
# $Id: mon.cgi,v 1.3 1998/04/06 03:55:53 trockij Exp $
# ----------------------------------------------------------------------

# Instructions ---------------------------------------------------------
# 
# Install this cgi script to whereever your cgi-bin directory sits
# on your mon server. If you don't have a web server installed, try
# http://www.apache.org.
# 
# Modify the "Configurable Parameters" section below to customize it
# to your site's settings. Send comment about this web interface to
# Art Chan at the address above.
#
# This script will require the CGI perl module. Available at any
# perl CPAN site. See http://www.perl.org for details.

#    Copyright (C) 1998, Arthur Chan
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Configurable Parameters ----------------------------------------------

$organization = "";                            # Organization name.
$monadmin = "";    	                       # Your e-mail address.
$logo = "";                                    # URL of company or mon logo.
$reload="180";			               # Seconds for page reload.
$monhost="localhost";			       # Mon server.
$ENV{"PATH"}="/usr/bin:/bin:/usr/local/bin";   # $PATH must include moncmd.


# You shouldn't need to change these.
$url = $ENV{SCRIPT_NAME};                      # URL of this script.
$moncmd="moncmd";	                       # Path to "moncmd".


# General Declarations -------------------------------------------------

use CGI;				       # Use the cgi module.
$webpage = new CGI;			       # Declare instance of mod.

$time = time;				       # This will be used for 
$localtime = localtime(time);		       # the time on the page.


# Reverse sort ---------------------------------------------------------
sub backwards {
    $b cmp $a;
}

# Setup the html doc headers and such ----------------------------------
sub setup_page {
    local ($title) = @_;
    print $webpage->header;
    print $webpage->start_html(-title=>"MON - $title",
                             -BGCOLOR=>'white');
    $webpage->print("\n<META HTTP-EQUIV=\"Refresh\"");
    $webpage->print("CONTENT=\"$reload\", URL=\"$url\">\n");
    print $webpage->h1("MON $title");
    if ($logo){
	$webpage->print("\n<img src=\"$logo\"><br><br>\n");
    }
    if ($organization){
	print $webpage->h3("$organization");
    }
    &print_bar;

    $qtime = time;
    @time = localtime($qtime);
    $ttime = sprintf ("%.2d:%.2d:%.2d", $time[2],$time[1],$time[0]);
    print $webpage->center
	("\nThe time for this check was: $ttime. ");
    print $webpage->center
	("This page will reload every $reload seconds.<br><br>\n");
} 


# Print the button bar -------------------------------------------------
sub print_bar {
    $button = "INPUT TYPE=\"submit\" NAME=\"command\"";
    $webpage->print("\n\n<FORM METHOD=\"GET\">\n");
    $webpage->print("<table bgcolor=tan width=75% border=1 align=center>\n");
    $webpage->print("<tr>\n");
    $webpage->print("\t<td width=3 align=center>Show Operation Status</td>\n");
    $webpage->print("\t<td width=3 align=center>Show Alert History</td>\n");
    $webpage->print("\t<td width=3 align=center>List Disabled Hosts</td>\n");
    $webpage->print("\t<td width=3 align=center>List PIDs for mon processes.</td>\n");
    $webpage->print("\t<td width=3 align=center>Restart Mon</td>\n");
    $webpage->print("</tr>\n");
    $webpage->print("\t<tr><td width=3 align=center><$button VALUE=\"opstatus\"></td>\n");
    $webpage->print("\t<td width=3 align=center><$button VALUE=\"alerthist\"></td>\n");
    $webpage->print("\t<td width=3 align=center><$button VALUE=\"disabled\"></td>\n");
    $webpage->print("\t<td width=3 align=center><$button VALUE=\"pids\"></td>\n");
    $webpage->print("\t<td width=3 align=center><$button VALUE=\"reset\"></td>\n");
    $webpage->print("</tr></table>");


    $webpage->print("</form>\n");
}


# Extract the data from moncmd list opstatus ---------------------------
sub query_opstatus {
    local($last, $next, $status, $group, $service);

    open (IN, "$moncmd -s $monhost list opstatus|") || die;
    while (<IN>) {
	if (!(m/^220 list opstatus/)) {
	    ($group, $service, $lasttime, $nexttime, $status) =
		split(/[ \t]+/,$_);
	    $report{"$group:$service"} = 
		"$lasttime:$nexttime:$status";
	}
    }

    $webpage->print("<table align=center border=1 width=35%>");
    $webpage->print
	("<tr><td><font color=black>Service color legend:</font></td>\n");
    $webpage->print("<td><font color=black>Unchecked</font></td>\n");
    $webpage->print("<td><font color=green>Good</font></td>\n ");
    $webpage->print("<td><font color=red>Error</font></td></tr>\n");
    $webpage->print("</table>");    

    $webpage->print
	("<table align=center width=80% border=1>\n");
    $webpage->print
	("<tr><th>Host Group</th><th>Service</th>\n");
    $webpage->print
	("<th>Last Checked</th><th>Est. Next Check</th></tr>\n");
    foreach $item (sort keys %report) {
	($group, $service) = split(/:/, $item);
	($last, $next, $status) = 
	    split(/:/, $report{"$group:$service"});

	$webpage->print("<tr><td>\n");
	$webpage->print
	    ("<a href=\"$url?command=group&args=$group\">");
	$webpage->print("$group</a></td>\n");

	if ($status =~ "untested") {
	    $webpage->print("<td><font color=black>\n");
	    $webpage->print("$service</font></td>");
	}
	elsif (!($status =~ "succeeded")) {
	    $webpage->print("<td><blink>");
	    $webpage->print
		("<a href=\"$url?command=alert&args=$group,$service\">");
	    $webpage->print
		("<font color=red>$service</font></a></blink></td>\n");
	}
	else {
	    $webpage->print("<td><font color=green>");
	    $webpage->print("$service</font></td>\n");
	}

	if (!($status =~ "untested")) {
	    @time = localtime($last);
	    $ttime = sprintf
		("<td>%.2d:%.2d:%.2d</td>\n",$time[2],$time[1],$time[0]);
	    $webpage->print("$ttime");
	}
	else {
	    $webpage->print("<td>-</td>");
	}

	@time = localtime($qtime+$next);
	$ttime = sprintf
	    ("<td>%.2d:%.2d:%.2d</td>\n",$time[2],$time[1],$time[0]);
	$webpage->print("$ttime\n");
	$webpage->print("</tr>");
    }
    $webpage->print("</table>\n");    
}


# Extract the list of hosts associated with the group ---------------
sub query_group {
    $group = $args;
    if ($group =~ /^(\w+)$/) {
	$group = $1;
	open (IN, "$moncmd -s $monhost list group \Q$group\E|") || 
	    die;
	@hosts = split(/[ \t]+/, <IN>);
	$end = @hosts;
	$webpage->print("<table align=center width=50% border=1>");
	$webpage->print("<th>Members of group \"<em>$group</em>\".</th>") ;    
	foreach $host (sort @hosts[2..$end-1]) {
	    $webpage->print("<tr><td>$host</td></tr>") ;
	}
	$webpage->print("</table>");
    }
    else {
	$webpage->print("Invalid host group\n");
    }
}


# End the document -----------------------------------------------------
sub end_page {
    &print_bar;
    if ($monadmin) {
	print $webpage->center
	    ("For questions about this server. Contact:<br>");
	print $webpage->center
	    ("<a href=\"mailto:$monadmin\">$monadmin</a><br>");
    }
    print $webpage->end_html;
}


# Get the params from the form -----------------------------------------
sub get_params {
    $command = $webpage->param('command');
    $args = $webpage->param('args');
}


# What to do if the view alert details is depressed --------------------
sub alert {
    local ($arg) = @_;
    ($group, $service) = split (/\,/, $arg);
    print $webpage->hr;
    $webpage->print
	("<h2>Hosts in group <font color=red>$group</font> ");
    $webpage->print
	("that failed the <i>$service</i> test:</h2>");
    open (IN, "$moncmd -s $monhost list opstatus|") || 
	die;
    while (<IN>) {
	@status = split(/[ \t]+/,$_);
	if (($status[0] =~ $group) && ($status[1] =~ $service)) {
	    $size = @status;
	    for ($i=5 ; $i<$size ; $i++) {
		$webpage->print("$status[$i]<br>\n");
	    }
	}
    }
    print $webpage->hr;
}

# List alert history --------------------------------------------------
sub alerthist {
    print $webpage->hr;
    print $webpage->h2("Alert History:");
    open (IN, "$moncmd -s $monhost list alerthist|") ||
	die;

    $webpage->print("<table border=1 width=80% align=center>\n");

    $webpage->print("<tr><th>Group</th><th>Service</th>\n");
    $webpage->print("<th>Time</th><th>Alert</th>\n");
    $webpage->print("<th>Notified:</th><th>Host</th>\n");
    $webpage->print("</tr>\n");	

    while (<IN>) {
	if (!($_ =~ 220)) {
	    @details = split(/[\t ]+/, $_);
	    $db{$details[2]} = $_;
	}
    }

    foreach $line (sort backwards (keys %db)) {
	@details = split(/[\t ]+/, $db{$line});
	$localtime = localtime($details[2]);	
	$webpage->print("<tr><td><a href=\"$url?command=group&");
	$webpage->print("args=$details[0]\">$details[0]</a></td>");

        $webpage->print("<td>$details[1]</td>\n");
	$webpage->print("<td>$localtime</td><td>$details[3]</td>\n");
	$webpage->print("<td>$details[4]</td>\n");

	$size = @details;
	$webpage->print("<td>");
	for ($i=5 ; $i<$size ; $i++) {
	    $webpage->print("$details[$i]<br>\n");
	}
	$webpage->print("</td>");
	$webpage->print("</tr>\n");
    }

    $webpage->print("</table>\n");	
    print $webpage->hr;    
}


# Generic button function ---------------------------------------------
sub button {
    local ($title, $command) = @_;

    print $webpage->hr;
    print $webpage->h2("$title");
    open (IN, "$moncmd -s $monhost $command|") ||
	die;
    while (<IN>) {
	print "$_<br>\n";
    }
    print $webpage->hr;
}


# Main program ---------------------------------------------------------

&get_params;				       # Read the args.

if ($command =~ "group" ){		       # Expand hostgroup.
    &setup_page("Group Expansion");
    &query_group;
}
elsif ($command =~ "alerthist"){	       # Alert history button.
    &setup_page("List the alert history");
    &alerthist;
}
elsif ($command =~ "alert"){		       # View alert details.
    &setup_page("Alert Details");
    &alert($args);
}
elsif ($command =~ "disabled"){		       # Disabled hosts button.
    &setup_page("List disabled hosts");
    &button("Disabled hosts:","list disabled");
}
elsif ($command =~ "pids"){		       # View pid button.
    &setup_page("List pids of server, alerts and monitors.");
    &button("List pids for all mon processes:", "list pids");
}
elsif ($command =~ "reset"){		       # Reset mon button.
    &setup_page("Restart Mon.");
    &button("Attempting to reset mon...","reset");
}
# Button "opstatus" will fall through to else.
else {					       # All else.
    &setup_page("Operation Status");
    &query_opstatus;
}

&end_page;


# That's it! ----------------------------------------------------
