/*
	va1000_ioctl.h - IOCTL codes for VA 1000 SMBus kernel module

	Copyright (c) 2000 Jerry Katzung and VA Linux Systems

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _VA1000_IOCTL_H
#define _VA1000_IOCTL_H

/* ioctl commands for the "va1000_smbus" module */

#define VA1000_SMBUS_HOST_TRANSFER	0x3235
#define VA1000_SMBUS_RETIRE		0x3236

/* struct and defines for "VA1000_SMBUS_HOST_TRANSFER/_RETIRE" */

typedef struct {
	unsigned char	size;		/* Size of entire structure */
	unsigned char	status;
	unsigned char	type;		/* Host transaction type or slave */
	unsigned char	len;		/* Number of valid bytes in data[] */
	unsigned char	addr;		/* "Read" bit must be valid */
	unsigned char	cmd;		/* SMBus "command" */
	unsigned char	data[10];
} smbus_pkt;

/* "status" - host or slave status register bits for a transaction */

#define PIIX4_IO_ERROR		0xEE	/* Failed transaction */
#define PIIX4_INTERNAL_ERROR	0xEF	/* Bad transaction type */
#define PIIX4_IN_PROGRESS	0xFF	/* Transaction underway */

/* "type" - SMBus transaction types (encoded for use with the PIIX4) */

#define PIIX4_QUICK_WRITE	((0 << 2) + 0)
#define PIIX4_QUICK_READ	((0 << 2) + 1)
#define PIIX4_BYTE_WRITE	((1 << 2) + 0)
#define PIIX4_BYTE_READ		((1 << 2) + 1)
#define PIIX4_BYTE_DATA_WRITE	((2 << 2) + 0)
#define PIIX4_BYTE_DATA_READ	((2 << 2) + 1)
#define PIIX4_WORD_DATA_WRITE	((3 << 2) + 0)
#define PIIX4_WORD_DATA_READ	((3 << 2) + 1)
#define PIIX4_PROC_CALL		((4 << 2) + 0)
#define PIIX4_BLOCK_WRITE	((5 << 2) + 0)
#define PIIX4_BLOCK_READ	((5 << 2) + 1)

#define PIIX4_SLAVE		0xFF	/* slave transfer record */

/* "addr" modifier */

#define PIIX4_READ		0x01	/* Rd/Wr bit in address (1=Read) */

#endif
