#
# Makefile for VIM on the Amiga, using SAS/Lattice C 6.0 to 6.56
#
# Do NOT use the peephole optimizer with a version before 6.55!
# It messes up all kinds of things:
# For 6.0 and 6.1, expand_env() will not work correctly.
# For 6.2 and 6.3 the call to free_line in u_freeentry is wrong.
# Don't know about 6.50, might work...
# Version 6.56 seems to be working fine.
# You should use Manx Aztec C whenever possible.
#
# The prototypes from Manx and SAS are incompatible. If the prototypes
# were generated by Manx, first do "touch *.c; make proto" before "make".
# The prototypes generated on Unix work for both.
#
# Note: Not all dependencies are included. This was done to avoid having
#       to compile everything when a global variable or function is added.

#>>>>> choose options:

#ANSI CODES
ANSIOFF = *e[0m
BBOLD = *e[1m
WBOLD = *e[2m
ITALIC = *e[3m
UNDERLI = *e[4m
ANSIOFF = *e[0m
FCOL1 = *e[31m
FCOL2 = *e[32m
FCOL3 = *e[33m
FCOL4 = *e[34m
BCOL1 = *e[41m
BCOL2 = *e[42m
BCOL3 = *e[43m
BCOL4 = *e[44m


### See feature.h for a list of optionals.
### Any other defines can be included here.

DEFINES = DEF=NO_ARP DEF=AMIGA DEF=NEWSASC DEF=FEAT_GUI_AMIGA \
	    DEF="SASC=658" #" this fixes a bug in the syntax highlighting

#>>>>> if HAVE_TGETENT is defined termlib.o has to be used
#TERMLIB = termlib.o
TERMLIB =

#>>>>> choose NODEBUG for normal compiling, the other for debugging and
# profiling
# don't switch on debugging when generating proto files, it crashes the
# compiler.
DBG = NODEBUG
#DBG = DBG=FULLFLUSH
#DBG = DBG=LINE

#>>>>> choose NOOPTPEEP for 6.0 to 6.3, NOOPT for debugging
#OPTIMIZE=NOOPTPEEP OPT

# for 6.58 you can use the line below, but be warned it takes a loooonnnggg time
#OPTIMIZE=OPT  OPTIMIZERSCHEDULER OPTIMIZERTIME NoOPTIMIZERALIAS \
#	OptimizerComplexity=10 OptimizerDepth=10 OptimizerRecurDepth=10 \
#	OptimizerInLocal OPTPEEP
OPTIMIZE=OPT  OPTIMIZERTIME NoOPTIMIZERALIAS \
	OptimizerComplexity=10 OptimizerDepth=10 OptimizerRecurDepth=10 \
	OptimizerInLocal OPTPEEP
#OPTIMIZE = NOOPT

# no optimization, (works on all platforms)
#OPTIMIZE=NOOPT

#generate code for your processor - note however, that the 060 selection will work for 040's
# as well.
#CPU=68000
#CPU=68020
#CPU=68030
#CPU=68040
CPU=68060


#Error reporting - I use rexx for reporting, but console reporting may be more
#useful for some people.
#ERROR = ERRORCONSOLE ERRORSOURCE ERRORHIGHLIGHT
ERROR = ERRORREXX ERRORCONSOLE ERRORSOURCE ERRORHIGHLIGHT


#memory types, if you have fast use it :->,
#	ANY = will work on all machines
#	FAST = this is the best option, for speed
#	CHIP = not necessary for this application.
#MEMORYTYPE=FAST
MEMORYTYPE=ANY

#MEMSIZE - this is for compile time only for speed of compilation
#default is LARGE
MEMSIZE=HUGE
#MEMSIZE=LARGE
#MEMSIZE=SMALL

#>>>>> end of choices
###########################################################################

CC = sc

GST=vim.gst
DEP = $(GST)


CFLAGS = NOLINK $(DBG)  CPU=$(CPU) NOSTACKCHECK
CFLAGS2 = $(OPTIMIZE) $(ERROR) GSTIMMEDIATE GST=$(GST)
CFLAGS3 =NOSINT SCODE SDATA STRINGMERGE MEMSIZE=$(MEMSIZE)
CFLAGS4 = $(DEFINES) DATAMEMORY=$(MEMORYTYPE)

PROPT = DEF=PROTO GPROTO GPPARM MAXIMUMERRORS=999 GENPROTOSTATICS GENPROTOPARAMETERS

SRC = \
	buffer.c \
	charset.c \
	diff.c \
	digraph.c \
	edit.c \
	eval.c \
	ex_cmds.c \
	ex_cmds2.c \
	ex_docmd.c \
	ex_eval.c \
	ex_getln.c \
	fileio.c \
	fold.c \
	getchar.c \
	main.c \
	mark.c \
	memfile.c \
	memline.c \
	menu.c \
	message.c \
	misc1.c \
	misc2.c \
	move.c \
	normal.c \
	ops.c \
	option.c \
	os_amiga.c \
	quickfix.c \
	regexp.c \
	screen.c \
	search.c \
	syntax.c \
	tag.c \
	term.c \
	ui.c \
	undo.c \
	window.c \
	version.c \
	gui_amiga.c \
	gui.c

OBJ = buffer.o charset.o diff.o digraph.o edit.o eval.o ex_cmds.o ex_cmds2.o ex_docmd.o ex_eval.o ex_getln.o \
	fileio.o fold.o getchar.o main.o mark.o memfile.o memline.o menu.o message.o misc1.o misc2.o move.o \
	normal.o ops.o option.o os_amiga.o quickfix.o regexp.o screen.o search.o syntax.o \
	tag.o term.o ui.o undo.o window.o gui_amiga.o gui.o  $(TERMLIB)

PRO = \
	buffer.pro \
	charset.pro \
	diff.pro \
	digraph.pro \
	edit.pro \
	eval.pro \
	ex_cmds.pro \
	ex_cmds2.pro \
	ex_docmd.pro \
	ex_eval.pro \
	ex_getln.pro \
	fileio.pro \
	fold.pro \
	getchar.pro \
	main.pro \
	mark.pro \
	memfile.pro \
	memline.pro \
	menu.pro \
	message.pro \
	misc1.pro \
	misc2.pro \
	move.pro \
	normal.pro \
	ops.pro \
	option.pro \
	os_amiga.pro \
	quickfix.pro \
	regexp.pro \
	screen.pro \
	search.pro \
	syntax.pro \
	tag.pro \
	term.pro \
	termlib.pro \
	ui.pro \
	undo.pro \
	window.pro \
	version.pro \
	gui_amiga.pro \
	gui.pro

all:
	@echo "$(BCOL2)building prototypes, this may take some time$(ANSIOFF)"
	@smake proto
	@echo "$(BCOL2)building vim production version$(ANSIOFF)"
	@smake vim

Vim: scoptions proto $(OBJ) version.c version.h
	$(CC) $(CFLAGS) version.c
	$(CC) LINK $(OPT) $(COPTS) $(OBJ) version.o $(DBG) PNAME=Vim

debug: scoption protos $(OBJ) version.c version.h
	$(CC) $(CFLAGS) version.c
	$(CC) LINK $(COPTS) $(OBJ) version.o $(DBG) PNAME=Vim

proto: $(PRO)

tags: $(SRC)
	spat ctags $(SRC) *.h
	#csh -c ctags $(SRC) *.h

# can't use delete here, too many file names
clean:
	@echo removing all object files
	-delete $(OBJ) >nil:

clobber: clean
	@echo removing all prototype files
	-delete $(PRO) SCOPTIONS vim $(GST) > NIL:


# generate an options file, as there is no way the amiga command line can handle the
# lengths that this makefile will impose on the shell.
scoptions: smakefile
	@echo "$(BCOL2)Generating $(ANSIOFF)$(FCOL4)- $@$(ANSIOFF)"
	@echo $(CFLAGS) > scoptions
	@echo $(CFLAGS1) >> scoptions
	@echo $(CFLAGS2) >> scoptions
	@echo $(CFLAGS3) >> scoptions
	@echo $(CFLAGS4) >> scoptions
	@echo $(COPTS) >>scoptions
	@echo scoptions has been built


#generate GlobalSymbolTable, which both speeds up the compile time, but also
#solves some problems with prototypes, and types  that are defined in a unixy
#manner.
#
#I use a preprocessing stage here to work arounda bug in the GST generator, in
#that it does not handle nested makefiles properly in this stage.
$(GST): scoptions vim.h keymap.h macros.h ascii.h term.h structs.h gui.h gui_amiga.h
	@echo "$(BCOL2)Generating Global Symbol Table $(ANSIOFF)$(FCOL4) $(GST) $(ANSIOFF)"
	$(CC) PREPROCESSORONLY gui_amiga.h  objectname pre.h
	$(CC)  MGST=$(GST) pre.h ignore=105,316
	del pre.h


###########################################################################

.c.o:
	@echo "$(BCOL2)Generating object for $(ANSIOFF)$(FCOL4) $*.c -> $@$(ANSIOFF)"
	$(CC) $*.c

.c.pro:
	@echo "$(BCOL2)Generating prototypes for $(ANSIOFF)$(FCOL4) $*.c -> $@$(ANSIOFF)"
	@$(CC) NOERRORREXX GPFILE=$*.pro $(PROPT) $*.c ignore=306,316,317,304

$(PRO): $(GST)
$(OBJ): $(GST)

# dependancies
buffer.o:	buffer.c $(DEP)
buffer.pro:	buffer.c $(DEP)
charset.o:	charset.c  $(DEP)
charset.pro:	charset.c $(DEP)
diff.o:		diff.c  $(DEP)
diff.pro:	diff.c $(DEP)
digraph.o:	digraph.c  $(DEP)
digraph.pro:	digraph.c $(DEP)
edit.o:		edit.c  $(DEP)
edit.pro:	edit.c   $(DEP)
eval.o:		eval.c  $(DEP)
eval.pro:	eval.c  $(DEP)
ex_cmds.o:	ex_cmds.c $(DEP)
ex_cmds.pro:	ex_cmds.c  $(DEP)
ex_cmds2.o:	ex_cmds2.c $(DEP)
ex_cmds2.pro:	ex_cmds2.c $(DEP)
ex_docmd.o:	ex_docmd.c ex_cmds.h  $(DEP)
ex_docmd.pro:	ex_docmd.c ex_cmds.h $(DEP)
ex_eval.o:	ex_eval.c ex_cmds.h  $(DEP)
ex_eval.pro:	ex_eval.c ex_cmds.h $(DEP)
ex_getln.o:	ex_getln.c  $(DEP)
ex_getln.pro:	ex_getln.c  $(DEP)
fileio.o:	fileio.c  $(DEP)
fileio.pro:	fileio.c   $(DEP)
fold.o:		fold.c  $(DEP)
fold.pro:	fold.c   $(DEP)
getchar.o:	getchar.c  $(DEP)
getchar.pro:	getchar.c $(DEP)
main.o:		main.c globals.h $(DEP)
main.pro:	main.c globals.h $(DEP)
mark.o:		mark.c  $(DEP)
mark.pro:	mark.c $(DEP)
memfile.o:	memfile.c  $(DEP)
memfile.pro:	memfile.c $(DEP)
memline.o:	memline.c  $(DEP)
memline.pro:	memline.c $(DEP)
menu.o:		menu.c  $(DEP)
menu.pro:	menu.c $(DEP)
message.o:	message.c  $(DEP)
message.pro:	message.c $(DEP)
misc1.o:	misc1.c  $(DEP)
misc1.pro:	misc1.c  $(DEP)
misc2.o:	misc2.c  $(DEP)
misc2.pro:	misc2.c $(DEP)
move.o:		move.c  $(DEP)
move.pro:	move.c $(DEP)
normal.o:	normal.c  $(DEP)
normal.pro:	normal.c $(DEP)
ops.o:		ops.c  $(DEP)
ops.pro:	ops.c  $(DEP)
option.o:	option.c  $(DEP)
option.pro:	option.c   $(DEP)
os_amiga.o:	os_amiga.c  $(DEP)
os_amiga.pro:	os_amiga.c  $(DEP)
quickfix.o:	quickfix.c  $(DEP)
quickfix.pro:	quickfix.c  $(DEP)
regexp.o:	regexp.c  $(DEP)
regexp.pro:	regexp.c  $(DEP)
screen.o:	screen.c  $(DEP)
screen.pro:	screen.c  $(DEP)
search.o:	search.c  $(DEP)
search.pro:	search.c  $(DEP)
syntax.o:	syntax.c   $(DEP)
syntax.pro:	syntax.c  $(DEP)
tag.o:		tag.c   $(DEP)
tag.pro:	tag.c   $(DEP)
term.o:		term.c   $(DEP)
term.pro:	term.c  $(DEP)
termlib.o:	termlib.c   $(DEP)
termlib.pro:	termlib.c  $(DEP)
ui.o:		ui.c   $(DEP)
ui.pro:		ui.c  $(DEP)
undo.o:		undo.c   $(DEP)
undo.pro:	undo.c  $(DEP)
window.o:	window.c   $(DEP)
window.pro:	window.c  $(DEP)
gui_amiga.o:	gui_amiga.c $(DEP) amiga.h
#gui_amiga.pro:	gui_amiga.c $(DEP) amiga.h
amiga.o:	amiga.c $(DEP) amiga.h
amiga.pro:	amiga.c $(DEP) amiga.h
gui.o:		gui.c   $(DEP)
gui.pro:	gui.c  $(DEP)
