# VERSION is subbed out during rake srpm process
%global realversion 0.9.0
%global rpmversion 0.9.0
%global confdir ext/redhat

Summary:        flexible discovery and provisioning solution for bare metal and virtual machines
Name:           puppet-razor
Version:        %{rpmversion}
Release:        1%{?dist}
Vendor:         %{?_host_vendor}
License:        ASL 2.0
Group:          System Environment/Base
URL:            http://www.puppetlabs.com/puppet/related-projects/%{name}
# Note this     URL will only be valid at official tags from Puppet Labs
Source0:        http://puppetlabs.com/downloads/%{name}/%{name}-%{realversion}.tar.gz
BuildArch:      noarch

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Requires:       ruby >= 1.8.7
Requires:       which
Requires:       ruby(abi) >= 1.8
Requires:       ruby-devel >= 1.8.7
Requires:       rubygems
Requires:       sudo
Requires:       gcc
Requires:       make
Requires:       mongo-10gen-server
Requires:       curl
Requires:       nodejs
Requires:       npm

%description
Razor is a full-stack solution for managing the full bare metal and
virtual machine lifecycle, designed to scale from small deployments
to clusters of hundreds of thousands of physical machines.

It melds together dynamic discovery of machine properties, simple models
of current and desired state, and a flexible policy engine to easily
express configuration for networks at any scale.

Razor also focuses beyond the simple "OS installation" scenario, and is
designed to enable complex models such as "upgrade firmware, then install",
or "decommission, securely wipe disks, rediscover, and reprovision".

Unlike many tools, Razor focuses on doing one job extremely well, and
handling on responsibility.  Once the basic configuration is done, Razor
will hand the system to a configuration management broker like Puppet
to provide ongoing change management - or it can simple stop, hands off,
for manual management.

It also focuses heavily on providing extension points and hooks to allow
you to model your needs.  It is deliberately agnostic to platform, OS,
and configuration broker choices.



%pre
# Only apply this rule if we are a first-time install - if there was no old
# version installed before we started.
if test x"$1" = x"1"; then
    if test -d "/opt/razor/.git"; then
        echo "As a transitional measure, the Puppet Razor packages" >&2
        echo "will not install if /opt/razor/.git exists as a directory." >&2
        echo "" >&2
        echo "This is to avoid breaking potentially custom installations" >&2
        echo "that predate any install method other than git(1) clones." >&2
        echo "" >&2
        echo "Please move the older install out of the way before you" >&2
        echo "try to install this package again, and sorry for the" >&2
        echo "inconvenience this doubtless causes you." >&2
        echo "" >&2
        echo "This check only applies on the *first* installation of" >&2
        echo "the new packages.  Upgrades will work fine even if the" >&2
        echo "git directory is present." >&2
        exit 1
    fi
fi


%prep
%setup -q  -n %{name}-%{realversion}

%build

%install
mkdir -p %{buildroot}/opt/razor
for file in [A-Z]* bin conf ext image/README lib log/README tmp/README; do
  mkdir -p %{buildroot}/opt/razor/"$(dirname "${file}")"
  cp -pr "${file}" %{buildroot}/opt/razor/"${file}"
done

install -Dp -m0755 %{confdir}/puppet-razor.init %{buildroot}%{_initrddir}/puppet-razor


%clean
rm -rf %{buildroot}


%files
%defattr(-,root,root,-)
%doc LICENSE README.md CONTRIBUTING.md
/opt/razor
%{_initrddir}/puppet-razor

%changelog
* Fri Mar 01 2013 Puppet Labs Release <info@puppetlabs.com> -  0.9.0-1
- Build for 0.9.0
