/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.opto.Invalidator;

public class Colon3Node
extends Node
implements INameNode {
    protected String name;
    protected ConstantCache cache;

    public Colon3Node(ISourcePosition position, String name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.COLON3NODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitColon3Node(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name2) {
        this.name = name2;
        this.cache = null;
    }

    public RubyModule getEnclosingModule(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        return runtime.getObject();
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject value2 = this.getValue(context);
        return value2 != null ? value2 : runtime.getObject().getConstantFromConstMissing(this.name);
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        try {
            RubyClass left2 = runtime.getObject();
            return Helpers.getDefinedConstantOrBoundMethod(left2, this.name);
        }
        catch (JumpException jumpException) {
            return null;
        }
    }

    public IRubyObject getValue(ThreadContext context) {
        ConstantCache cache = this.cache;
        return ConstantCache.isCached(cache) ? cache.value : this.reCache(context, this.name);
    }

    public IRubyObject reCache(ThreadContext context, String name2) {
        Ruby runtime = context.runtime;
        Invalidator invalidator = runtime.getConstantInvalidator(name2);
        Object newGeneration = invalidator.getData();
        IRubyObject value2 = runtime.getObject().getConstantFromNoConstMissing(name2, false);
        this.cache = value2 != null ? new ConstantCache(value2, newGeneration, invalidator) : null;
        return value2;
    }
}

