/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.jms.client.HornetQMessage;

public class HornetQStreamMessage
extends HornetQMessage
implements StreamMessage {
    public static final byte TYPE = 6;
    private int len;

    protected HornetQStreamMessage(ClientSession session) {
        super((byte)6, session);
    }

    protected HornetQStreamMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public HornetQStreamMessage(StreamMessage foreign, ClientSession session) throws JMSException {
        super((Message)foreign, (byte)6, session);
        foreign.reset();
        try {
            while (true) {
                Object obj = foreign.readObject();
                this.writeObject(obj);
            }
        }
        catch (MessageEOFException messageEOFException) {
            return;
        }
    }

    public HornetQStreamMessage() {
        this.message = new ClientMessageImpl(0, false, 0L, 0L, 4, 1500);
    }

    @Override
    public byte getType() {
        return 6;
    }

    public boolean readBoolean() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBuffer().readByte();
            switch (type) {
                case 2: {
                    return this.getBuffer().readBoolean();
                }
                case 10: {
                    String s = this.getBuffer().readNullableString();
                    return Boolean.valueOf(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public byte readByte() throws JMSException {
        this.checkRead();
        int index = this.getBuffer().readerIndex();
        try {
            byte type = this.getBuffer().readByte();
            switch (type) {
                case 3: {
                    return this.getBuffer().readByte();
                }
                case 10: {
                    String s = this.getBuffer().readNullableString();
                    return Byte.parseByte(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
        catch (NumberFormatException e) {
            this.getBuffer().readerIndex(index);
            throw e;
        }
    }

    public short readShort() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBuffer().readByte();
            switch (type) {
                case 3: {
                    return this.getBuffer().readByte();
                }
                case 5: {
                    return this.getBuffer().readShort();
                }
                case 10: {
                    String s = this.getBuffer().readNullableString();
                    return Short.parseShort(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public char readChar() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBuffer().readByte();
            switch (type) {
                case 11: {
                    return (char)this.getBuffer().readShort();
                }
                case 10: {
                    String str = this.getBuffer().readNullableString();
                    if (str == null) {
                        throw new NullPointerException("Invalid conversion");
                    }
                    throw new MessageFormatException("Invalid conversion");
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readInt() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBuffer().readByte();
            switch (type) {
                case 3: {
                    return this.getBuffer().readByte();
                }
                case 5: {
                    return this.getBuffer().readShort();
                }
                case 6: {
                    return this.getBuffer().readInt();
                }
                case 10: {
                    String s = this.getBuffer().readNullableString();
                    return Integer.parseInt(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public long readLong() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBuffer().readByte();
            switch (type) {
                case 3: {
                    return this.getBuffer().readByte();
                }
                case 5: {
                    return this.getBuffer().readShort();
                }
                case 6: {
                    return this.getBuffer().readInt();
                }
                case 7: {
                    return this.getBuffer().readLong();
                }
                case 10: {
                    String s = this.getBuffer().readNullableString();
                    return Long.parseLong(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public float readFloat() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBuffer().readByte();
            switch (type) {
                case 8: {
                    return Float.intBitsToFloat(this.getBuffer().readInt());
                }
                case 10: {
                    String s = this.getBuffer().readNullableString();
                    return Float.parseFloat(s);
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public double readDouble() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBuffer().readByte();
            switch (type) {
                case 8: {
                    return Float.intBitsToFloat(this.getBuffer().readInt());
                }
                case 9: {
                    return Double.longBitsToDouble(this.getBuffer().readLong());
                }
                case 10: {
                    String s = this.getBuffer().readNullableString();
                    return Double.parseDouble(s);
                }
            }
            throw new MessageFormatException("Invalid conversion: " + type);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public String readString() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBuffer().readByte();
            switch (type) {
                case 2: {
                    return String.valueOf(this.getBuffer().readBoolean());
                }
                case 3: {
                    return String.valueOf(this.getBuffer().readByte());
                }
                case 5: {
                    return String.valueOf(this.getBuffer().readShort());
                }
                case 11: {
                    return String.valueOf((char)this.getBuffer().readShort());
                }
                case 6: {
                    return String.valueOf(this.getBuffer().readInt());
                }
                case 7: {
                    return String.valueOf(this.getBuffer().readLong());
                }
                case 8: {
                    return String.valueOf(Float.intBitsToFloat(this.getBuffer().readInt()));
                }
                case 9: {
                    return String.valueOf(Double.longBitsToDouble(this.getBuffer().readLong()));
                }
                case 10: {
                    return this.getBuffer().readNullableString();
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkRead();
        try {
            if (this.len == -1) {
                this.len = 0;
                return -1;
            }
            if (this.len == 0) {
                byte type = this.getBuffer().readByte();
                if (type != 4) {
                    throw new MessageFormatException("Invalid conversion");
                }
                this.len = this.getBuffer().readInt();
            }
            int read = Math.min(value.length, this.len);
            this.getBuffer().readBytes(value, 0, read);
            this.len -= read;
            if (this.len == 0) {
                this.len = -1;
            }
            return read;
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public Object readObject() throws JMSException {
        this.checkRead();
        try {
            byte type = this.getBuffer().readByte();
            switch (type) {
                case 2: {
                    return this.getBuffer().readBoolean();
                }
                case 3: {
                    return this.getBuffer().readByte();
                }
                case 5: {
                    return this.getBuffer().readShort();
                }
                case 11: {
                    return Character.valueOf((char)this.getBuffer().readShort());
                }
                case 6: {
                    return this.getBuffer().readInt();
                }
                case 7: {
                    return this.getBuffer().readLong();
                }
                case 8: {
                    return Float.valueOf(Float.intBitsToFloat(this.getBuffer().readInt()));
                }
                case 9: {
                    return Double.longBitsToDouble(this.getBuffer().readLong());
                }
                case 10: {
                    return this.getBuffer().readNullableString();
                }
                case 4: {
                    int len = this.getBuffer().readInt();
                    byte[] bytes = new byte[len];
                    this.getBuffer().readBytes(bytes);
                    return bytes;
                }
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)2);
        this.getBuffer().writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)3);
        this.getBuffer().writeByte(value);
    }

    public void writeShort(short value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)5);
        this.getBuffer().writeShort(value);
    }

    public void writeChar(char value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)11);
        this.getBuffer().writeShort((short)value);
    }

    public void writeInt(int value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)6);
        this.getBuffer().writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)7);
        this.getBuffer().writeLong(value);
    }

    public void writeFloat(float value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)8);
        this.getBuffer().writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)9);
        this.getBuffer().writeLong(Double.doubleToLongBits(value));
    }

    public void writeString(String value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)10);
        this.getBuffer().writeNullableString(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)4);
        this.getBuffer().writeInt(value.length);
        this.getBuffer().writeBytes(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)4);
        this.getBuffer().writeInt(length);
        this.getBuffer().writeBytes(value, offset, length);
    }

    public void writeObject(Object value) throws JMSException {
        if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value == null) {
            this.writeString(null);
        } else {
            throw new MessageFormatException("Invalid object type: " + value.getClass());
        }
    }

    public void reset() throws JMSException {
        if (!this.readOnly) {
            this.readOnly = true;
        }
        this.getBuffer().resetReaderIndex();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.getBuffer().clear();
    }

    @Override
    public void doBeforeSend() throws Exception {
        this.reset();
    }

    private HornetQBuffer getBuffer() {
        return this.message.getBodyBuffer();
    }
}

