/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalFileImpl;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.journal.HornetQJournalLogger;

public class JournalFilesRepository {
    private static final boolean trace = HornetQJournalLogger.LOGGER.isTraceEnabled();
    private static final boolean CHECK_CONSISTENCE = false;
    private final SequentialFileFactory fileFactory;
    private final JournalImpl journal;
    private final BlockingDeque<JournalFile> dataFiles = new LinkedBlockingDeque<JournalFile>();
    private final ConcurrentLinkedQueue<JournalFile> freeFiles = new ConcurrentLinkedQueue();
    private final BlockingQueue<JournalFile> openedFiles = new LinkedBlockingQueue<JournalFile>();
    private final AtomicLong nextFileID = new AtomicLong(0L);
    private final int maxAIO;
    private final int minFiles;
    private final int fileSize;
    private final String filePrefix;
    private final String fileExtension;
    private final int userVersion;
    private Executor openFilesExecutor;
    private final Runnable pushOpenRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                JournalFilesRepository.this.pushOpenedFile();
            }
            catch (Exception e) {
                HornetQJournalLogger.LOGGER.errorPushingFile(e);
            }
        }
    };

    private static final void trace(String message) {
        HornetQJournalLogger.LOGGER.trace(message);
    }

    public JournalFilesRepository(SequentialFileFactory fileFactory, JournalImpl journal, String filePrefix, String fileExtension, int userVersion, int maxAIO, int fileSize, int minFiles) {
        if (filePrefix == null) {
            throw new IllegalArgumentException("filePrefix cannot be null");
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException("fileExtension cannot be null");
        }
        if (maxAIO <= 0) {
            throw new IllegalArgumentException("maxAIO must be a positive number");
        }
        this.fileFactory = fileFactory;
        this.maxAIO = maxAIO;
        this.filePrefix = filePrefix;
        this.fileExtension = fileExtension;
        this.minFiles = minFiles;
        this.fileSize = fileSize;
        this.userVersion = userVersion;
        this.journal = journal;
    }

    public void setExecutor(Executor fileExecutor) {
        this.openFilesExecutor = fileExecutor;
    }

    public void clear() throws Exception {
        this.dataFiles.clear();
        this.freeFiles.clear();
        for (JournalFile file : this.openedFiles) {
            try {
                file.getFile().close();
            }
            catch (Exception e) {
                HornetQJournalLogger.LOGGER.errorClosingFile(e);
            }
        }
        this.openedFiles.clear();
    }

    public int getMaxAIO() {
        return this.maxAIO;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void calculateNextfileID(List<JournalFile> files) {
        for (JournalFile file : files) {
            long fileIdFromFile = file.getFileID();
            long fileIdFromName = this.getFileNameID(file.getFile().getFileName());
            this.setNextFileID(Math.max(fileIdFromName, fileIdFromFile));
        }
    }

    public void setNextFileID(long targetUpdate) {
        long current;
        do {
            if ((current = this.nextFileID.get()) < targetUpdate) continue;
            return;
        } while (!this.nextFileID.compareAndSet(current, targetUpdate));
    }

    public void ensureMinFiles() throws Exception {
        int filesToCreate = this.minFiles - (this.dataFiles.size() + this.freeFiles.size());
        if (filesToCreate > 0) {
            for (int i = 0; i < filesToCreate; ++i) {
                this.freeFiles.add(this.createFile(false, false, true, false, -1L));
            }
        }
    }

    public void openFile(JournalFile file, boolean multiAIO) throws Exception {
        if (multiAIO) {
            file.getFile().open();
        } else {
            file.getFile().open(1, false);
        }
        file.getFile().position(file.getFile().calculateBlockStart(16));
    }

    public JournalFile[] getDataFilesArray() {
        return this.dataFiles.toArray(new JournalFile[this.dataFiles.size()]);
    }

    public JournalFile pollLastDataFile() {
        return (JournalFile)this.dataFiles.pollLast();
    }

    public void removeDataFile(JournalFile file) {
        if (!this.dataFiles.remove(file)) {
            HornetQJournalLogger.LOGGER.couldNotRemoveFile(file);
        }
    }

    public int getDataFilesCount() {
        return this.dataFiles.size();
    }

    public Collection<JournalFile> getDataFiles() {
        return this.dataFiles;
    }

    public void clearDataFiles() {
        this.dataFiles.clear();
    }

    public void addDataFileOnTop(JournalFile file) {
        this.dataFiles.addFirst(file);
    }

    public String debugFiles() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("**********\nCurrent File = " + this.journal.getCurrentFile() + "\n");
        buffer.append("**********\nDataFiles:\n");
        for (JournalFile file : this.dataFiles) {
            buffer.append(file.toString() + "\n");
        }
        buffer.append("*********\nFreeFiles:\n");
        for (JournalFile file : this.freeFiles) {
            buffer.append(file.toString() + "\n");
        }
        return buffer.toString();
    }

    public synchronized void checkDataFiles() {
        long seq = -1L;
        for (JournalFile file : this.dataFiles) {
            if (file.getFileID() <= seq) {
                HornetQJournalLogger.LOGGER.checkFiles();
                HornetQJournalLogger.LOGGER.info(this.debugFiles());
                HornetQJournalLogger.LOGGER.seqOutOfOrder();
                System.exit(-1);
            }
            if (this.journal.getCurrentFile() != null && this.journal.getCurrentFile().getFileID() <= file.getFileID()) {
                HornetQJournalLogger.LOGGER.checkFiles();
                HornetQJournalLogger.LOGGER.info(this.debugFiles());
                HornetQJournalLogger.LOGGER.currentFile(file.getFileID(), this.journal.getCurrentFile().getFileID(), file.getFileID(), this.journal.getCurrentFile() == file);
            }
            if (this.journal.getCurrentFile() == file) {
                throw new RuntimeException("Check failure! Current file listed as data file!");
            }
            seq = file.getFileID();
        }
        long lastFreeId = -1L;
        for (JournalFile file : this.freeFiles) {
            if (file.getFileID() <= lastFreeId) {
                HornetQJournalLogger.LOGGER.checkFiles();
                HornetQJournalLogger.LOGGER.info(this.debugFiles());
                HornetQJournalLogger.LOGGER.fileIdOutOfOrder();
                throw new RuntimeException("Check failure!");
            }
            lastFreeId = file.getFileID();
            if (file.getFileID() >= seq) continue;
            HornetQJournalLogger.LOGGER.checkFiles();
            HornetQJournalLogger.LOGGER.info(this.debugFiles());
            HornetQJournalLogger.LOGGER.fileTooSmall();
        }
    }

    public void addDataFileOnBottom(JournalFile file) {
        this.dataFiles.add(file);
    }

    public int getFreeFilesCount() {
        return this.freeFiles.size();
    }

    public synchronized void addFreeFile(JournalFile file, boolean renameTmp) throws Exception {
        this.addFreeFile(file, renameTmp, true);
    }

    public synchronized void addFreeFile(JournalFile file, boolean renameTmp, boolean checkDelete) throws Exception {
        long calculatedSize = 0L;
        try {
            calculatedSize = file.getFile().size();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Can't get file size on " + file);
            System.exit(-1);
        }
        if (calculatedSize != (long)this.fileSize) {
            HornetQJournalLogger.LOGGER.deletingFile(file);
            file.getFile().delete();
        } else if (!checkDelete || this.freeFiles.size() + this.dataFiles.size() + 1 + this.openedFiles.size() < this.minFiles) {
            if (trace) {
                JournalFilesRepository.trace("Adding free file " + file);
            }
            JournalFile jf = this.reinitializeFile(file);
            if (renameTmp) {
                jf.getFile().renameTo(JournalImpl.renameExtensionFile(jf.getFile().getFileName(), ".tmp"));
            }
            this.freeFiles.add(jf);
        } else {
            if (trace) {
                HornetQJournalLogger.LOGGER.trace("DataFiles.size() = " + this.dataFiles.size());
                HornetQJournalLogger.LOGGER.trace("openedFiles.size() = " + this.openedFiles.size());
                HornetQJournalLogger.LOGGER.trace("minfiles = " + this.minFiles);
                HornetQJournalLogger.LOGGER.trace("Free Files = " + this.freeFiles.size());
                HornetQJournalLogger.LOGGER.trace("File " + file + " being deleted as freeFiles.size() + dataFiles.size() + 1 + openedFiles.size() (" + (this.freeFiles.size() + this.dataFiles.size() + 1 + this.openedFiles.size()) + ") < minFiles (" + this.minFiles + ")");
            }
            file.getFile().delete();
        }
    }

    public Collection<JournalFile> getFreeFiles() {
        return this.freeFiles;
    }

    public JournalFile getFreeFile() {
        return (JournalFile)this.freeFiles.remove();
    }

    public int getOpenedFilesCount() {
        return this.openedFiles.size();
    }

    public JournalFile openFile() throws InterruptedException {
        if (trace) {
            JournalFilesRepository.trace("enqueueOpenFile with openedFiles.size=" + this.openedFiles.size());
        }
        if (this.openFilesExecutor == null) {
            this.pushOpenRunnable.run();
        } else {
            this.openFilesExecutor.execute(this.pushOpenRunnable);
        }
        JournalFile nextFile = null;
        while (nextFile == null) {
            nextFile = this.openedFiles.poll(5L, TimeUnit.SECONDS);
            if (nextFile != null) continue;
            HornetQJournalLogger.LOGGER.errorOpeningFile(new Exception("trace"));
        }
        if (trace) {
            JournalFilesRepository.trace("Returning file " + nextFile);
        }
        return nextFile;
    }

    public void pushOpenedFile() throws Exception {
        JournalFile nextOpenedFile = this.takeFile(true, true, true, false);
        if (trace) {
            JournalFilesRepository.trace("pushing openFile " + nextOpenedFile);
        }
        if (!this.openedFiles.offer(nextOpenedFile)) {
            HornetQJournalLogger.LOGGER.failedToAddFile(nextOpenedFile);
        }
    }

    public void closeFile(JournalFile file) throws Exception {
        this.fileFactory.deactivateBuffer();
        file.getFile().close();
        this.dataFiles.add(file);
    }

    public JournalFile takeFile(boolean keepOpened, boolean multiAIO, boolean initFile, boolean tmpCompactExtension) throws Exception {
        JournalFile nextFile = null;
        nextFile = this.freeFiles.poll();
        if (nextFile == null) {
            nextFile = this.createFile(keepOpened, multiAIO, initFile, tmpCompactExtension, -1L);
        } else {
            if (tmpCompactExtension) {
                SequentialFile sequentialFile = nextFile.getFile();
                sequentialFile.renameTo(sequentialFile.getFileName() + ".cmp");
            }
            if (keepOpened) {
                this.openFile(nextFile, multiAIO);
            }
        }
        return nextFile;
    }

    public JournalFile createRemoteBackupSyncFile(long fileID) throws Exception {
        return this.createFile(false, false, true, false, fileID);
    }

    private JournalFile createFile(boolean keepOpened, boolean multiAIO, boolean init, boolean tmpCompact, long fileIdPreSet) throws Exception {
        long fileID = fileIdPreSet != -1L ? fileIdPreSet : this.generateFileID();
        String fileName = this.createFileName(tmpCompact, fileID);
        if (trace) {
            JournalFilesRepository.trace("Creating file " + fileName);
        }
        String tmpFileName = fileName + ".tmp";
        SequentialFile sequentialFile = this.fileFactory.createSequentialFile(tmpFileName, this.maxAIO);
        sequentialFile.open(1, false);
        if (init) {
            sequentialFile.fill(0, this.fileSize, (byte)74);
            JournalImpl.initFileHeader(this.fileFactory, sequentialFile, this.userVersion, fileID);
        }
        long position = sequentialFile.position();
        sequentialFile.close();
        if (trace) {
            JournalFilesRepository.trace("Renaming file " + tmpFileName + " as " + fileName);
        }
        sequentialFile.renameTo(fileName);
        if (keepOpened) {
            if (multiAIO) {
                sequentialFile.open();
            } else {
                sequentialFile.open(1, false);
            }
            sequentialFile.position(position);
        }
        return new JournalFileImpl(sequentialFile, fileID, 2);
    }

    private String createFileName(boolean tmpCompact, long fileID) {
        String fileName = tmpCompact ? this.filePrefix + "-" + fileID + "." + this.fileExtension + ".cmp" : this.filePrefix + "-" + fileID + "." + this.fileExtension;
        return fileName;
    }

    private long generateFileID() {
        return this.nextFileID.incrementAndGet();
    }

    private long getFileNameID(String fileName) {
        try {
            return Long.parseLong(fileName.substring(this.filePrefix.length() + 1, fileName.indexOf(46)));
        }
        catch (Throwable e) {
            HornetQJournalLogger.LOGGER.errorRetrievingID(e, fileName);
            return 0L;
        }
    }

    private JournalFile reinitializeFile(JournalFile file) throws Exception {
        long newFileID = this.generateFileID();
        SequentialFile sf = file.getFile();
        sf.open(1, false);
        int position = JournalImpl.initFileHeader(this.fileFactory, sf, this.userVersion, newFileID);
        JournalFileImpl jf = new JournalFileImpl(sf, newFileID, 2);
        sf.position(position);
        sf.close();
        return jf;
    }

    public String toString() {
        return "JournalFilesRepository(dataFiles=" + this.dataFiles + ", freeFiles=" + this.freeFiles + ", openedFiles=" + this.openedFiles + ")";
    }
}

