/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.core.journal.impl.SyncIOCompletion;
import org.hornetq.journal.HornetQJournalLogger;

public final class SimpleWaitIOCallback
extends SyncIOCompletion {
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile String errorMessage;
    private volatile int errorCode = 0;

    public String toString() {
        return SimpleWaitIOCallback.class.getName();
    }

    @Override
    public void done() {
        this.latch.countDown();
    }

    @Override
    public void onError(int errorCode1, String errorMessage1) {
        this.errorCode = errorCode1;
        this.errorMessage = errorMessage1;
        HornetQJournalLogger.LOGGER.errorOnIOCallback(errorMessage1);
        this.latch.countDown();
    }

    @Override
    public void waitCompletion() throws InterruptedException, HornetQException {
        while (!this.latch.await(2L, TimeUnit.SECONDS)) {
        }
        if (this.errorMessage != null) {
            throw HornetQExceptionType.createException((int)this.errorCode, (String)this.errorMessage);
        }
    }

    public boolean waitCompletion(long timeout) throws InterruptedException, HornetQException {
        boolean retValue = this.latch.await(timeout, TimeUnit.MILLISECONDS);
        if (this.errorMessage != null) {
            throw HornetQExceptionType.createException((int)this.errorCode, (String)this.errorMessage);
        }
        return retValue;
    }

    @Override
    public void storeLineUp() {
    }
}

