/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt.eis;

import java.io.Serializable;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.eis.JavaUuidSessionIdGenerator;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;

public abstract class AbstractSessionDAO
implements SessionDAO {
    private SessionIdGenerator sessionIdGenerator = new JavaUuidSessionIdGenerator();

    public SessionIdGenerator getSessionIdGenerator() {
        return this.sessionIdGenerator;
    }

    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }

    protected Serializable generateSessionId(Session session) {
        if (this.sessionIdGenerator == null) {
            String msg = "sessionIdGenerator attribute has not been configured.";
            throw new IllegalStateException(msg);
        }
        return this.sessionIdGenerator.generateId(session);
    }

    public Serializable create(Session session) {
        Serializable sessionId = this.doCreate(session);
        this.verifySessionId(sessionId);
        return sessionId;
    }

    private void verifySessionId(Serializable sessionId) {
        if (sessionId == null) {
            String msg = "sessionId returned from doCreate implementation is null.  Please verify the implementation.";
            throw new IllegalStateException(msg);
        }
    }

    protected void assignSessionId(Session session, Serializable sessionId) {
        ((SimpleSession)session).setId(sessionId);
    }

    protected abstract Serializable doCreate(Session var1);

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        Session s = this.doReadSession(sessionId);
        if (s == null) {
            throw new UnknownSessionException("There is no session with id [" + sessionId + "]");
        }
        return s;
    }

    protected abstract Session doReadSession(Serializable var1);
}

