/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.client;

import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.loadbalance.RoundRobinConnectionLoadBalancingPolicy;
import org.hornetq.core.client.impl.ServerLocatorImpl;

public final class HornetQClient {
    public static final String DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME = RoundRobinConnectionLoadBalancingPolicy.class.getCanonicalName();
    public static final long DEFAULT_CLIENT_FAILURE_CHECK_PERIOD = HornetQDefaultConfiguration.getDefaultClientFailureCheckPeriod();
    public static final long DEFAULT_CONNECTION_TTL = HornetQDefaultConfiguration.getDefaultConnectionTtl();
    public static final int DEFAULT_MIN_LARGE_MESSAGE_SIZE = 102400;
    public static final boolean DEFAULT_COMPRESS_LARGE_MESSAGES = false;
    public static final int DEFAULT_CONSUMER_WINDOW_SIZE = 0x100000;
    public static final int DEFAULT_CONSUMER_MAX_RATE = -1;
    public static final int DEFAULT_CONFIRMATION_WINDOW_SIZE = -1;
    public static final int DEFAULT_PRODUCER_WINDOW_SIZE = 65536;
    public static final int DEFAULT_PRODUCER_MAX_RATE = -1;
    public static final boolean DEFAULT_BLOCK_ON_ACKNOWLEDGE = false;
    public static final boolean DEFAULT_BLOCK_ON_DURABLE_SEND = true;
    public static final boolean DEFAULT_BLOCK_ON_NON_DURABLE_SEND = false;
    public static final boolean DEFAULT_AUTO_GROUP = false;
    public static final long DEFAULT_CALL_TIMEOUT = 30000L;
    public static final long DEFAULT_CALL_FAILOVER_TIMEOUT = -1L;
    public static final int DEFAULT_ACK_BATCH_SIZE = 0x100000;
    public static final boolean DEFAULT_PRE_ACKNOWLEDGE = false;
    public static final long DEFAULT_DISCOVERY_INITIAL_WAIT_TIMEOUT = 10000L;
    public static final long DEFAULT_DISCOVERY_REFRESH_TIMEOUT = 10000L;
    public static final int DEFAULT_DISCOVERY_PORT = 9876;
    public static final long DEFAULT_RETRY_INTERVAL = 2000L;
    public static final double DEFAULT_RETRY_INTERVAL_MULTIPLIER = HornetQDefaultConfiguration.getDefaultRetryIntervalMultiplier();
    public static final long DEFAULT_MAX_RETRY_INTERVAL = HornetQDefaultConfiguration.getDefaultMaxRetryInterval();
    public static final int DEFAULT_RECONNECT_ATTEMPTS = 0;
    public static final int INITIAL_CONNECT_ATTEMPTS = 1;
    public static final boolean DEFAULT_FAILOVER_ON_INITIAL_CONNECTION = false;
    public static final boolean DEFAULT_IS_HA = false;
    public static final boolean DEFAULT_USE_GLOBAL_POOLS = true;
    public static final int DEFAULT_THREAD_POOL_MAX_SIZE = -1;
    public static final int DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE = 5;
    public static final boolean DEFAULT_CACHE_LARGE_MESSAGE_CLIENT = false;
    public static final int DEFAULT_INITIAL_MESSAGE_PACKET_SIZE = 1500;
    public static final boolean DEFAULT_XA = false;
    public static final boolean DEFAULT_HA = false;

    public static ServerLocator createServerLocatorWithoutHA(TransportConfiguration ... transportConfigurations) {
        return new ServerLocatorImpl(false, transportConfigurations);
    }

    public static ServerLocator createServerLocator(boolean ha, TransportConfiguration ... transportConfigurations) {
        return new ServerLocatorImpl(ha, transportConfigurations);
    }

    public static ServerLocator createServerLocatorWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
        return new ServerLocatorImpl(false, groupConfiguration);
    }

    public static ServerLocator createServerLocator(boolean ha, DiscoveryGroupConfiguration groupConfiguration) {
        return new ServerLocatorImpl(ha, groupConfiguration);
    }

    public static ServerLocator createServerLocatorWithHA(TransportConfiguration ... initialServers) {
        return new ServerLocatorImpl(true, initialServers);
    }

    public static ServerLocator createServerLocatorWithHA(DiscoveryGroupConfiguration groupConfiguration) {
        return new ServerLocatorImpl(true, groupConfiguration);
    }

    private HornetQClient() {
    }
}

