/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.net.InetAddress;

class ClientMapping {
    private final InetAddress sourceNetworkAddress;
    private final byte sourceNetworkMaskBits;
    private final String destinationAddress;
    private final int destinationPort;
    private final String cachedToString;

    ClientMapping(InetAddress sourceNetworkAddress, int sourceNetworkMaskBits, String destinationAddress, int destinationPort) {
        this.sourceNetworkAddress = sourceNetworkAddress;
        this.sourceNetworkMaskBits = (byte)sourceNetworkMaskBits;
        this.destinationAddress = destinationAddress;
        this.destinationPort = destinationPort;
        this.cachedToString = this.generateToString();
    }

    InetAddress getSourceNetworkAddress() {
        return this.sourceNetworkAddress;
    }

    int getSourceNetworkMaskBits() {
        return this.sourceNetworkMaskBits & 0xFF;
    }

    String getDestinationAddress() {
        return this.destinationAddress;
    }

    int getDestinationPort() {
        return this.destinationPort;
    }

    public String toString() {
        return this.cachedToString;
    }

    private String generateToString() {
        return "ClientMapping{sourceNetworkAddress=" + this.sourceNetworkAddress + ", sourceNetworkMaskBits=" + this.sourceNetworkMaskBits + ", destinationAddress='" + this.destinationAddress + '\'' + ", destinationPort=" + this.destinationPort + '}';
    }
}

