/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logmanager.CopyOnWriteMap;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;

public final class ClassLoaderLogContextSelector
implements LogContextSelector {
    private static final Permission REGISTER_LOG_CONTEXT_PERMISSION = new RuntimePermission("registerLogContext", null);
    private static final Permission UNREGISTER_LOG_CONTEXT_PERMISSION = new RuntimePermission("unregisterLogContext", null);
    private static final Permission LOG_API_PERMISSION = new RuntimePermission("logApiPermission", null);
    private static final Gateway GATEWAY = AccessController.doPrivileged(new PrivilegedAction<Gateway>(){

        @Override
        public Gateway run() {
            return new Gateway();
        }
    });
    private final LogContextSelector defaultSelector;
    private final ConcurrentMap<ClassLoader, LogContext> contextMap = new CopyOnWriteMap<ClassLoader, LogContext>();
    private final Set<ClassLoader> logApiClassLoaders = Collections.newSetFromMap(new CopyOnWriteMap());

    public ClassLoaderLogContextSelector(LogContextSelector defaultSelector) {
        this.defaultSelector = defaultSelector;
    }

    public ClassLoaderLogContextSelector() {
        this(LogContext.DEFAULT_LOG_CONTEXT_SELECTOR);
    }

    @Override
    public LogContext getLogContext() {
        for (Class caller : GATEWAY.getClassContext()) {
            LogContext context;
            ClassLoader classLoader = caller.getClassLoader();
            if (classLoader == null || this.logApiClassLoaders.contains(classLoader) || (context = (LogContext)this.contextMap.get(classLoader)) == null) continue;
            return context;
        }
        return this.defaultSelector.getLogContext();
    }

    public boolean addLogApiClassLoader(ClassLoader apiClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(LOG_API_PERMISSION);
        }
        return this.logApiClassLoaders.add(apiClassLoader);
    }

    public boolean removeLogApiClassLoader(ClassLoader apiClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(LOG_API_PERMISSION);
        }
        return this.logApiClassLoaders.remove(apiClassLoader);
    }

    public void registerLogContext(ClassLoader classLoader, LogContext logContext) throws IllegalArgumentException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REGISTER_LOG_CONTEXT_PERMISSION);
        }
        if (this.contextMap.putIfAbsent(classLoader, logContext) != null) {
            throw new IllegalArgumentException("ClassLoader instance is already registered to a log context (" + classLoader + ")");
        }
    }

    public boolean unregisterLogContext(ClassLoader classLoader, LogContext logContext) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(UNREGISTER_LOG_CONTEXT_PERMISSION);
        }
        return this.contextMap.remove(classLoader, logContext);
    }

    private static final class Gateway
    extends SecurityManager {
        private Gateway() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

