# Fact: hostname
#
# Purpose: Return the system's short hostname.
#
# Resolution:
#   On all system bar Darwin, parses the output of the "hostname" system command
#   to everything before the first period.
#   On Darwin, uses the system configuration util to get the LocalHostName
#   variable.
#
# Caveats:
#

Facter.add(:hostname) do
  setcode do
    hostname = nil
    if name = Facter::Core::Execution.exec('hostname')
      if name =~ /(.*?)\./
        hostname = $1
      else
        hostname = name
      end
    end
    hostname
  end
end

Facter.add(:hostname) do
  confine :kernel => :darwin, :kernelrelease => "R7"
  setcode do
    Facter::Core::Execution.exec('/usr/sbin/scutil --get LocalHostName')
  end
end
