Feature: Use step definitions generated by factories

  Scenario: create a post and verify its attributes
    Given the following post exists:
      | Title       | Body                |
      | a fun title | here is the content |
    Then I should find the following for the last post:
      | title       | body                |
      | a fun title | here is the content |

  Scenario: create a post without a table and verify its attributes
    Given a post exists with a title of "a fun title"
    Then I should find the following for the last post:
      | title       |
      | a fun title |

  Scenario: flexible English when creating posts
    Given an post exists with an title of "a fun title"
    Then I should find the following for the last post:
      | title       |
      | a fun title |

  Scenario: create a post with an underscore in an attribute name
    Given a post exists with an author ID of "5"
    Then I should find the following for the last post:
      | author_id |
      | 5         |

  Scenario: create several posts
    Given the following posts exist:
      | Title | Body   |
      | one   | first  |
      | two   | second |
      | three | third  |
    Then I should find the following for the last post:
      | title | body  |
      | three | third |
    And there should be 3 posts

  Scenario: create a post with a new author
    Given the following post exists:
      | Title   | Author   |
      | a title | ID: 123  |
    Then I should find the following for the last post:
      | title   | author_id |
      | a title | 123       |
    And I should find the following for the last user:
      | id  |
      | 123 |

  Scenario: create a post with an existing author
    Given the following user exists:
      | ID  | Name |
      | 123 | Joe  |
    And the following post exists:
      | Title   | Author    |
      | a title | Name: Joe |
    Then I should find the following for the last post:
      | title   | author_id |
      | a title | 123       |
    And there should be 1 user

  Scenario: create post with and without a category association
    Given the following users exist:
      | ID  | Name |
      | 123 | Joe  |
    And the following posts exist:
      | Title                      | Author    | Category          |
      | a title                    | Name: Joe | Name: programming |
      | a title without a category | Name: Joe |                   |
    Then I should find the following for the last post:
      | title                      | category_id |
      | a title without a category |             |

  Scenario: create a user without attributes
    Given a user exists
    Then there should be 1 user

  Scenario: create several users without attributes
    Given 3 users exist
    Then there should be 3 users

  Scenario: create several users with one attribute
    Given 3 users exist with a name of "John"
    Then there should be 3 users
    And I should find the following for the last user:
      | name |
      | John |

  Scenario: create instances of a factory with an underscore in its name
    Given an admin user exists with a name of "John"
    Then I should find the following for the last user:
      | name | admin |
      | John | true  |

  Scenario: create a several instances of a factory with an underscore in its name
    Given 3 admin users exist
    Then I should find the following for the last user:
      | admin |
      | true  |

  Scenario: use true values when creating instances
    Given the following user exists:
      | name | admin |
      | Bill | true  |
    Then I should find the following for the last user:
      | name | admin |
      | Bill | true  |

  Scenario: use false values when creating instances
    Given the following user exists:
      | name | admin |
      | Mike | false |
    Then I should find the following for the last user:
      | name | admin |
      | Mike | false |

  Scenario: Properly pluralize words
    Given the following categories exist:
      | name       |
      | Bed        |
      | Test Drive |
    And 2 categories exist
    And 2 categories exist with a name of "Future"
    Then there should be 6 categories
