/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Chmod {
    private static final boolean CHMOD_API_AVAILABLE;
    private static final Method setWritable;
    private static final Method setReadable;
    private static final Method setExecutable;

    public static int chmod(File file2, String mode2) {
        if (CHMOD_API_AVAILABLE) {
            char other = '0';
            if (mode2.length() >= 1) {
                other = mode2.charAt(mode2.length() - 1);
            }
            char user = '0';
            if (mode2.length() >= 3) {
                user = mode2.charAt(mode2.length() - 3);
            }
            if (!Chmod.setPermissions(file2, other, false)) {
                return -1;
            }
            if (!Chmod.setPermissions(file2, user, true)) {
                return -1;
            }
            return 0;
        }
        try {
            Process chmod2 = Runtime.getRuntime().exec("/bin/chmod " + mode2 + " " + file2.getAbsolutePath());
            chmod2.waitFor();
            return chmod2.exitValue();
        }
        catch (IOException chmod2) {
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return -1;
    }

    private static boolean setPermissions(File file2, char permChar, boolean userOnly) {
        int permValue = Character.digit(permChar, 8);
        try {
            if ((permValue & 1) != 0) {
                setExecutable.invoke((Object)file2, Boolean.TRUE, userOnly);
            } else {
                setExecutable.invoke((Object)file2, Boolean.FALSE, userOnly);
            }
            if ((permValue & 2) != 0) {
                setWritable.invoke((Object)file2, Boolean.TRUE, userOnly);
            } else {
                setWritable.invoke((Object)file2, Boolean.FALSE, userOnly);
            }
            if ((permValue & 4) != 0) {
                setReadable.invoke((Object)file2, Boolean.TRUE, userOnly);
            } else {
                setReadable.invoke((Object)file2, Boolean.FALSE, userOnly);
            }
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    static {
        boolean apiAvailable = false;
        Method setWritableVar = null;
        Method setReadableVar = null;
        Method setExecutableVar = null;
        try {
            setWritableVar = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
            setReadableVar = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            setExecutableVar = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            apiAvailable = true;
        }
        catch (Exception exception2) {
            // empty catch block
        }
        setWritable = setWritableVar;
        setReadable = setReadableVar;
        setExecutable = setExecutableVar;
        CHMOD_API_AVAILABLE = apiAvailable;
    }
}

