// Compiled by ClojureScript 0.0-3211 {}
goog.provide('puppetlabs.metrics.dashboard.metrics_box');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('cljs_time.core');
goog.require('reagent.core');
puppetlabs.metrics.dashboard.metrics_box.next_box_id = cljs.core.atom.call(null,(0));
puppetlabs.metrics.dashboard.metrics_box.width = (400);
puppetlabs.metrics.dashboard.metrics_box.height = (60);
puppetlabs.metrics.dashboard.metrics_box.margin = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"top","top",-1856271961),(10),new cljs.core.Keyword(null,"right","right",-452581833),(0),new cljs.core.Keyword(null,"bottom","bottom",-1550509018),(10),new cljs.core.Keyword(null,"left","left",-399115937),(50)], null);
puppetlabs.metrics.dashboard.metrics_box.w = ((puppetlabs.metrics.dashboard.metrics_box.width - new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(puppetlabs.metrics.dashboard.metrics_box.margin)) - new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(puppetlabs.metrics.dashboard.metrics_box.margin));
puppetlabs.metrics.dashboard.metrics_box.h = ((puppetlabs.metrics.dashboard.metrics_box.height - new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(puppetlabs.metrics.dashboard.metrics_box.margin)) - new cljs.core.Keyword(null,"bottom","bottom",-1550509018).cljs$core$IFn$_invoke$arity$1(puppetlabs.metrics.dashboard.metrics_box.margin));
puppetlabs.metrics.dashboard.metrics_box.date_subtract = (function puppetlabs$metrics$dashboard$metrics_box$date_subtract(date,millis){
return cljs_time.core.minus.call(null,date,cljs_time.core.millis.call(null,millis));
});
puppetlabs.metrics.dashboard.metrics_box.metrics_box_dom = (function puppetlabs$metrics$dashboard$metrics_box$metrics_box_dom(box_id,description,addendum){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"counterbox",new cljs.core.Keyword(null,"id","id",-1388402092),box_id], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"counterlabel"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"counterdesc"], null),description], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"counteraddendum"], null),addendum], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"countertext"], null),"??"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"countersparkline"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),puppetlabs.metrics.dashboard.metrics_box.width,new cljs.core.Keyword(null,"height","height",1025178622),puppetlabs.metrics.dashboard.metrics_box.height], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"countersvg",new cljs.core.Keyword(null,"transform","transform",1381301764),goog.string.format("translate(%s,%s)",new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(puppetlabs.metrics.dashboard.metrics_box.margin),new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(puppetlabs.metrics.dashboard.metrics_box.margin))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"y_axis",new cljs.core.Keyword(null,"transform","transform",1381301764),"translate(-1,0)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"clipPath","clipPath",-934619797),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),"clip"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rect","rect",-108902628),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),puppetlabs.metrics.dashboard.metrics_box.w,new cljs.core.Keyword(null,"height","height",1025178622),puppetlabs.metrics.dashboard.metrics_box.h], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"line_g"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"line"], null)], null)], null)], null)], null)], null)], null);
});
puppetlabs.metrics.dashboard.metrics_box.initialize_counterbox = (function puppetlabs$metrics$dashboard$metrics_box$initialize_counterbox(x_axis_domain,data_fn,counterbox_selection){
var x = d3.time.scale().domain(x_axis_domain).range([(0),puppetlabs.metrics.dashboard.metrics_box.w]);
var y = d3.scale.linear().range([puppetlabs.metrics.dashboard.metrics_box.h,(1)]);
var line = d3.svg.area().interpolate("linear").x(((function (x,y){
return (function (p1__13682_SHARP_){
return ((1) + x.call(null,p1__13682_SHARP_.time));
});})(x,y))
).y1((puppetlabs.metrics.dashboard.metrics_box.h + (1))).y0(((function (x,y){
return (function (p1__13683_SHARP_){
return y.call(null,p1__13683_SHARP_.value);
});})(x,y))
);
var axis = d3.svg.axis().scale(y).orient("left").ticks((3));
var svg_line_g = counterbox_selection.select(".line_g");
var svg_line_path = counterbox_selection.select(".line");
svg_line_g.attr("clip-path","url(#clip)");

svg_line_path.attr("d",line.call(null,[]));

y.axis = axis;

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"data-fn","data-fn",777152661),data_fn,new cljs.core.Keyword(null,"x","x",2099068185),x,new cljs.core.Keyword(null,"y","y",-1757859776),y,new cljs.core.Keyword(null,"line","line",212345235),line], null);
});
puppetlabs.metrics.dashboard.metrics_box.metrics_box = (function puppetlabs$metrics$dashboard$metrics_box$metrics_box(description,addendum,data_fn){
var box_id = [cljs.core.str("counterbox"),cljs.core.str(cljs.core.swap_BANG_.call(null,puppetlabs.metrics.dashboard.metrics_box.next_box_id,cljs.core.inc))].join('');
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"description","description",-1428560544),description,new cljs.core.Keyword(null,"box-id","box-id",487721595),box_id,new cljs.core.Keyword(null,"addendum","addendum",472326827),addendum,new cljs.core.Keyword(null,"data-fn","data-fn",777152661),data_fn,new cljs.core.Keyword(null,"reagent-fn","reagent-fn",2103571860),((function (box_id){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [puppetlabs.metrics.dashboard.metrics_box.metrics_box_dom,box_id,description,addendum], null);
});})(box_id))
], null);
});
puppetlabs.metrics.dashboard.metrics_box.redraw_box_BANG_ = (function puppetlabs$metrics$dashboard$metrics_box$redraw_box_BANG_(num_historical_data_points,polling_interval,box,p__13686){
var map__13688 = p__13686;
var map__13688__$1 = ((cljs.core.seq_QMARK_.call(null,map__13688))?cljs.core.apply.call(null,cljs.core.hash_map,map__13688):map__13688);
var state = map__13688__$1;
var data_fn = cljs.core.get.call(null,map__13688__$1,new cljs.core.Keyword(null,"data-fn","data-fn",777152661));
var x = cljs.core.get.call(null,map__13688__$1,new cljs.core.Keyword(null,"x","x",2099068185));
var y = cljs.core.get.call(null,map__13688__$1,new cljs.core.Keyword(null,"y","y",-1757859776));
var line = cljs.core.get.call(null,map__13688__$1,new cljs.core.Keyword(null,"line","line",212345235));
var box_node = box;
var format = ((function (box_node,map__13688,map__13688__$1,state,data_fn,x,y,line){
return (function (p1__13684_SHARP_){
return d3.format(",.1f").call(null,p1__13684_SHARP_);
});})(box_node,map__13688,map__13688__$1,state,data_fn,x,y,line))
;
var data = data_fn.call(null);
var datavals = cljs.core.map.call(null,((function (box_node,format,data,map__13688,map__13688__$1,state,data_fn,x,y,line){
return (function (p1__13685_SHARP_){
return p1__13685_SHARP_.value;
});})(box_node,format,data,map__13688,map__13688__$1,state,data_fn,x,y,line))
,data);
var now = cljs_time.core.now.call(null);
var startx = puppetlabs.metrics.dashboard.metrics_box.date_subtract.call(null,now,(polling_interval * (num_historical_data_points - (2))));
x.domain((((cljs.core.count.call(null,data) > (1)))?[startx,cljs.core.nth.call(null,data,(cljs.core.count.call(null,data) - (2))).time]:[startx,(cljs.core.last.call(null,data).time - polling_interval)]));

var y_domain_13689 = [cljs.core.apply.call(null,cljs.core.min,datavals),cljs.core.apply.call(null,cljs.core.max,datavals)];
y.domain(y_domain_13689).nice();

box_node.select(".countertext").html(format.call(null,cljs.core.last.call(null,datavals)));

var translate_13690 = goog.string.format("translate(%s)",x.call(null,puppetlabs.metrics.dashboard.metrics_box.date_subtract.call(null,now,((num_historical_data_points - (1)) * polling_interval))));
box_node.select(".line").attr("d",line.call(null,data)).attr("transform",null).transition().duration(polling_interval).ease("linear").attr("transform",translate_13690).each("end",((function (translate_13690,box_node,format,data,datavals,now,startx,map__13688,map__13688__$1,state,data_fn,x,y,line){
return (function (){
return puppetlabs$metrics$dashboard$metrics_box$redraw_box_BANG_.call(null,num_historical_data_points,polling_interval,box,state);
});})(translate_13690,box_node,format,data,datavals,now,startx,map__13688,map__13688__$1,state,data_fn,x,y,line))
);

var axis_fn = y.axis.ticks((3)).tickSize((6),(0),(0)).tickFormat(format);
return box_node.select(".y_axis").transition().call(axis_fn);
});
puppetlabs.metrics.dashboard.metrics_box.metrics_table_mounted = (function puppetlabs$metrics$dashboard$metrics_box$metrics_table_mounted(num_historical_data_points,polling_interval,boxes){
return (function (metrics_table){
var table_dom_node = reagent.core.dom_node.call(null,metrics_table);
var seq__13695 = cljs.core.seq.call(null,boxes);
var chunk__13696 = null;
var count__13697 = (0);
var i__13698 = (0);
while(true){
if((i__13698 < count__13697)){
var box = cljs.core._nth.call(null,chunk__13696,i__13698);
var dom_node_13699 = d3.select(table_dom_node).select([cljs.core.str("#"),cljs.core.str(new cljs.core.Keyword(null,"box-id","box-id",487721595).cljs$core$IFn$_invoke$arity$1(box))].join(''));
var now_13700 = cljs_time.core.now.call(null);
var x_axis_domain_13701 = [puppetlabs.metrics.dashboard.metrics_box.date_subtract.call(null,now_13700,(num_historical_data_points * polling_interval)),now_13700];
var state_13702 = puppetlabs.metrics.dashboard.metrics_box.initialize_counterbox.call(null,x_axis_domain_13701,new cljs.core.Keyword(null,"data-fn","data-fn",777152661).cljs$core$IFn$_invoke$arity$1(box),dom_node_13699);
setTimeout(((function (seq__13695,chunk__13696,count__13697,i__13698,dom_node_13699,now_13700,x_axis_domain_13701,state_13702,box,table_dom_node){
return (function (){
return puppetlabs.metrics.dashboard.metrics_box.redraw_box_BANG_.call(null,num_historical_data_points,polling_interval,dom_node_13699,state_13702);
});})(seq__13695,chunk__13696,count__13697,i__13698,dom_node_13699,now_13700,x_axis_domain_13701,state_13702,box,table_dom_node))
,Math.ceil((polling_interval * Math.random())));

var G__13703 = seq__13695;
var G__13704 = chunk__13696;
var G__13705 = count__13697;
var G__13706 = (i__13698 + (1));
seq__13695 = G__13703;
chunk__13696 = G__13704;
count__13697 = G__13705;
i__13698 = G__13706;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__13695);
if(temp__4657__auto__){
var seq__13695__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13695__$1)){
var c__5084__auto__ = cljs.core.chunk_first.call(null,seq__13695__$1);
var G__13707 = cljs.core.chunk_rest.call(null,seq__13695__$1);
var G__13708 = c__5084__auto__;
var G__13709 = cljs.core.count.call(null,c__5084__auto__);
var G__13710 = (0);
seq__13695 = G__13707;
chunk__13696 = G__13708;
count__13697 = G__13709;
i__13698 = G__13710;
continue;
} else {
var box = cljs.core.first.call(null,seq__13695__$1);
var dom_node_13711 = d3.select(table_dom_node).select([cljs.core.str("#"),cljs.core.str(new cljs.core.Keyword(null,"box-id","box-id",487721595).cljs$core$IFn$_invoke$arity$1(box))].join(''));
var now_13712 = cljs_time.core.now.call(null);
var x_axis_domain_13713 = [puppetlabs.metrics.dashboard.metrics_box.date_subtract.call(null,now_13712,(num_historical_data_points * polling_interval)),now_13712];
var state_13714 = puppetlabs.metrics.dashboard.metrics_box.initialize_counterbox.call(null,x_axis_domain_13713,new cljs.core.Keyword(null,"data-fn","data-fn",777152661).cljs$core$IFn$_invoke$arity$1(box),dom_node_13711);
setTimeout(((function (seq__13695,chunk__13696,count__13697,i__13698,dom_node_13711,now_13712,x_axis_domain_13713,state_13714,box,seq__13695__$1,temp__4657__auto__,table_dom_node){
return (function (){
return puppetlabs.metrics.dashboard.metrics_box.redraw_box_BANG_.call(null,num_historical_data_points,polling_interval,dom_node_13711,state_13714);
});})(seq__13695,chunk__13696,count__13697,i__13698,dom_node_13711,now_13712,x_axis_domain_13713,state_13714,box,seq__13695__$1,temp__4657__auto__,table_dom_node))
,Math.ceil((polling_interval * Math.random())));

var G__13715 = cljs.core.next.call(null,seq__13695__$1);
var G__13716 = null;
var G__13717 = (0);
var G__13718 = (0);
seq__13695 = G__13715;
chunk__13696 = G__13716;
count__13697 = G__13717;
i__13698 = G__13718;
continue;
}
} else {
return null;
}
}
break;
}
});
});
puppetlabs.metrics.dashboard.metrics_box.metrics_table_dom = (function puppetlabs$metrics$dashboard$metrics_box$metrics_table_dom(){
var argseq__5339__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return puppetlabs.metrics.dashboard.metrics_box.metrics_table_dom.cljs$core$IFn$_invoke$arity$variadic(argseq__5339__auto__);
});

puppetlabs.metrics.dashboard.metrics_box.metrics_table_dom.cljs$core$IFn$_invoke$arity$variadic = (function (boxes){
var result = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table","table",-564943036),cljs.core.vec.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"metrics"], null)], null),cljs.core.map.call(null,(function (box){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reagent-fn","reagent-fn",2103571860).cljs$core$IFn$_invoke$arity$1(box)], null);
}),boxes)))], null);
return result;
});

puppetlabs.metrics.dashboard.metrics_box.metrics_table_dom.cljs$lang$maxFixedArity = (0);

puppetlabs.metrics.dashboard.metrics_box.metrics_table_dom.cljs$lang$applyTo = (function (seq13719){
return puppetlabs.metrics.dashboard.metrics_box.metrics_table_dom.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq13719));
});
puppetlabs.metrics.dashboard.metrics_box.metrics_table = (function puppetlabs$metrics$dashboard$metrics_box$metrics_table(){
var argseq__5339__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return puppetlabs.metrics.dashboard.metrics_box.metrics_table.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5339__auto__);
});

puppetlabs.metrics.dashboard.metrics_box.metrics_table.cljs$core$IFn$_invoke$arity$variadic = (function (num_historical_data_points,polling_interval,boxes){
return cljs.core.vec.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta.call(null,puppetlabs.metrics.dashboard.metrics_box.metrics_table_dom,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),puppetlabs.metrics.dashboard.metrics_box.metrics_table_mounted.call(null,num_historical_data_points,polling_interval,boxes)], null))], null),boxes));
});

puppetlabs.metrics.dashboard.metrics_box.metrics_table.cljs$lang$maxFixedArity = (2);

puppetlabs.metrics.dashboard.metrics_box.metrics_table.cljs$lang$applyTo = (function (seq13720){
var G__13721 = cljs.core.first.call(null,seq13720);
var seq13720__$1 = cljs.core.next.call(null,seq13720);
var G__13722 = cljs.core.first.call(null,seq13720__$1);
var seq13720__$2 = cljs.core.next.call(null,seq13720__$1);
return puppetlabs.metrics.dashboard.metrics_box.metrics_table.cljs$core$IFn$_invoke$arity$variadic(G__13721,G__13722,seq13720__$2);
});

//# sourceMappingURL=metrics_box.js.map