/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLApplyTemplates;
import net.sf.saxon.style.XSLForEach;
import net.sf.saxon.style.XSLForEachGroup;
import net.sf.saxon.style.XSLPerformSort;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class XSLSort
extends StyleElement {
    private SortKeyDefinition sortKeyDefinition;
    private Expression select;
    private Expression order;
    private Expression dataType = null;
    private Expression caseOrder;
    private Expression lang;
    private String collationName;

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string7 = this.getNamePool().getClarkName(n2);
            if (string7 == "select") {
                string = attributeCollection.getValue(n);
            } else if (string7 == "order") {
                string2 = attributeCollection.getValue(n).trim();
            } else if (string7 == "data-type") {
                string3 = attributeCollection.getValue(n).trim();
            } else if (string7 == "case-order") {
                string4 = attributeCollection.getValue(n).trim();
            } else if (string7 == "lang") {
                string5 = attributeCollection.getValue(n).trim();
            } else if (string7 == "collation") {
                string6 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        this.select = string == null ? new ContextItemExpression() : this.makeExpression(string);
        this.order = string2 == null ? new StringValue("ascending") : this.makeAttributeValueTemplate(string2);
        this.dataType = string3 == null ? EmptySequence.getInstance() : this.makeAttributeValueTemplate(string3);
        this.caseOrder = string4 == null ? new StringValue("#default") : this.makeAttributeValueTemplate(string4);
        this.lang = string5 == null ? new StringValue(Locale.getDefault().getLanguage()) : this.makeAttributeValueTemplate(string5);
        this.collationName = string6;
    }

    public void validate() throws TransformerConfigurationException {
        this.checkEmpty();
        NodeInfo nodeInfo = (NodeInfo)((Object)this.getParentNode());
        if (!(nodeInfo instanceof XSLApplyTemplates || nodeInfo instanceof XSLForEach || nodeInfo instanceof XSLForEachGroup || nodeInfo instanceof XSLPerformSort)) {
            this.compileError("xsl:sort must be child of xsl:apply-templates, xsl:for-each[-group], or xsl:perform-sort");
        }
        Comparator comparator = null;
        if (this.collationName != null && (comparator = this.collationName.equals(CodepointCollator.URI) ? CodepointCollator.getInstance() : this.getPrincipalStyleSheet().findCollation(this.collationName)) == null) {
            this.compileError("No collation of this name has been defined");
            comparator = Collator.getInstance();
        }
        this.select = this.typeCheck("select", this.select);
        this.order = this.typeCheck("order", this.order);
        this.caseOrder = this.typeCheck("case-order", this.caseOrder);
        this.lang = this.typeCheck("lang", this.lang);
        this.dataType = this.typeCheck("data-type", this.dataType);
        try {
            RoleLocator roleLocator = new RoleLocator(4, "xsl:sort/select", 0);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.ATOMIC_SEQUENCE, false, roleLocator);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        this.sortKeyDefinition = new SortKeyDefinition();
        this.sortKeyDefinition.setOrder(this.order);
        this.sortKeyDefinition.setCaseOrder(this.caseOrder);
        this.sortKeyDefinition.setLanguage(this.lang);
        this.sortKeyDefinition.setSortKey(this.select);
        this.sortKeyDefinition.setDataTypeExpression(this.dataType);
        this.sortKeyDefinition.setCollation(comparator);
        try {
            this.sortKeyDefinition = this.sortKeyDefinition.simplify();
        }
        catch (XPathException xPathException) {
            throw new TransformerConfigurationException(xPathException);
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        return null;
    }

    public SortKeyDefinition getSortKeyDefinition() {
        return this.sortKeyDefinition;
    }
}

