/*--------------------------------------------------------------------------+
$Id: MemoryEfficientStringMap.java 29399 2010-07-27 15:03:17Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import java.util.HashMap;
import java.util.Map;

/**
 * A map implementation of a map using string keys. This is based on a hybrid
 * map which uses an {@link ArrayBackedStringMap} while only a small number of
 * keys are present and switches to a {@link HashMap} after a certain size has
 * been reached.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 29399 $
 * @levd.rating GREEN Hash: B82C7BCF35689181816346E57A25D854
 */
public class MemoryEfficientStringMap<V> extends HybridMapBase<String, V> {

	/** The maximal size of the map before switching is performed. */
	private static final int SWITCHING_SIZE = 16;

	/** Constructor. */
	public MemoryEfficientStringMap() {
		super(new ArrayBackedStringMap<V>(4));
	}

	/** Constructor. */
	public MemoryEfficientStringMap(Map<? extends String, ? extends V> map) {
		this();
		putAll(map);
	}

	/** {@inheritDoc} */
	@Override
	protected Map<String, V> obtainNewMap() {
		return new HashMap<String, V>();
	}

	/** {@inheritDoc} */
	@Override
	protected boolean shouldSwitch(Map<String, V> map) {
		return map.size() == SWITCHING_SIZE
				&& map instanceof ArrayBackedMap<?, ?>;
	}
}
