/*--------------------------------------------------------------------------+
$Id: NeverThrownRuntimeException.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.error;

/**
 * A runtime exception that cannot be instantiated. Sometimes the typing
 * mechanism forces one to define an exception type although no exceptions are
 * actually thrown. This class may be used to clarify such circumstances.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 0EF9047868CEBE4A60D679F85023B7A7
 */
@SuppressWarnings("serial")
public class NeverThrownRuntimeException extends RuntimeException {
	/** Prevents instantiation. */
	private NeverThrownRuntimeException() {
		// Prevents instantiation.
	}
}