/*--------------------------------------------------------------------------+
$Id: RethrowingExceptionHandler.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.error;

/**
 * An exception handler simply rethrowing the exception caught.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 2ACD776D944D5964CC083EF8762615B6
 */
public class RethrowingExceptionHandler<X extends Exception> implements
		IExceptionHandler<X, X> {

	/** Singleton instance. */
	private static RethrowingExceptionHandler<Exception> INSTANCE = new RethrowingExceptionHandler<Exception>();

	/** Returns the singleton instance of this class. */
	@SuppressWarnings("unchecked")
	public static <X extends Exception> RethrowingExceptionHandler<X> getInstance() {
		return (RethrowingExceptionHandler<X>) INSTANCE;
	}

	/** {@inheritDoc} */
	public void handleException(X exception) throws X {
		throw exception;
	}
}