/*--------------------------------------------------------------------------+
$Id: GraphvizException.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.graph;

import edu.tum.cs.commons.string.StringUtils;

/**
 * Exception indicating problems while invoking graphviz programs.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: A3EB3AB0EE17233C63D873E6509B1118
 */
@SuppressWarnings("serial")
public class GraphvizException extends Exception {

	/** DOT error output. */
	private final String output;

	/**
	 * Create new exception. This is package visible as only classes from this
	 * package may create the excpetion.
	 * 
	 * @param output
	 *            the error output generated by DOT. Its first line is used a
	 *            exception message.
	 */
	/* package */GraphvizException(String output) {
		super(StringUtils.getFirstLine(output));
		this.output = output;
	}

	/** Get DOT's original output. */
	public String getOutput() {
		return output;
	}
}