/*--------------------------------------------------------------------------+
$Id: EXMLWriterExceptionType.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.xml;

/**
 * Exception types to detail {@link XMLWriterException}s.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 366DABAC7EB1635FB2DA48EC24D39B6B
 */
public enum EXMLWriterExceptionType {

	/** On attempt to close wrong element. */
	UNCLOSED_ELEMENT,

	/** On attempt to create an attribute outside an element head. */
	ATTRIBUTE_OUTSIDE_ELEMENT,

	/** On attempt to create a duplicate attribute. */
	DUPLICATE_ATTRIBUTE,

	/** On attempt to add an XML header in the middle of a document. */
	HEADER_WITHIN_DOCUMENT,

	/** The number of arguments provided is odd. */
	ODD_NUMBER_OF_ARGUMENTS,

	/** The attributes provided are of the wrong type. */
	ILLEGAL_ATTRIBUTE_TYPE,

	/** Text added to a CDATA section contains CDATA closing tag <code>]]></code> */
	CDATA_CONTAINS_CDATA_CLOSING_TAG
}