/*--------------------------------------------------------------------------+
$Id: ObjectUnionFindTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.algo;

import edu.tum.cs.commons.test.CCSMTestCaseBase;

/**
 * Test case for {@link ObjectUnionFind}. This also tests the
 * {@link UnionFindWithSize}.
 * 
 * @author juergens
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 5B52E43F460A27F64CAEE999C35DE2CA
 */
public class ObjectUnionFindTest extends CCSMTestCaseBase {

	/** Instance under test */
	private ObjectUnionFind<String> unions;

	/** {@inheritDoc} */
	@Override
	protected void setUp() {
		unions = new ObjectUnionFind<String>();
	}

	/** Test idempotence of union of two elements */
	public void testUnionTwoElements() {
		unions.union("a", "b");
		assertEquals(2, unions.getClusterSize("a"));
		assertEquals(2, unions.getClusterSize("b"));

		unions.union("a", "b");
		assertEquals(2, unions.getClusterSize("a"));
		assertEquals(2, unions.getClusterSize("b"));

		unions.union("b", "a");
		assertEquals(2, unions.getClusterSize("a"));
		assertEquals(2, unions.getClusterSize("b"));
	}

	/** Test transitivity of union of three elements */
	public void testTransitiveUnion() {
		unions.union("a", "b");
		unions.union("b", "c");
		assertEquals(3, unions.getClusterSize("a"));
		assertEquals(3, unions.getClusterSize("b"));
		assertEquals(3, unions.getClusterSize("c"));

		unions.union("a", "b");
		unions.union("b", "c");
		unions.union("c", "b");
		unions.union("a", "c");
		unions.union("b", "a");
		unions.union("c", "a");
		assertEquals(3, unions.getClusterSize("a"));
		assertEquals(3, unions.getClusterSize("b"));
		assertEquals(3, unions.getClusterSize("c"));
	}

	/** Test independence of union of unrelated elements */
	public void testUnionIndependent() {
		unions.union("a", "b");
		assertEquals(2, unions.getClusterSize("a"));
		assertEquals(2, unions.getClusterSize("b"));

		unions.union("x", "y");
		assertEquals(2, unions.getClusterSize("x"));
		assertEquals(2, unions.getClusterSize("y"));

		unions.union("a", "y");
		assertEquals(4, unions.getClusterSize("x"));
		assertEquals(4, unions.getClusterSize("y"));
	}

	/** Test size of non-existing unions */
	public void testUncontainedElements() {
		assertEquals(1, unions.getClusterSize("a"));
		assertEquals(1, unions.getClusterSize("a"));
		assertEquals(1, unions.getClusterSize("b"));
	}

}