/*--------------------------------------------------------------------------+
$Id: CanonicalFileTest.java 26268 2010-02-18 10:44:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.filesystem;

import java.io.File;
import java.io.IOException;

import edu.tum.cs.commons.test.CCSMTestCaseBase;

/**
 * Test case for {@link CanonicalFile}.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26268 $
 * @levd.rating GREEN Hash: A99F2C478D1F447304DAA7A84C8995A7
 */
public class CanonicalFileTest extends CCSMTestCaseBase {

	/** Test basic behavior. */
	@SuppressWarnings("deprecation")
	public void test() throws IOException {
		File plainFile = useTestFile("canonical.txt");
		CanonicalFile canonicalFile = new CanonicalFile(plainFile);

		// sanity check for test
		assertFalse(plainFile.equals(canonicalFile));

		assertEquals(plainFile.getCanonicalFile(), canonicalFile);
		assertEquals(plainFile.getCanonicalPath(), canonicalFile.getPath());
		assertEquals(plainFile.getCanonicalPath(), canonicalFile
				.getAbsolutePath());
		assertEquals(plainFile.getCanonicalPath(), canonicalFile
				.getCanonicalPath());

		assertFalse(new CanonicalFile("c:/x/../z", "../x/y").getCanonicalPath()
				.contains(".."));
	}

	/**
	 * Test if non-canonicalizable file raises an exception. While windows is
	 * quite picky about filenames, for linux it is very hard to raise the
	 * exception as nearly all characters are allowed for filenames, including
	 * the dots, newline, 0-character, etc. The solution used here is to use a
	 * name which exceeds the maximal path length, which will also raise the
	 * exception.
	 */
	public void testException() {
		try {
			StringBuilder sb = new StringBuilder();
			for (int i = 0; i < 100000; ++i) {
				sb.append("/test");
			}

			new CanonicalFile("c:/.../text.txt" + sb.toString());
			fail();
		} catch (IOException e) {
			// nothing to do
		}
	}

	/**
	 * Tests whether obtaining the parent of a root returns null as expected.
	 * Also see CR #2422.
	 */
	public void testEmptyParent() throws IOException {
		CanonicalFile file = new CanonicalFile(File.listRoots()[0]);
		assertNull(file.getParentFile());
	}
}