/*--------------------------------------------------------------------------+
$Id: SerializationUtilsTest.java 29400 2010-07-27 15:03:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.io;

import junit.framework.TestCase;

/**
 * Tests for {@link SerializationUtils}.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 29400 $
 * @levd.rating GREEN Hash: 691B4D27672099AAB39FD2CF9CA08186
 */
public class SerializationUtilsTest extends TestCase {

	/**
	 * Tests the {@link SerializationUtils#insertInt(int, byte[], int)} and
	 * {@link SerializationUtils#extractInt(byte[], int)} methods.
	 */
	public void testIntConversion() {
		final int value = 0x12345678;
		final int position = 5;
		byte[] data = new byte[17];
		SerializationUtils.insertInt(value, data, position);
		assertEquals(value, SerializationUtils.extractInt(data, position));
	}

}
