/*--------------------------------------------------------------------------+
$Id: XPathEvaluatorTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.xml;

import java.io.File;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import edu.tum.cs.commons.string.StringUtils;
import edu.tum.cs.commons.test.CCSMTestCaseBase;

/**
 * Test for {@link XPathEvaluator}.
 * 
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: AC42BC3A31FCCE5DC147A64A2C64A60B
 */
public class XPathEvaluatorTest extends CCSMTestCaseBase {

	/** Object under test. */
	private final XPathEvaluator xPath = new XPathEvaluator();

	/** Document root element. Initialized by {@link #setUp()}. */
	private Element element;

	/** Parse file. */
	@Override
	protected void setUp() throws Exception {
		File file = useTestFile("xpath01.xml");
		Document doc = XMLUtils.parse(file);
		element = doc.getDocumentElement();
	}

	/** Test XPath evaluator with a given namespace prefix. */
	public void testNameSpacePrefix() {
		assertNull(xPath.selectElement("//ORDER[@article-number=5]", element));
		xPath.addNamespace("ns", "http://mynamespace.com");
		assertNotNull(xPath.selectElement("//ns:ORDER[@article-number=5]",
				element));
	}

	/** Test {@link XPathEvaluator#selectBoolean(String, Element)}. */
	public void testSelectBoolean() {
		assertFalse(xPath.selectBoolean("//XZY", element));
		assertTrue(xPath.selectBoolean("//STREET", element));
	}

	/** Test {@link XPathEvaluator#selectElement(String, Element)}. */
	public void testSelectElement() {
		assertNull(xPath.selectElement("//XZY", element));
		assertNotNull(xPath.selectElement("//STREET", element));
		assertSame(xPath.selectElement("//ORDER", element), xPath
				.selectElement("//ORDER", element));
		assertNotSame(xPath.selectElement("//ORDER[1]", element), xPath
				.selectElement("//ORDER[2]", element));
	}

	/** Test {@link XPathEvaluator#selectList(String, Element)}. */
	public void testSelectList() {
		List<Element> list = xPath.selectList("//ORDER", element);
		assertEquals(4, list.size());

		for (int i = 0; i < list.size(); i++) {
			assertEquals(list.get(i), xPath.selectElement(
					"//ORDER[@article-number=" + (i + 1) + "]", element));
		}

	}

	/**
	 * Test {@link XPathEvaluator#selectDouble(String, Element)} and
	 * {@link XPathEvaluator#selectInt(String, Element)}.
	 */
	public void testSelectNumber() {
		assertEquals(1, xPath.selectInt("//ORDER/@article-number", element));
		assertEquals(1.0, xPath
				.selectDouble("//ORDER/@article-number", element));
		assertEquals(2, xPath.selectInt("count(//STREET)", element));
	}

	/** Test {@link XPathEvaluator#selectString(String, Element)}. */
	public void testSelectString() {
		assertEquals("Street A", xPath.selectString("//STREET", element));
		assertEquals("Street B", xPath.selectString("//STREET[.='Street B']",
				element));
		assertEquals(StringUtils.EMPTY_STRING, xPath.selectString(
				"//unknown-element", element));
	}
}