/*--------------------------------------------------------------------------+
$Id: StateflowBlock.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.model.stateflow;

import edu.tum.cs.commons.clone.DeepCloneException;
import edu.tum.cs.simulink.model.SimulinkBlock;

/**
 * A special Simulink block that stores state charts. There is a one-to-one
 * association between {@link StateflowBlock}s and {@link StateflowChart}s.
 * The sub blocks of this block are automatically generated by Simulink.
 * 
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 7599AD3B1F4D90C2C8538BFEE18AEECC
 */
public class StateflowBlock extends SimulinkBlock {

	/** The chart that belongs to this block. */
	private StateflowChart chart;

	/**
	 * Create Stateflow block.
	 * 
	 * @param chart
	 *            The chart that belongs to this block.
	 */
	public StateflowBlock(StateflowChart chart) {
		this.chart = chart;
		chart.setStateflowBlock(this);
	}

	/** Create new Stateflow block from existing block (for deep cloning). */
	private StateflowBlock(StateflowBlock block) throws DeepCloneException {
		super(block);
		chart = block.chart.deepClone();
		chart.setStateflowBlock(this);
	}

	/** Get the Stateflow chart that belongs to this block. */
	public StateflowChart getChart() {
		return chart;
	}

	/** Unlinks this object from the simulink tree. */
	@Override
	public void remove() {
		chart.getMachine().removeChart(chart);
		chart = null;
		super.remove();
	}

	/** Deep clone this block. */
	@Override
	public StateflowBlock deepClone() throws DeepCloneException {
		return new StateflowBlock(this);
	}
}