/*
 * Copyright (C) 2009-2011 Institute for Computational Biomedicine,
 *                    Weill Medical College of Cornell University
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.campagnelab.goby.cli;

import org.campagnelab.goby.reads.Reads;
import org.campagnelab.goby.reads.ReadsReader;
import it.unimi.dsi.lang.MutableString;

import java.io.IOException;
import java.io.PrintWriter;

/**
 * Writes reads to simple text format.
 * @author campagne
 *         Date: 7/6/11
 *         Time: 3:39 PM
 */
public class ReadsToText {

    public static void main(String[] args) throws IOException {
        PrintWriter out=new PrintWriter("out.txt");
        ReadsReader reader = new ReadsReader(args[0]);
        MutableString sequence = new MutableString();

        for (Reads.ReadEntry read : reader) {
            ReadsReader.decodeSequence(read, sequence);
          out.println(sequence);
        }
        out.close();
    }

}
