/*
 *  @(#)IIssue.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1;

 

/**
 * Reflects an issue (or bug, or anomally report, or problem ticket) that
 * is generic enough to be used by most problem tracker system.  All
 * <tt>IIssue</tt> instances are immutable, unless they also implement
 * <tt>IEditableIssue</tt>.
 * <P>
 * An issue will only reflect the data associated with the issue at the time of
 * the polling of the issue from the tracker.  Currently, the only way to
 * update the issue's data fields is to re-poll the issue from the
 * <tt>ProblemManager</tt>, or to call <tt>reload()</tt>.  Individual
 * implemenations of the PMTI framework
 * may provide alternative means to real-time update the issue data, but that
 * is not the standard implementation.
 * <P>
 * Containment patterns would require the creation methods for an editable form
 * of the issue to be in this interface.  For security reasons, this method
 * is placed in the <tt>ProblemManager</tt> interface instead.
 * <P>
 * NOTE: this interface may be too generic to be useful.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:51:54 $
 * @since      July 6, 2002
 */
public interface IIssue
{
    /**
     * Returns the unique ID associated with this issue.
     *
     * @return the problem tracker's assigned ID for this issue, which can
     *      never be <tt>null</tt>.
     */
    public String getID();
    
    
    /**
     * Returns the type of issue.  For the SourceForge.net site, this may
     * be "bug", "feature request", and so forth.  Some trackers may only
     * have one type of issue, so this field may not be as useful.  For
     * those trackers that have different attribute data sets for different
     * types, this may aid programs in decoding the attributes and states.
     * <P>
     * NOTE: this field may be deprecated in the future in favor of specific
     * IAttributeSet types.
     *
     * @return the issue's type, which may be <tt>null</tt>.
     * @see #getAttributes()
     */
    public String getType();
    
    
    /**
     * Retrieves the short description of the issue.  This can also be
     * referred to as the issue title or summary.  It should be a
     * human-readable short description, describing a general overview
     * of the issue.
     *
     * @return the issue's short description, which may be <tt>null</tt>.
     */
    public String getShortDescription();
    
    
    /**
     * Queries the "state" of the issue.  In a very general way, this refers
     * to various progress states an issue can be in, such as "new", "assigned",
     * "investigating", "resolved", "verified", "closed", and so on.  Additional
     * data may be associated with this state, such as who's working on the
     * issue, the resolution of the issue, who verified the resolution, and
     * so on.  If the tracker does not support a state, then <tt>null</tt>
     * may be returned.
     * <P>
     * Some trackers may have different state categories for different
     * issue types.
     *
     * @return the issue's state, which may be <tt>null</tt>.
     */
    public IIssueState getState();
    
    
    /**
     * Returns a list of all attributes associated with this issue.  All
     * issues of a particular type should have the same set of issues.
     *
     * @return the set of tracker-specific and issue type-specific attributes
     *      and values associated with this issue.  Can never return
     *      <tt>null</tt>.
     */
    public IAttributeSet getAttributes();
    
    
    /**
     * Returns a new issue instance, containing the most up-to-date tracker
     * information for this issue.  Since the <tt>IIssue</tt> instances are
     * immutable, this will not change the invoked issue.  If the current
     * instance is of type <tt>IEditableIssue</tt>, then an
     * <tt>IEditableIssue</tt> will be returned, but will contain none of the
     * non-committed changes performed on the owning issue.
     * <P>
     * In theory, issues should never be removed.  However, some systems allow
     * them to be deleted (say, if there was an accidental creation).  In this
     * case, an <tt>IssueRemovedException</tt> will be thrown.
     *
     * @return an IIssue with the 
     * @exception ProblemManagerException if there was an underlying tracker
     *      error.
     */
    public IIssue reload()
            throws ProblemManagerException;
}

