local g = import 'grafonnet/grafana.libsonnet';
local pieChartPanel = import 'piechart_panel.libsonnet';

{
  _config:: error 'must provide _config',

  dashboardSchema(title,
                  description,
                  uid,
                  time_from,
                  refresh,
                  schemaVersion,
                  tags,
                  timezone)::
    g.dashboard.new(title=title,
                    description=description,
                    uid=uid,
                    time_from=time_from,
                    refresh=refresh,
                    schemaVersion=schemaVersion,
                    tags=tags,
                    timezone=timezone),

  graphPanelSchema(aliasColors,
                   title,
                   description,
                   nullPointMode,
                   stack,
                   formatY1,
                   formatY2,
                   labelY1,
                   labelY2,
                   min,
                   fill,
                   datasource,
                   legend_alignAsTable=false,
                   legend_avg=false,
                   legend_min=false,
                   legend_max=false,
                   legend_current=false,
                   legend_values=false)::
    g.graphPanel.new(aliasColors=aliasColors,
                     title=title,
                     description=description,
                     nullPointMode=nullPointMode,
                     stack=stack,
                     formatY1=formatY1,
                     formatY2=formatY2,
                     labelY1=labelY1,
                     labelY2=labelY2,
                     min=min,
                     fill=fill,
                     datasource=datasource,
                     legend_alignAsTable=legend_alignAsTable,
                     legend_avg=legend_avg,
                     legend_min=legend_min,
                     legend_max=legend_max,
                     legend_current=legend_current,
                     legend_values=legend_values),


  addTargetSchema(expr, legendFormat='', format='time_series', intervalFactor=1, instant=null)::
    g.prometheus.target(expr=expr,
                        legendFormat=legendFormat,
                        format=format,
                        intervalFactor=intervalFactor,
                        instant=instant),

  addTemplateSchema(name,
                    datasource,
                    query,
                    refresh,
                    includeAll,
                    sort,
                    label,
                    regex,
                    hide='',
                    multi=false,
                    allValues=null)::
    g.template.new(name=name,
                   datasource=datasource,
                   query=query,
                   refresh=refresh,
                   includeAll=includeAll,
                   sort=sort,
                   label=label,
                   regex=regex,
                   hide=hide,
                   multi=multi,
                   allValues=allValues),

  addAnnotationSchema(builtIn,
                      datasource,
                      enable,
                      hide,
                      iconColor,
                      name,
                      type)::
    g.annotation.datasource(builtIn=builtIn,
                            datasource=datasource,
                            enable=enable,
                            hide=hide,
                            iconColor=iconColor,
                            name=name,
                            type=type),

  addRowSchema(collapse, showTitle, title)::
    g.row.new(collapse=collapse, showTitle=showTitle, title=title),

  addSingleStatSchema(colors,
                      datasource,
                      format,
                      title,
                      description,
                      valueName,
                      colorValue,
                      gaugeMaxValue,
                      gaugeShow,
                      sparklineShow,
                      thresholds)::
    g.singlestat.new(colors=colors,
                     datasource=datasource,
                     format=format,
                     title=title,
                     description=description,
                     valueName=valueName,
                     colorValue=colorValue,
                     gaugeMaxValue=gaugeMaxValue,
                     gaugeShow=gaugeShow,
                     sparklineShow=sparklineShow,
                     thresholds=thresholds),

  addPieChartSchema(aliasColors,
                    datasource,
                    description,
                    legendType,
                    pieType,
                    title,
                    valueName)::
    g.pieChartPanel.new(aliasColors=aliasColors,
                        datasource=datasource,
                        description=description,
                        legendType=legendType,
                        pieType=pieType,
                        title=title,
                        valueName=valueName),

  addStyle(alias,
           colorMode,
           colors,
           dateFormat,
           decimals,
           mappingType,
           pattern,
           thresholds,
           type,
           unit,
           valueMaps)::
    {
      alias: alias,
      colorMode: colorMode,
      colors: colors,
      dateFormat: dateFormat,
      decimals: decimals,
      mappingType: mappingType,
      pattern: pattern,
      thresholds: thresholds,
      type: type,
      unit: unit,
      valueMaps: valueMaps,
    },

  matchers()::
    local jobMatcher = 'job=~"$job"';
    local clusterMatcher = '%s=~"$cluster"' % $._config.clusterLabel;
    {
      // Common labels
      jobMatcher: jobMatcher,
      clusterMatcher: (if $._config.showMultiCluster then clusterMatcher else ''),
      matchers: jobMatcher +
                (if $._config.showMultiCluster then ', ' + clusterMatcher else ''),
    },

  addClusterTemplate()::
    $.addTemplateSchema(
      'cluster',
      '$datasource',
      'label_values(ceph_osd_metadata, %s)' % $._config.clusterLabel,
      1,
      true,
      1,
      'cluster',
      '(.*)',
      if !$._config.showMultiCluster then 'variable' else '',
      multi=true,
      allValues='.+',
    ),

  addJobTemplate()::
    $.addTemplateSchema(
      'job',
      '$datasource',
      'label_values(ceph_osd_metadata{%(clusterMatcher)s}, job)' % $.matchers(),
      1,
      true,
      1,
      'job',
      '(.*)',
      multi=true,
      allValues='.+',
    ),

  overviewStyle(alias,
                pattern,
                type,
                unit,
                colorMode=null,
                thresholds=[],
                valueMaps=[])::
    $.addStyle(alias,
               colorMode,
               [
                 'rgba(245, 54, 54, 0.9)',
                 'rgba(237, 129, 40, 0.89)',
                 'rgba(50, 172, 45, 0.97)',
               ],
               'YYYY-MM-DD HH:mm:ss',
               2,
               1,
               pattern,
               thresholds,
               type,
               unit,
               valueMaps),

  simpleGraphPanel(alias,
                   title,
                   description,
                   formatY1,
                   labelY1,
                   min,
                   expr,
                   legendFormat,
                   x,
                   y,
                   w,
                   h)::
    $.graphPanelSchema(alias,
                       title,
                       description,
                       'null',
                       false,
                       formatY1,
                       'short',
                       labelY1,
                       null,
                       min,
                       1,
                       '$datasource')
    .addTargets(
      [$.addTargetSchema(expr, legendFormat)]
    ) + { type: 'timeseries' } + { fieldConfig: { defaults: { unit: formatY1, custom: { fillOpacity: 8, showPoints: 'never' } } } } + { gridPos: { x: x, y: y, w: w, h: h } },

  simpleSingleStatPanel(format,
                        title,
                        description,
                        valueName,
                        expr,
                        instant,
                        targetFormat,
                        x,
                        y,
                        w,
                        h)::
    $.addSingleStatSchema(['#299c46', 'rgba(237, 129, 40, 0.89)', '#d44a3a'],
                          '$datasource',
                          format,
                          title,
                          description,
                          valueName,
                          false,
                          100,
                          false,
                          false,
                          '')
    .addTarget($.addTargetSchema(expr, '', targetFormat, 1, instant)) + {
      gridPos: { x: x, y: y, w: w, h: h },
    },
  gaugeSingleStatPanel(format,
                       title,
                       description,
                       valueName,
                       colorValue,
                       gaugeMaxValue,
                       gaugeShow,
                       sparkLineShow,
                       thresholds,
                       expr,
                       targetFormat,
                       x,
                       y,
                       w,
                       h)::
    $.addSingleStatSchema(['#299c46', 'rgba(237, 129, 40, 0.89)', '#d44a3a'],
                          '$datasource',
                          format,
                          title,
                          description,
                          valueName,
                          colorValue,
                          gaugeMaxValue,
                          gaugeShow,
                          sparkLineShow,
                          thresholds)
    .addTarget($.addTargetSchema(expr, '', targetFormat)) + { gridPos: { x:
      x, y: y, w: w, h: h } },

  simplePieChart(alias, description, title)::
    $.addPieChartSchema(alias,
                        '$datasource',
                        description,
                        'Under graph',
                        'pie',
                        title,
                        'current'),

  pieChartPanel(
    title,
    description='',
    datasource=null,
    gridPos={},
    displayMode='table',
    placement='bottom',
    showLegend=true,
    displayLabels=[],
    tooltip={},
    pieType='pie',
    values=[],
    colorMode='auto',
    overrides=[],
    reduceOptions={},
  )::
    pieChartPanel.new(
      title,
      description=description,
      datasource=datasource,
      gridPos=gridPos,
      displayMode=displayMode,
      placement=placement,
      showLegend=showLegend,
      displayLabels=displayLabels,
      tooltip=tooltip,
      pieType=pieType,
      values=values,
      colorMode=colorMode,
      overrides=overrides,
      reduceOptions=reduceOptions,
    ),

  addTableExtended(
    title='',
    datasource=null,
    description=null,
    sort=null,
    styles='',
    transform=null,
    pluginVersion='9.1.3',
    options=null,
    gridPosition={},
    custom=null,
    decimals=null,
    thresholds=null,
    unit=null,
    overrides=[],
    color=null
  )::
    g.tablePanel.new(datasource=datasource,
                     description=description,
                     sort=sort,
                     styles=styles,
                     title=title,
                     transform=transform) + {
      pluginVersion: pluginVersion,
      gridPos: gridPosition,
      [if options != null then 'options']: options,
      fieldConfig+: {
        defaults+: {
          [if custom != null then 'custom']: custom,
          [if decimals != null then 'decimals']: decimals,
          [if thresholds != null then 'thresholds']: thresholds,
          [if unit != null then 'unit']: unit,
          [if color != null then 'color']: color,

        },
        overrides: overrides,
      },
    },
}
