## Release 5.0

### New Rules

Rule ID | Category | Severity | Notes
--------|----------|----------|-------
CA1000 | Design | Hidden | DoNotDeclareStaticMembersOnGenericTypesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1000)
CA1001 | Design | Hidden | TypesThatOwnDisposableFieldsShouldBeDisposableAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1001)
CA1002 | Design | Disabled | DoNotExposeGenericLists, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1002)
CA1003 | Design | Disabled | UseGenericEventHandlerInstancesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1003)
CA1005 | Design | Disabled | AvoidExcessiveParametersOnGenericTypes, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1005)
CA1008 | Design | Disabled | EnumsShouldHaveZeroValueAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1008)
CA1010 | Design | Hidden | CollectionsShouldImplementGenericInterfaceAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1010)
CA1012 | Design | Disabled | AbstractTypesShouldNotHaveConstructorsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1012)
CA1014 | Design | Disabled | MarkAssembliesWithAttributesDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1014)
CA1016 | Design | Info | MarkAssembliesWithAttributesDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1016)
CA1017 | Design | Disabled | MarkAssembliesWithComVisibleAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1017)
CA1018 | Design | Info | MarkAttributesWithAttributeUsageAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1018)
CA1019 | Design | Disabled | DefineAccessorsForAttributeArgumentsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1019)
CA1021 | Design | Disabled | AvoidOutParameters, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1021)
CA1024 | Design | Disabled | UsePropertiesWhereAppropriateAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1024)
CA1027 | Design | Disabled | EnumWithFlagsAttributeAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1027)
CA1028 | Design | Disabled | EnumStorageShouldBeInt32Analyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1028)
CA1030 | Design | Disabled | UseEventsWhereAppropriateAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1030)
CA1031 | Design | Disabled | DoNotCatchGeneralExceptionTypesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1031)
CA1032 | Design | Disabled | ImplementStandardExceptionConstructorsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1032)
CA1033 | Design | Disabled | InterfaceMethodsShouldBeCallableByChildTypesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1033)
CA1034 | Design | Disabled | NestedTypesShouldNotBeVisibleAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1034)
CA1036 | Design | Hidden | OverrideMethodsOnComparableTypesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1036)
CA1040 | Design | Disabled | AvoidEmptyInterfacesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1040)
CA1041 | Design | Info | ProvideObsoleteAttributeMessageAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1041)
CA1043 | Design | Disabled | UseIntegralOrStringArgumentForIndexersAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1043)
CA1044 | Design | Disabled | PropertiesShouldNotBeWriteOnlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1044)
CA1045 | Design | Disabled | DoNotPassTypesByReference, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1045)
CA1046 | Design | Disabled | DoNotOverloadOperatorEqualsOnReferenceTypes, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1046)
CA1047 | Design | Info | DoNotDeclareProtectedMembersInSealedTypes, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1047)
CA1050 | Design | Info | DeclareTypesInNamespacesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1050)
CA1051 | Design | Hidden | DoNotDeclareVisibleInstanceFieldsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1051)
CA1052 | Design | Disabled | StaticHolderTypesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1052)
CA1054 | Design | Disabled | UriParametersShouldNotBeStringsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1054)
CA1055 | Design | Disabled | UriReturnValuesShouldNotBeStringsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1055)
CA1056 | Design | Disabled | UriPropertiesShouldNotBeStringsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1056)
CA1058 | Design | Disabled | TypesShouldNotExtendCertainBaseTypesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1058)
CA1060 | Design | Disabled | MovePInvokesToNativeMethodsClassAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1060)
CA1061 | Design | Info | DoNotHideBaseClassMethodsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1061)
CA1062 | Design | Disabled | ValidateArgumentsOfPublicMethods, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1062)
CA1063 | Design | Disabled | ImplementIDisposableCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1063)
CA1064 | Design | Disabled | ExceptionsShouldBePublicAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1064)
CA1065 | Design | Disabled | DoNotRaiseExceptionsInUnexpectedLocationsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1065)
CA1066 | Design | Disabled | EquatableAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1066)
CA1067 | Design | Info | EquatableAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1067)
CA1068 | Design | Info | CancellationTokenParametersMustComeLastAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1068)
CA1069 | Design | Info | EnumShouldNotHaveDuplicatedValues, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1069)
CA1070 | Design | Info | DoNotDeclareEventFieldsAsVirtual, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1070)
CA1200 | Documentation | Hidden | AvoidUsingCrefTagsWithAPrefixAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1200)
CA1303 | Globalization | Disabled | DoNotPassLiteralsAsLocalizedParameters, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1303)
CA1304 | Globalization | Hidden | SpecifyCultureInfoAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1304)
CA1305 | Globalization | Hidden | SpecifyIFormatProviderAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1305)
CA1307 | Globalization | Disabled | SpecifyStringComparisonAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1307)
CA1308 | Globalization | Disabled | NormalizeStringsToUppercaseAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1308)
CA1309 | Globalization | Hidden | UseOrdinalStringComparisonAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1309)
CA1310 | Globalization | Hidden | SpecifyStringComparisonAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1310)
CA1401 | Interoperability | Info | PInvokeDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1401)
CA1416 | Interoperability | Warning | PlatformCompatibilityAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1416)
CA1417 | Interoperability | Warning | DoNotUseOutAttributeStringPInvokeParametersAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1417)
CA1501 | Maintainability | Disabled | CodeMetricsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1501)
CA1502 | Maintainability | Disabled | CodeMetricsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1502)
CA1505 | Maintainability | Disabled | CodeMetricsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1505)
CA1506 | Maintainability | Disabled | CodeMetricsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1506)
CA1507 | Maintainability | Info | UseNameofInPlaceOfStringAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1507)
CA1508 | Maintainability | Disabled | AvoidDeadConditionalCode, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1508)
CA1509 | Maintainability | Disabled | CodeMetricsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1509)
CA1700 | Naming | Disabled | DoNotNameEnumValuesReserved, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1700)
CA1707 | Naming | Hidden | IdentifiersShouldNotContainUnderscoresAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1707)
CA1708 | Naming | Hidden | IdentifiersShouldDifferByMoreThanCaseAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1708)
CA1710 | Naming | Hidden | IdentifiersShouldHaveCorrectSuffixAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1710)
CA1711 | Naming | Hidden | IdentifiersShouldNotHaveIncorrectSuffixAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1711)
CA1712 | Naming | Hidden | DoNotPrefixEnumValuesWithTypeNameAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1712)
CA1713 | Naming | Disabled | EventsShouldNotHaveBeforeOrAfterPrefix, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1713)
CA1715 | Naming | Hidden | IdentifiersShouldHaveCorrectPrefixAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1715)
CA1716 | Naming | Hidden | IdentifiersShouldNotMatchKeywordsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1716)
CA1720 | Naming | Hidden | IdentifiersShouldNotContainTypeNames, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1720)
CA1721 | Naming | Disabled | PropertyNamesShouldNotMatchGetMethodsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1721)
CA1724 | Naming | Disabled | TypeNamesShouldNotMatchNamespacesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1724)
CA1725 | Naming | Hidden | ParameterNamesShouldMatchBaseDeclarationAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1725)
CA1801 | Usage | Disabled | ReviewUnusedParametersAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1801)
CA1802 | Performance | Disabled | UseLiteralsWhereAppropriateAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1802)
CA1805 | Performance | Hidden | DoNotInitializeUnnecessarilyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1805)
CA1806 | Performance | Info | DoNotIgnoreMethodResultsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1806)
CA1810 | Performance | Disabled | InitializeStaticFieldsInlineAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1810)
CA1812 | Performance | Disabled | AvoidUninstantiatedInternalClassesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1812)
CA1813 | Performance | Disabled | AvoidUnsealedAttributesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1813)
CA1814 | Performance | Disabled | PreferJaggedArraysOverMultidimensionalAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1814)
CA1815 | Performance | Disabled | OverrideEqualsAndOperatorEqualsOnValueTypesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1815)
CA1816 | Usage | Info | CallGCSuppressFinalizeCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1816)
CA1819 | Performance | Disabled | PropertiesShouldNotReturnArraysAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1819)
CA1820 | Performance | Disabled | TestForEmptyStringsUsingStringLengthAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1820)
CA1821 | Performance | Info | RemoveEmptyFinalizersAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1821)
CA1822 | Performance | Info | MarkMembersAsStaticAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1822)
CA1823 | Performance | Disabled | AvoidUnusedPrivateFieldsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1823)
CA1824 | Performance | Info | MarkAssembliesWithNeutralResourcesLanguageAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1824)
CA1825 | Performance | Info | AvoidZeroLengthArrayAllocationsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1825)
CA1826 | Performance | Info | DoNotUseEnumerableMethodsOnIndexableCollectionsInsteadUseTheCollectionDirectlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1826)
CA1827 | Performance | Info | UseCountProperlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1827)
CA1828 | Performance | Info | UseCountProperlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1828)
CA1829 | Performance | Info | UseCountProperlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1829)
CA1830 | Performance | Info | PreferTypedStringBuilderAppendOverloads, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1830)
CA1831 | Performance | Warning | UseAsSpanInsteadOfRangeIndexerAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1831)
CA1832 | Performance | Info | UseAsSpanInsteadOfRangeIndexerAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1832)
CA1833 | Performance | Info | UseAsSpanInsteadOfRangeIndexerAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1833)
CA1834 | Performance | Info | PreferConstCharOverConstUnitStringAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1834)
CA1835 | Performance | Info | PreferStreamAsyncMemoryOverloads, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1835)
CA1836 | Performance | Info | UseCountProperlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1836)
CA1837 | Performance | Info | UseEnvironmentProcessId, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1837)
CA1838 | Performance | Hidden | AvoidStringBuilderPInvokeParametersAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1838)
CA2000 | Reliability | Disabled | DisposeObjectsBeforeLosingScope, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2000)
CA2002 | Reliability | Disabled | DoNotLockOnObjectsWithWeakIdentityAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2002)
CA2007 | Reliability | Disabled | DoNotDirectlyAwaitATaskAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2007)
CA2008 | Reliability | Disabled | DoNotCreateTasksWithoutPassingATaskSchedulerAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2008)
CA2009 | Reliability | Info | DoNotCallToImmutableCollectionOnAnImmutableCollectionValueAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2009)
CA2011 | Reliability | Info | AvoidInfiniteRecursion, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2011)
CA2012 | Reliability | Info | UseValueTasksCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2012)
CA2013 | Reliability | Warning | DoNotUseReferenceEqualsWithValueTypesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2013)
CA2014 | Reliability | Warning | CSharpDoNotUseStackallocInLoopsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2014)
CA2015 | Reliability | Warning | DoNotDefineFinalizersForTypesDerivedFromMemoryManager, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2015)
CA2016 | Reliability | Info | ForwardCancellationTokenToInvocationsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2016)
CA2100 | Security | Disabled | ReviewSqlQueriesForSecurityVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2100)
CA2101 | Globalization | Info | PInvokeDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2101)
CA2109 | Security | Disabled | ReviewVisibleEventHandlersAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2109)
CA2119 | Security | Disabled | SealMethodsThatSatisfyPrivateInterfacesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2119)
CA2153 | Security | Disabled | DoNotCatchCorruptedStateExceptionsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2153)
CA2200 | Usage | Warning | RethrowToPreserveStackDetailsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2200)
CA2201 | Usage | Hidden | DoNotRaiseReservedExceptionTypesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2201)
CA2207 | Usage | Disabled | InitializeStaticFieldsInlineAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2207)
CA2208 | Usage | Info | InstantiateArgumentExceptionsCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2208)
CA2211 | Usage | Info | NonConstantFieldsShouldNotBeVisibleAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2211)
CA2213 | Usage | Disabled | DisposableFieldsShouldBeDisposed, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2213)
CA2214 | Usage | Disabled | DoNotCallOverridableMethodsInConstructorsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2214)
CA2215 | Usage | Hidden | DisposeMethodsShouldCallBaseClassDispose, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2215)
CA2216 | Usage | Disabled | DisposableTypesShouldDeclareFinalizerAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2216)
CA2217 | Usage | Disabled | EnumWithFlagsAttributeAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2217)
CA2219 | Usage | Info | DoNotRaiseExceptionsInExceptionClausesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2219)
CA2225 | Usage | Disabled | OperatorOverloadsHaveNamedAlternatesAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2225)
CA2226 | Usage | Disabled | OperatorsShouldHaveSymmetricalOverloadsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2226)
CA2227 | Usage | Disabled | CollectionPropertiesShouldBeReadOnlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2227)
CA2229 | Usage | Hidden | SerializationRulesDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2229)
CA2231 | Usage | Info | OverloadOperatorEqualsOnOverridingValueTypeEqualsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2231)
CA2234 | Usage | Disabled | PassSystemUriObjectsInsteadOfStringsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2234)
CA2235 | Usage | Disabled | SerializationRulesDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2235)
CA2237 | Usage | Disabled | SerializationRulesDiagnosticAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2237)
CA2241 | Usage | Info | ProvideCorrectArgumentsToFormattingMethodsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2241)
CA2242 | Usage | Info | TestForNaNCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2242)
CA2243 | Usage | Disabled | AttributeStringLiteralsShouldParseCorrectlyAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2243)
CA2244 | Usage | Info | AvoidDuplicateElementInitialization, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2244)
CA2245 | Usage | Info | AvoidPropertySelfAssignment, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2245)
CA2246 | Usage | Info | AssigningSymbolAndItsMemberInSameStatement, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2246)
CA2247 | Usage | Warning | DoNotCreateTaskCompletionSourceWithWrongArguments, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2247)
CA2248 | Usage | Info | ProvideCorrectArgumentToEnumHasFlag, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2248)
CA2249 | Usage | Info | PreferStringContainsOverIndexOfAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2249)
CA2300 | Security | Disabled | DoNotUseInsecureDeserializerBinaryFormatterMethods, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2300)
CA2301 | Security | Disabled | DoNotUseInsecureDeserializerBinaryFormatterWithoutBinder, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2301)
CA2302 | Security | Disabled | DoNotUseInsecureDeserializerBinaryFormatterWithoutBinder, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2302)
CA2305 | Security | Disabled | DoNotUseInsecureDeserializerLosFormatter, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2305)
CA2310 | Security | Disabled | DoNotUseInsecureDeserializerNetDataContractSerializerMethods, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2310)
CA2311 | Security | Disabled | DoNotUseInsecureDeserializerNetDataContractSerializerWithoutBinder, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2311)
CA2312 | Security | Disabled | DoNotUseInsecureDeserializerNetDataContractSerializerWithoutBinder, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2312)
CA2315 | Security | Disabled | DoNotUseInsecureDeserializerObjectStateFormatter, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2315)
CA2321 | Security | Disabled | DoNotUseInsecureDeserializerJavaScriptSerializerWithSimpleTypeResolver, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2321)
CA2322 | Security | Disabled | DoNotUseInsecureDeserializerJavaScriptSerializerWithSimpleTypeResolver, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2322)
CA2326 | Security | Disabled | JsonNetTypeNameHandling, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2326)
CA2327 | Security | Disabled | DoNotUseInsecureSettingsForJsonNet, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2327)
CA2328 | Security | Disabled | DoNotUseInsecureSettingsForJsonNet, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2328)
CA2329 | Security | Disabled | DoNotUseInsecureDeserializerJsonNetWithoutBinder, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2329)
CA2330 | Security | Disabled | DoNotUseInsecureDeserializerJsonNetWithoutBinder, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2330)
CA2350 | Security | Disabled | DoNotUseDataTableReadXml, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2350)
CA2351 | Security | Disabled | DoNotUseDataSetReadXml, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2351)
CA2352 | Security | Disabled | DataSetDataTableInSerializableTypeAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2352)
CA2353 | Security | Disabled | DataSetDataTableInSerializableTypeAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2353)
CA2354 | Security | Disabled | DataSetDataTableInIFormatterSerializableObjectGraphAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2354)
CA2355 | Security | Disabled | DataSetDataTableInSerializableObjectGraphAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2355)
CA2356 | Security | Disabled | DataSetDataTableInWebSerializableObjectGraphAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2356)
CA2361 | Security | Disabled | DoNotUseDataSetReadXml, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2361)
CA2362 | Security | Disabled | DataSetDataTableInSerializableTypeAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2362)
CA3001 | Security | Disabled | ReviewCodeForSqlInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3001)
CA3002 | Security | Disabled | ReviewCodeForXssVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3002)
CA3003 | Security | Disabled | ReviewCodeForFilePathInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3003)
CA3004 | Security | Disabled | ReviewCodeForInformationDisclosureVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3004)
CA3005 | Security | Disabled | ReviewCodeForLdapInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3005)
CA3006 | Security | Disabled | ReviewCodeForCommandExecutionVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3006)
CA3007 | Security | Disabled | ReviewCodeForOpenRedirectVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3007)
CA3008 | Security | Disabled | ReviewCodeForXPathInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3008)
CA3009 | Security | Disabled | ReviewCodeForXmlInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3009)
CA3010 | Security | Disabled | ReviewCodeForXamlInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3010)
CA3011 | Security | Disabled | ReviewCodeForDllInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3011)
CA3012 | Security | Disabled | ReviewCodeForRegexInjectionVulnerabilities, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3012)
CA3061 | Security | Hidden | DoNotAddSchemaByURL, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3061)
CA3075 | Security | Hidden | DoNotUseInsecureDtdProcessingAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3075)
CA3076 | Security | Hidden | DoNotUseInsecureXSLTScriptExecutionAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3076)
CA3077 | Security | Hidden | DoNotUseInsecureDtdProcessingInApiDesignAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3077)
CA3147 | Security | Hidden | MarkVerbHandlersWithValidateAntiforgeryTokenAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca3147)
CA5350 | Security | Hidden | DoNotUseInsecureCryptographicAlgorithmsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5350)
CA5351 | Security | Hidden | DoNotUseInsecureCryptographicAlgorithmsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5351)
CA5358 | Security | Disabled | ApprovedCipherModeAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5358)
CA5359 | Security | Hidden | DoNotDisableCertificateValidation, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5359)
CA5360 | Security | Hidden | DoNotCallDangerousMethodsInDeserialization, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5360)
CA5361 | Security | Disabled | DoNotSetSwitch, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5361)
CA5362 | Security | Disabled | PotentialReferenceCycleInDeserializedObjectGraph, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5362)
CA5363 | Security | Hidden | DoNotDisableRequestValidation, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5363)
CA5364 | Security | Hidden | DoNotUseDeprecatedSecurityProtocols, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5364)
CA5365 | Security | Hidden | DoNotDisableHTTPHeaderChecking, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5365)
CA5366 | Security | Hidden | UseXmlReaderForDataSetReadXml, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5366)
CA5367 | Security | Disabled | DoNotSerializeTypeWithPointerFields, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5367)
CA5368 | Security | Hidden | SetViewStateUserKey, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5368)
CA5369 | Security | Hidden | UseXmlReaderForDeserialize, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5369)
CA5370 | Security | Hidden | UseXmlReaderForValidatingReader, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5370)
CA5371 | Security | Hidden | UseXmlReaderForSchemaRead, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5371)
CA5372 | Security | Hidden | UseXmlReaderForXPathDocument, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5372)
CA5373 | Security | Hidden | DoNotUseObsoleteKDFAlgorithm, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5373)
CA5374 | Security | Hidden | DoNotUseXslTransform, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5374)
CA5375 | Security | Disabled | DoNotUseAccountSAS, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5375)
CA5376 | Security | Disabled | UseSharedAccessProtocolHttpsOnly, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5376)
CA5377 | Security | Disabled | UseContainerLevelAccessPolicy, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5377)
CA5378 | Security | Disabled | DoNotSetSwitch, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5378)
CA5379 | Security | Hidden | DoNotUseWeakKDFAlgorithm, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5379)
CA5380 | Security | Disabled | DoNotInstallRootCert, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5380)
CA5381 | Security | Disabled | DoNotInstallRootCert, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5381)
CA5382 | Security | Disabled | UseSecureCookiesASPNetCore, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5382)
CA5383 | Security | Disabled | UseSecureCookiesASPNetCore, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5383)
CA5384 | Security | Hidden | DoNotUseDSA, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5384)
CA5385 | Security | Hidden | UseRSAWithSufficientKeySize, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5385)
CA5386 | Security | Disabled | DoNotUseDeprecatedSecurityProtocols, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5386)
CA5387 | Security | Disabled | DoNotUseWeakKDFInsufficientIterationCount, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5387)
CA5388 | Security | Disabled | DoNotUseWeakKDFInsufficientIterationCount, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5388)
CA5389 | Security | Disabled | DoNotAddArchiveItemPathToTheTargetFileSystemPath, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5389)
CA5390 | Security | Disabled | DoNotHardCodeEncryptionKey, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5390)
CA5391 | Security | Disabled | UseAutoValidateAntiforgeryToken, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5391)
CA5392 | Security | Disabled | UseDefaultDllImportSearchPathsAttribute, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5392)
CA5393 | Security | Disabled | UseDefaultDllImportSearchPathsAttribute, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5393)
CA5394 | Security | Disabled | DoNotUseInsecureRandomness, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5394)
CA5395 | Security | Disabled | UseAutoValidateAntiforgeryToken, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5395)
CA5396 | Security | Disabled | SetHttpOnlyForHttpCookie, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5396)
CA5397 | Security | Hidden | SslProtocolsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5397)
CA5398 | Security | Disabled | SslProtocolsAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5398)
CA5399 | Security | Disabled | DoNotDisableHttpClientCRLCheck, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5399)
CA5400 | Security | Disabled | DoNotDisableHttpClientCRLCheck, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5400)
CA5401 | Security | Disabled | DoNotUseCreateEncryptorWithNonDefaultIV, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5401)
CA5402 | Security | Disabled | DoNotUseCreateEncryptorWithNonDefaultIV, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5402)
CA5403 | Security | Disabled | DoNotHardCodeCertificate, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca5403)
IL3000 | Publish | Warning | AvoidAssemblyLocationInSingleFile, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/il3000)
IL3001 | Publish | Warning | AvoidAssemblyLocationInSingleFile, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/il3001)

## Release 6.0

### New Rules

Rule ID | Category | Severity | Notes
--------|----------|----------|-------
CA1418 | Interoperability | Warning | UseValidPlatformString, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1418)
CA1419 | Interoperability | Info | ProvidePublicParameterlessSafeHandleConstructor, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1419)
CA1727 | Naming | Hidden | LoggerMessageDefineAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1727)
CA1839 | Performance | Info | UseEnvironmentMembers, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1839)
CA1840 | Performance | Info | UseEnvironmentMembers, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1840)
CA1841 | Performance | Info | PreferDictionaryContainsMethods, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1841)
CA1842 | Performance | Info | DoNotUseWhenAllOrWaitAllWithSingleArgument, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1842)
CA1843 | Performance | Info | DoNotUseWhenAllOrWaitAllWithSingleArgument, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1843)
CA1844 | Performance | Info | ProvideStreamMemoryBasedAsyncOverrides, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1844)
CA1845 | Performance | Info | UseSpanBasedStringConcat, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1845)
CA1846 | Performance | Info | PreferAsSpanOverSubstring, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1846)
CA1847 | Performance | Info | UseStringContainsCharOverloadWithSingleCharactersAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1847)
CA1848 | Performance | Hidden | LoggerMessageDefineAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1848)
CA2017 | Reliability | Warning | LoggerMessageDefineAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2017)
CA2018 | Reliability | Warning | BufferBlockCopyLengthAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2018)
CA2250 | Usage | Info | UseCancellationTokenThrowIfCancellationRequested, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2250)
CA2251 | Usage | Hidden | UseStringEqualsOverStringCompare, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2251)
CA2252 | Usage | Error | DetectPreviewFeatureAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2252)
CA2253 | Usage | Info | LoggerMessageDefineAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2253)
CA2254 | Usage | Info | LoggerMessageDefineAnalyzer, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2254)
CA2255 | Usage | Warning | ModuleInitializerAttributeShouldNotBeUsedInLibraries, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2255)
CA2256 | Usage | Warning | InterfaceMembersMissingImplementation, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2256)
CA2257 | Usage | Warning | MembersDeclaredOnImplementationTypeMustBeStatic, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2257)
CA2258 | Usage | Warning | DynamicInterfaceCastableImplementationUnsupported, [Documentation](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca2258)

### Removed Rules

Rule ID | Category | Severity | Notes
--------|----------|----------|-------
CA1801 | Usage | Disabled | ReviewUnusedParametersAnalyzer, [Documentation](https://docs.microsoft.com/visualstudio/code-quality/ca1801)
IL3000 | Publish | Disabled | Moved analyzer to mono/linker
IL3001 | Publish | Disabled | Moved analyzer to mono/linker
