/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.type.Facet;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class LengthFacet
extends Facet {
    int requiredLength;

    public String getName() {
        return "length";
    }

    public String getValue() {
        return "" + this.requiredLength;
    }

    public long toLong() {
        return this.requiredLength;
    }

    public void setValue(String value) throws SchemaException {
        try {
            this.requiredLength = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SchemaException("Value of " + this.getName() + " facet \u00ab" + value + "\u00bb is not an integer");
        }
        if (this.requiredLength < 0) {
            throw new SchemaException("Value of " + this.getName() + " facet \u00ab" + value + "\u00bb must be a positive integer");
        }
    }

    public void checkFacetRestriction(SimpleType base) throws SchemaException {
        Facet baseFacet = base.getFacet("length");
        if (baseFacet != null && this.requiredLength != ((LengthFacet)baseFacet).requiredLength) {
            throw new SchemaException("In a type derived by restriction, the length facet must not be changed");
        }
        baseFacet = base.getFacet("minLength");
        if (baseFacet != null && (long)this.requiredLength < baseFacet.toLong()) {
            throw new SchemaException("In a type derived by restriction, the length facet is shorter than the minLength of the base type");
        }
        baseFacet = base.getFacet("maxLength");
        if (baseFacet != null && (long)this.requiredLength > baseFacet.toLong()) {
            throw new SchemaException("In a type derived by restriction, the length facet is longer than the maxLength of the base type");
        }
    }

    public boolean testAtomicValue(AtomicValue value) {
        if (!(value instanceof StringValue)) {
            try {
                value = value.convert(513);
            }
            catch (XPathException e) {
                return false;
            }
        }
        return this.testLength(((StringValue)value).getLength());
    }

    public boolean testLength(int actualLength) {
        return actualLength == this.requiredLength;
    }
}

