/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.tccl.logfactory;

import java.net.URL;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;

public class TcclDisabledTestCase
extends TestCase {
    public static final String MY_LOG_FACTORY_PKG = "org.apache.commons.logging.tccl.custom";
    public static final String MY_LOG_FACTORY_IMPL = "org.apache.commons.logging.tccl.custom.MyLogFactoryImpl";
    static /* synthetic */ Class class$org$apache$commons$logging$tccl$logfactory$TcclDisabledTestCase;
    static /* synthetic */ Class class$junit$framework$Test;

    public static Test suite() throws Exception {
        Class thisClass = class$org$apache$commons$logging$tccl$logfactory$TcclDisabledTestCase == null ? (class$org$apache$commons$logging$tccl$logfactory$TcclDisabledTestCase = TcclDisabledTestCase.class$("org.apache.commons.logging.tccl.logfactory.TcclDisabledTestCase")) : class$org$apache$commons$logging$tccl$logfactory$TcclDisabledTestCase;
        PathableClassLoader dummy = new PathableClassLoader(null);
        dummy.useExplicitLoader("junit.", (class$junit$framework$Test == null ? (class$junit$framework$Test = TcclDisabledTestCase.class$("junit.framework.Test")) : class$junit$framework$Test).getClassLoader());
        dummy.addLogicalLib("testclasses");
        dummy.addLogicalLib("commons-logging");
        String thisClassPath = thisClass.getName().replace('.', '/') + ".class";
        URL baseUrl = dummy.findResource(thisClassPath);
        PathableClassLoader emptyLoader = new PathableClassLoader(null);
        PathableClassLoader parentLoader = new PathableClassLoader(null);
        parentLoader.useExplicitLoader("junit.", (class$junit$framework$Test == null ? (class$junit$framework$Test = TcclDisabledTestCase.class$("junit.framework.Test")) : class$junit$framework$Test).getClassLoader());
        parentLoader.addLogicalLib("commons-logging");
        parentLoader.addLogicalLib("testclasses");
        parentLoader.useExplicitLoader("org.apache.commons.logging.tccl.custom.", emptyLoader);
        URL propsEnableUrl = new URL(baseUrl, "props_disable_tccl/");
        parentLoader.addURL(propsEnableUrl);
        PathableClassLoader tcclLoader = new PathableClassLoader(parentLoader);
        tcclLoader.addLogicalLib("testclasses");
        Class<?> testClass = parentLoader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, tcclLoader);
    }

    public void setUp() throws Exception {
        LogFactory.releaseAll();
    }

    public void tearDown() {
        LogFactory.releaseAll();
    }

    public void testLoader() throws Exception {
        Class<?> clazz;
        ClassLoader thisClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader tcclLoader = Thread.currentThread().getContextClassLoader();
        Assert.assertNotSame((String)"tccl not same as test classloader", (Object)thisClassLoader, (Object)tcclLoader);
        try {
            clazz = thisClassLoader.loadClass(MY_LOG_FACTORY_IMPL);
            Assert.fail((String)"Unexpectedly able to load MyLogFactoryImpl via test class classloader");
            Assert.assertNotNull(clazz);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            clazz = tcclLoader.loadClass(MY_LOG_FACTORY_IMPL);
            Assert.assertNotNull(clazz);
        }
        catch (ClassNotFoundException ex) {
            Assert.fail((String)"Unexpectedly unable to load MyLogFactoryImpl via tccl classloader");
        }
    }

    public void testTcclLoading() throws Exception {
        try {
            LogFactory instance = LogFactory.getFactory();
            Assert.fail((String)"Unexpectedly succeeded in loading custom factory, though TCCL disabled.");
            Assert.assertNotNull((Object)instance);
        }
        catch (LogConfigurationException ex) {
            int index = ex.getMessage().indexOf(MY_LOG_FACTORY_IMPL);
            Assert.assertTrue((String)"MylogFactoryImpl not found", (index >= 0 ? 1 : 0) != 0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

