# trust signer remove

<!---MARKER_GEN_START-->
Remove a signer

### Options

| Name            | Type | Default | Description                                                           |
|:----------------|:-----|:--------|:----------------------------------------------------------------------|
| `-f`, `--force` |      |         | Do not prompt for confirmation before removing the most recent signer |


<!---MARKER_GEN_END-->

## Description

`docker trust signer remove` removes signers from signed repositories.

## Examples

### Remove a signer from a repository

To remove an existing signer, `alice`, from this repository:

```console
$ docker trust inspect --pretty example/trust-demo

No signatures for example/trust-demo


List of signers and their keys:

SIGNER              KEYS
alice               05e87edcaecb
bob                 5600f5ab76a2

Administrative keys for example/trust-demo:
Repository Key: ecc457614c9fc399da523a5f4e24fe306a0a6ee1cc79a10e4555b3c6ab02f71e
Root Key:       3cb2228f6561e58f46dbc4cda4fcaff9d5ef22e865a94636f82450d1d2234949
```

Remove `alice` with `docker trust signer remove`:

```console
$ docker trust signer remove alice example/trust-demo

Removing signer "alice" from image example/trust-demo...
Enter passphrase for repository key with ID 642692c:
Successfully removed alice from example/trust-demo
```

`docker trust inspect --pretty` now doesn't list `alice` as a valid signer:

```console
$ docker trust inspect --pretty example/trust-demo

No signatures for example/trust-demo


List of signers and their keys:

SIGNER              KEYS
bob                 5600f5ab76a2

Administrative keys for example/trust-demo:
Repository Key: ecc457614c9fc399da523a5f4e24fe306a0a6ee1cc79a10e4555b3c6ab02f71e
Root Key:       3cb2228f6561e58f46dbc4cda4fcaff9d5ef22e865a94636f82450d1d2234949
```

### Remove a signer from multiple repositories

To remove an existing signer, `alice`, from multiple repositories:

```console
$ docker trust inspect --pretty example/trust-demo

SIGNED TAG          DIGEST                                                             SIGNERS
v1                  74d4bfa917d55d53c7df3d2ab20a8d926874d61c3da5ef6de15dd2654fc467c4   alice, bob

List of signers and their keys:

SIGNER              KEYS
alice               05e87edcaecb
bob                 5600f5ab76a2

Administrative keys for example/trust-demo:
Repository Key: 95b9e5514c9fc399da523a5f4e24fe306a0a6ee1cc79a10e4555b3c6ab02f71e
Root Key:       3cb2228f6561e58f46dbc4cda4fcaff9d5ef22e865a94636f82450d1d2234949
```

```console
$ docker trust inspect --pretty example/trust-demo2

SIGNED TAG          DIGEST                                                             SIGNERS
v1                  74d4bfa917d55d53c7df3d2ab20a8d926874d61c3da5ef6de15dd2654fc467c4   alice, bob

List of signers and their keys:

SIGNER              KEYS
alice               05e87edcaecb
bob                 5600f5ab76a2

Administrative keys for example/trust-demo2:
Repository Key: ece554f14c9fc399da523a5f4e24fe306a0a6ee1cc79a10e4553d2ab20a8d9268
Root Key:       3cb2228f6561e58f46dbc4cda4fcaff9d5ef22e865a94636f82450d1d2234949
```

Remove `alice` from both images with a single `docker trust signer remove` command:

```console
$ docker trust signer remove alice example/trust-demo example/trust-demo2

Removing signer "alice" from image example/trust-demo...
Enter passphrase for repository key with ID 95b9e55:
Successfully removed alice from example/trust-demo

Removing signer "alice" from image example/trust-demo2...
Enter passphrase for repository key with ID ece554f:
Successfully removed alice from example/trust-demo2
```

Run `docker trust inspect --pretty` to confirm that `alice` is no longer listed as a valid
signer of either `example/trust-demo` or `example/trust-demo2`:

```console
$ docker trust inspect --pretty example/trust-demo

SIGNED TAG          DIGEST                                                             SIGNERS
v1                  74d4bfa917d55d53c7df3d2ab20a8d926874d61c3da5ef6de15dd2654fc467c4   bob

List of signers and their keys:

SIGNER              KEYS
bob                 5600f5ab76a2

Administrative keys for example/trust-demo:
Repository Key: ecc457614c9fc399da523a5f4e24fe306a0a6ee1cc79a10e4555b3c6ab02f71e
Root Key:       3cb2228f6561e58f46dbc4cda4fcaff9d5ef22e865a94636f82450d1d2234949
```

```console
$ docker trust inspect --pretty example/trust-demo2

SIGNED TAG          DIGEST                                                             SIGNERS
v1                  74d4bfa917d55d53c7df3d2ab20a8d926874d61c3da5ef6de15dd2654fc467c4   bob

List of signers and their keys:

SIGNER              KEYS
bob                 5600f5ab76a2

Administrative keys for example/trust-demo2:
Repository Key: ece554f14c9fc399da523a5f4e24fe306a0a6ee1cc79a10e4553d2ab20a8d9268
Root Key:       3cb2228f6561e58f46dbc4cda4fcaff9d5ef22e865a94636f82450d1d2234949
```

`docker trust signer remove` removes signers to repositories on a best effort basis.
It continues to remove the signer from subsequent repositories if one attempt fails:

```console
$ docker trust signer remove alice example/unauthorized example/authorized

Removing signer "alice" from image example/unauthorized...
No signer alice for image example/unauthorized

Removing signer "alice" from image example/authorized...
Enter passphrase for repository key with ID c6772a0:
Successfully removed alice from example/authorized

Error removing signer from: example/unauthorized
```
