#if !defined (__SEMAPHOREEXCEPTION_HPP)
#define __SEMAPHOREEXCEPTION_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{


   DECLARE_CLASS( SemaphoreException );

   /**
   SemaphoreException is the base exception type for Semaphore. All
   Semaphore exceptions derive from this.
   */

   class SemaphoreException : public Exception
   {
   
   public:
   
                        /**
                        Default Constructor
                        @param why describes why the exception was thrown
                        @param file The source module throwing the exception
                        @param line The line of source throwing the exception
                        @param severity The Exception::Severity of the Exception
                        @param outOfMemory An out of memory indicator
                        */

                        SemaphoreException
                        (
                           CharCptr why,
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false ,
                           Int      errNum = 0
                        );
   
                        /**
                        Copy constructor
                        @param SemaphoreException const reference
                        */
                     
                        SemaphoreException( SemaphoreExceptionCref );
   
                        /// Virtual Destructor
   
      virtual           ~SemaphoreException( void );
   
         //
         // Operator overloads
         //
   
               /**
               Assignment operator overload
               @param  SemaphoreException const reference
               @return SemaphoreException reference to self
               */
            
               SemaphoreExceptionRef   operator=( SemaphoreExceptionCref );
            
               /**
               Equality operator overload
               @param SemaphoreException const reference
               @return true if equal, false otherwise
               */

               bool           operator==( SemaphoreExceptionCref ) const;
            
         //
         // Accessor methods
         //
   
               IntCref        getErrNum( void ) const;
            
         //
         // Mutator methods
         //
   
   
   protected:

                        /**
                        Default Constructor
                        @param file The source module throwing the exception
                        @param line The line of source throwing the exception
                        @param severity The Exception::Severity of the Exception
                        @param outOfMemory An out of memory indicator
                        */

                        SemaphoreException
                        (
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false  ,
                           Int      errNum = 0
                        );

                        /**
                        SemaphoreException must have at least
                        a location..
                        Default constructor is not allowed.
                        */   
                     
                        SemaphoreException( void );
   
   
   private:

               Int      theErrorNumberFromKernel;
   
   };

}


#endif  // !defined __SemaphoreEXCEPTION_HPP

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/



