/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.api.Benchmark;
import com.google.caliper.model.Measurement;
import com.google.caliper.util.Parser;
import com.google.caliper.util.Parsers;
import com.google.caliper.util.Util;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import com.google.caliper.worker.WorkerRequest;
import com.google.caliper.worker.WorkerResponse;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;

public final class WorkerMain {
    private WorkerMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        WorkerRequest request = (WorkerRequest)Util.GSON.fromJson(args[0], WorkerRequest.class);
        Class<?> benchmarkClass = Class.forName(request.benchmarkClassName);
        Benchmark benchmark = (Benchmark)WorkerMain.construct(benchmarkClass);
        ImmutableMap parameters = ImmutableMap.builder().putAll(request.injectedParameters).putAll(request.vmArguments).build();
        for (String fieldName : parameters.keySet()) {
            Field field = benchmarkClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            Parser<?> parser = Parsers.conventionalParser(field.getType());
            field.set(benchmark, parser.parse((CharSequence)parameters.get((Object)fieldName)));
        }
        Worker worker = (Worker)WorkerMain.construct(request.workerClassName);
        WorkerEventLog log = new WorkerEventLog();
        try {
            WorkerMain.runSetUp(benchmark);
            Collection<Measurement> measurements = worker.measure(benchmark, request.benchmarkMethodName, request.instrumentOptions, log);
            System.out.println("//ZxJ/" + new WorkerResponse(measurements));
            System.out.flush();
        }
        finally {
            WorkerMain.runTearDown(benchmark);
        }
    }

    private static Object construct(String className) throws Exception {
        return WorkerMain.construct(Class.forName(className));
    }

    private static Object construct(Class<?> aClass) throws Exception {
        Constructor<?> constructor = aClass.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    private static void runSetUp(Benchmark benchmark) throws Exception {
        WorkerMain.runBenchmarkMethod(benchmark, "setUp");
    }

    private static void runTearDown(Benchmark benchmark) throws Exception {
        WorkerMain.runBenchmarkMethod(benchmark, "tearDown");
    }

    private static void runBenchmarkMethod(Benchmark benchmark, String methodName) throws Exception {
        Method method = Benchmark.class.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)benchmark, new Object[0]);
    }
}

