/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.http.ChunkedInputStream;
import sun.net.www.http.HttpClient;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.protocol.http.AuthenticationHeader;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.BasicAuthentication;
import sun.net.www.protocol.http.DigestAuthentication;
import sun.net.www.protocol.http.EmptyInputStream;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpAuthenticator;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    static final String version;
    public static final String userAgent;
    static final int defaultmaxRedirects = 20;
    static final int maxRedirects;
    static final boolean validateProxy;
    static final boolean validateServer;
    static final String httpVersion = "HTTP/1.1";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private static final String[] EXCLUDE_HEADERS;
    protected HttpClient http;
    protected Handler handler;
    protected PrintStream ps = null;
    private static HttpAuthenticator defaultAuth;
    private MessageHeader requests;
    String domain;
    DigestAuthentication.Parameters digestparams;
    AuthenticationInfo currentProxyCredentials = null;
    AuthenticationInfo currentServerCredentials = null;
    boolean needToCheck = true;
    private boolean doingNTLM2ndStage = false;
    private boolean doingNTLMp2ndStage = false;
    Object authObj;
    protected ProgressEntry pe;
    private MessageHeader responses;
    private InputStream inputStream = null;
    private PosterOutputStream poster = null;
    private boolean setRequests = false;
    private boolean failedOnce = false;
    private Exception rememberedException = null;
    private HttpClient reuseClient = null;
    byte[] cdata = new byte[128];

    private static PasswordAuthentication privilegedRequestPasswordAuthentication(final String string, final InetAddress inetAddress, final int n, final String string2, final String string3, final String string4) {
        return (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Authenticator.requestPasswordAuthentication(string, inetAddress, n, string2, string3, string4);
            }
        });
    }

    private void checkMessageHeader(String string, String string2) {
        int n = 10;
        int n2 = string.indexOf(n);
        if (n2 != -1) {
            throw new IllegalArgumentException("Illegal character(s) in message header field: " + string);
        }
        if (string2 == null) {
            return;
        }
        n2 = string2.indexOf(n);
        while (n2 != -1) {
            char c;
            if (++n2 < string2.length() && ((c = string2.charAt(n2)) == ' ' || c == '\t')) {
                n2 = string2.indexOf(n, n2);
                continue;
            }
            throw new IllegalArgumentException("Illegal character(s) in message header value: " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequests() throws IOException {
        if (!this.setRequests) {
            Object object;
            Cloneable cloneable;
            long l;
            if (!this.failedOnce) {
                this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            }
            if (!this.getUseCaches()) {
                this.requests.setIfNotSet("Cache-Control", "no-cache");
                this.requests.setIfNotSet("Pragma", "no-cache");
            }
            this.requests.setIfNotSet("User-Agent", userAgent);
            int n = this.url.getPort();
            String string = this.url.getHost();
            if (n != -1 && n != 80) {
                string = string + ":" + String.valueOf(n);
            }
            this.requests.setIfNotSet("Host", string);
            this.requests.setIfNotSet("Accept", acceptString);
            if (!this.failedOnce && this.http.getHttpKeepAliveSet()) {
                if (this.http.usingProxy) {
                    this.requests.setIfNotSet("Proxy-Connection", "keep-alive");
                } else {
                    this.requests.setIfNotSet("Connection", "keep-alive");
                }
            }
            if (this.http.usingProxy) {
                this.setPreemptiveProxyAuthentication(this.requests);
            }
            if ((l = this.getIfModifiedSince()) != 0L) {
                cloneable = new Date(l);
                object = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
                this.requests.setIfNotSet("If-Modified-Since", ((DateFormat)object).format((Date)cloneable));
            }
            if ((cloneable = AuthenticationInfo.getServerAuth(this.url)) != null && ((AuthenticationInfo)cloneable).supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(((AuthenticationInfo)cloneable).getHeaderName(), ((AuthenticationInfo)cloneable).getHeaderValue(this.url, this.method));
                this.currentServerCredentials = cloneable;
            }
            if (this.poster != null) {
                object = this.poster;
                synchronized (object) {
                    this.poster.close();
                    if (!this.method.equals("PUT")) {
                        String string2 = "application/x-www-form-urlencoded";
                        this.requests.setIfNotSet("Content-Type", string2);
                    }
                    this.requests.set("Content-Length", String.valueOf(this.poster.size()));
                }
            }
            this.setRequests = true;
        }
        this.http.writeRequests(this.requests, this.poster);
        if (this.ps.checkError()) {
            String string = this.http.getProxyHostUsed();
            int n = this.http.getProxyPortUsed();
            this.disconnectInternal();
            if (this.failedOnce) {
                throw new IOException("Error writing to server");
            }
            this.failedOnce = true;
            if (string != null) {
                this.setProxiedClient(this.url, string, n);
            } else {
                this.setNewClient(this.url);
            }
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    protected void setNewClient(URL uRL) throws IOException {
        this.setNewClient(uRL, false);
    }

    protected void setNewClient(URL uRL, boolean bl) throws IOException {
        this.http = HttpClient.New(uRL, bl);
    }

    protected void setProxiedClient(URL uRL, String string, int n) throws IOException {
        this.setProxiedClient(uRL, string, n, false);
    }

    protected void setProxiedClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this.proxiedConnect(uRL, string, n, bl);
    }

    protected void proxiedConnect(URL uRL, String string, int n, boolean bl) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, n);
        }
        this.http = HttpClient.New(uRL, string, n, bl);
    }

    protected HttpURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL);
        this.requests = new MessageHeader();
        this.responses = new MessageHeader();
        this.handler = handler;
    }

    public HttpURLConnection(URL uRL, String string, int n) throws IOException {
        this(uRL, new Handler(string, n));
    }

    public static void setDefaultAuthenticator(HttpAuthenticator httpAuthenticator) {
        defaultAuth = httpAuthenticator;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection uRLConnection) throws IOException {
        boolean bl;
        int n = 0;
        InputStream inputStream = null;
        do {
            HttpURLConnection httpURLConnection;
            int n2;
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            }
            inputStream = uRLConnection.getInputStream();
            bl = false;
            if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) < 300 || n2 > 307 || n2 == 306 || n2 == 304) continue;
            URL uRL = httpURLConnection.getURL();
            String string = httpURLConnection.getHeaderField("Location");
            URL uRL2 = null;
            if (string != null) {
                uRL2 = new URL(uRL, string);
            }
            httpURLConnection.disconnect();
            if (uRL2 == null || !uRL.getProtocol().equals(uRL2.getProtocol()) || uRL.getPort() != uRL2.getPort() || !HttpURLConnection.hostsEqual(uRL, uRL2) || n >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            bl = true;
            uRLConnection = uRL2.openConnection();
            ++n;
        } while (bl);
        return inputStream;
    }

    private static boolean hostsEqual(URL uRL, URL uRL2) {
        final String string = uRL.getHost();
        final String string2 = uRL2.getHost();
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        final boolean[] blArray = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    InetAddress inetAddress2 = InetAddress.getByName(string2);
                    blArray[0] = inetAddress.equals(inetAddress2);
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return null;
            }
        });
        return blArray[0];
    }

    public void connect() throws IOException {
        this.plainConnect();
    }

    private boolean checkReuseConnection() {
        if (this.connected) {
            return true;
        }
        if (this.reuseClient != null) {
            this.http = this.reuseClient;
            this.http.reuse = false;
            this.reuseClient = null;
            this.connected = true;
            return true;
        }
        return false;
    }

    protected void plainConnect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url) : new HttpClient(this.url, this.handler.proxy, this.handler.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.method = "POST";
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            if (!this.checkReuseConnection()) {
                this.connect();
            }
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.poster == null) {
                this.poster = new PosterOutputStream();
            }
            return this.poster;
        }
        catch (RuntimeException runtimeException) {
            this.disconnectInternal();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.disconnectInternal();
            throw iOException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.rememberedException != null) {
            IOException iOException;
            if (this.rememberedException instanceof RuntimeException) {
                throw new RuntimeException(this.rememberedException);
            }
            try {
                iOException = new IOException();
                iOException.initCause(this.rememberedException);
                throw iOException;
            }
            catch (Exception exception) {
                iOException = (IOException)this.rememberedException;
            }
            throw iOException;
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        int n = 0;
        int n2 = 0;
        Object object = null;
        AuthenticationInfo authenticationInfo = null;
        AuthenticationHeader authenticationHeader = null;
        try {
            Object object2;
            block48: {
                block46: {
                    block47: {
                        try {
                            do {
                                Object object3;
                                this.pe = new ProgressEntry(this.url.getFile(), null);
                                ProgressData.pdata.register(this.pe);
                                if (!this.checkReuseConnection()) {
                                    this.connect();
                                }
                                this.ps = (PrintStream)this.http.getOutputStream();
                                this.writeRequests();
                                this.http.parseHTTP(this.responses, this.pe);
                                this.inputStream = new HttpInputStream(this.http.getInputStream());
                                n2 = this.getResponseCode();
                                if (n2 == 407) {
                                    object3 = new AuthenticationHeader("Proxy-Authenticate", this.responses);
                                    if (!this.doingNTLMp2ndStage) {
                                        if ((authenticationInfo = this.resetProxyAuthentication(authenticationInfo, (AuthenticationHeader)object3)) != null) {
                                            ++n;
                                            this.disconnectInternal();
                                            continue;
                                        }
                                    } else {
                                        object2 = this.responses.findValue("Proxy-Authenticate");
                                        this.reset();
                                        if (!authenticationInfo.setHeaders(this, ((AuthenticationHeader)object3).headerParser(), (String)object2)) {
                                            this.disconnectInternal();
                                            throw new IOException("Authentication failure");
                                        }
                                        if (object != null && authenticationHeader != null && !((AuthenticationInfo)object).setHeaders(this, authenticationHeader.headerParser(), (String)object2)) {
                                            this.disconnectInternal();
                                            throw new IOException("Authentication failure");
                                        }
                                        this.authObj = null;
                                        this.doingNTLMp2ndStage = false;
                                        continue;
                                    }
                                }
                                if (authenticationInfo != null) {
                                    authenticationInfo.addToCache();
                                }
                                if (n2 == 401) {
                                    authenticationHeader = new AuthenticationHeader("WWW-Authenticate", this.responses);
                                    object3 = authenticationHeader.raw();
                                    if (!this.doingNTLM2ndStage) {
                                        if (object != null) {
                                            if (((AuthenticationInfo)object).isAuthorizationStale((String)object3)) {
                                                this.disconnectInternal();
                                                ++n;
                                                this.requests.set(((AuthenticationInfo)object).getHeaderName(), ((AuthenticationInfo)object).getHeaderValue(this.url, this.method));
                                                this.currentServerCredentials = object;
                                                continue;
                                            }
                                            ((AuthenticationInfo)object).removeFromCache();
                                        }
                                        object = this.getServerAuthentication(authenticationHeader);
                                        this.currentServerCredentials = object;
                                        if (object != null) {
                                            this.disconnectInternal();
                                            ++n;
                                            continue;
                                        }
                                    } else {
                                        this.reset();
                                        if (!((AuthenticationInfo)object).setHeaders(this, null, (String)object3)) {
                                            this.disconnectInternal();
                                            throw new IOException("Authentication failure");
                                        }
                                        this.doingNTLM2ndStage = false;
                                        this.authObj = null;
                                        continue;
                                    }
                                }
                                if (object != null) {
                                    Object object4;
                                    if (!(object instanceof DigestAuthentication) || this.domain == null) {
                                        if (object instanceof BasicAuthentication) {
                                            object2 = ((AuthenticationInfo)object).path;
                                            object3 = AuthenticationInfo.reducePath(this.url.getPath());
                                            if (!((String)object2).startsWith((String)object3) || ((String)object3).length() >= ((String)object2).length()) {
                                                object3 = BasicAuthentication.getRootPath((String)object2, (String)object3);
                                            }
                                            object4 = (BasicAuthentication)((AuthenticationInfo)object).clone();
                                            ((AuthenticationInfo)object).removeFromCache();
                                            ((BasicAuthentication)object4).path = object3;
                                            object = object4;
                                        }
                                        ((AuthenticationInfo)object).addToCache();
                                    } else {
                                        object3 = (DigestAuthentication)object;
                                        object2 = new StringTokenizer(this.domain, " ");
                                        object4 = ((DigestAuthentication)object3).realm;
                                        PasswordAuthentication passwordAuthentication = ((DigestAuthentication)object3).pw;
                                        this.digestparams = ((DigestAuthentication)object3).params;
                                        while (((StringTokenizer)object2).hasMoreTokens()) {
                                            String string = ((StringTokenizer)object2).nextToken();
                                            try {
                                                URL uRL = new URL(this.url, string);
                                                DigestAuthentication digestAuthentication = new DigestAuthentication(false, uRL, (String)object4, "Digest", passwordAuthentication, this.digestparams);
                                                digestAuthentication.addToCache();
                                            }
                                            catch (Exception exception) {}
                                        }
                                    }
                                }
                                if (n2 == 200) {
                                    this.checkResponseCredentials(false);
                                } else {
                                    this.needToCheck = false;
                                }
                                if (this.followRedirect()) {
                                    ++n;
                                    continue;
                                }
                                int n3 = -1;
                                try {
                                    n3 = Integer.parseInt(this.responses.findValue("content-length"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (this.method.equals("HEAD") || this.method.equals("TRACE") || n3 == 0 || n2 == 304 || n2 == 204) {
                                    if (this.pe != null) {
                                        ProgressData.pdata.unregister(this.pe);
                                    }
                                    this.http.finished();
                                    this.http = null;
                                    this.inputStream = new EmptyInputStream();
                                    if (n2 < 400) {
                                        this.connected = false;
                                        object2 = this.inputStream;
                                        Object var14_20 = null;
                                        if (n2 != 407 || authenticationInfo == null) break block46;
                                        break block47;
                                    }
                                }
                                if (n2 >= 400) {
                                    if (n2 == 404) throw new FileNotFoundException(this.url.toString());
                                    if (n2 != 410) throw new IOException("Server returned HTTP response code: " + n2 + " for URL: " + this.url.toString());
                                    throw new FileNotFoundException(this.url.toString());
                                }
                                object2 = this.inputStream;
                                break block48;
                            } while (n < maxRedirects);
                            throw new ProtocolException("Server redirected too many  times (" + n + ")");
                        }
                        catch (RuntimeException runtimeException) {
                            this.disconnectInternal();
                            this.rememberedException = runtimeException;
                            throw runtimeException;
                        }
                        catch (IOException iOException) {
                            this.rememberedException = iOException;
                            throw iOException;
                        }
                    }
                    authenticationInfo.endAuthRequest();
                    return object2;
                }
                if (n2 != 401) return object2;
                if (object == null) return object2;
                ((AuthenticationInfo)object).endAuthRequest();
                return object2;
            }
            Object var14_21 = null;
            if (n2 == 407 && authenticationInfo != null) {
                authenticationInfo.endAuthRequest();
                return object2;
            }
            if (n2 != 401) return object2;
            if (object == null) return object2;
            ((AuthenticationInfo)object).endAuthRequest();
            return object2;
        }
        catch (Throwable throwable) {
            Object var14_22 = null;
            if (n2 == 407 && authenticationInfo != null) {
                authenticationInfo.endAuthRequest();
                throw throwable;
            }
            if (n2 != 401) throw throwable;
            if (object == null) throw throwable;
            ((AuthenticationInfo)object).endAuthRequest();
            throw throwable;
        }
    }

    public InputStream getErrorStream() {
        if (this.connected && this.responseCode >= 400 && this.inputStream != null) {
            return this.inputStream;
        }
        return null;
    }

    private AuthenticationInfo resetProxyAuthentication(AuthenticationInfo authenticationInfo, AuthenticationHeader authenticationHeader) {
        if (authenticationInfo != null) {
            String string = authenticationHeader.raw();
            if (authenticationInfo.isAuthorizationStale(string)) {
                this.requests.set(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue(this.url, this.method));
                this.currentProxyCredentials = authenticationInfo;
                return authenticationInfo;
            }
            authenticationInfo.removeFromCache();
        }
        this.currentProxyCredentials = authenticationInfo = this.getHttpProxyAuthentication(authenticationHeader);
        return authenticationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doTunneling() throws IOException {
        int n = 0;
        String string = "";
        int n2 = 0;
        AuthenticationInfo authenticationInfo = null;
        String string2 = null;
        int n3 = -1;
        try {
            do {
                if (!this.checkReuseConnection()) {
                    this.proxiedConnect(this.url, string2, n3, false);
                }
                this.sendCONNECTRequest();
                this.responses.reset();
                this.http.parseHTTP(this.responses, new ProgressEntry(this.url.getFile(), null));
                string = this.responses.getValue(0);
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                stringTokenizer.nextToken();
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (n2 == 407) {
                    AuthenticationHeader authenticationHeader = new AuthenticationHeader("Proxy-Authenticate", this.responses);
                    if (!this.doingNTLMp2ndStage) {
                        if ((authenticationInfo = this.resetProxyAuthentication(authenticationInfo, authenticationHeader)) != null) {
                            string2 = this.http.getProxyHostUsed();
                            n3 = this.http.getProxyPortUsed();
                            this.disconnectInternal();
                            ++n;
                            continue;
                        }
                    } else {
                        String string3 = this.responses.findValue("Proxy-Authenticate");
                        this.reset();
                        if (!authenticationInfo.setHeaders(this, authenticationHeader.headerParser(), string3)) {
                            string2 = this.http.getProxyHostUsed();
                            n3 = this.http.getProxyPortUsed();
                            this.disconnectInternal();
                            throw new IOException("Authentication failure");
                        }
                        this.authObj = null;
                        this.doingNTLMp2ndStage = false;
                        continue;
                    }
                }
                if (authenticationInfo != null) {
                    authenticationInfo.addToCache();
                }
                if (n2 == 200) break;
                this.disconnectInternal();
                break;
            } while (n < maxRedirects);
            if (n >= maxRedirects || n2 != 200) {
                throw new IOException("Unable to tunnel through proxy. Proxy returns \"" + string + "\"");
            }
            Object var11_11 = null;
            if (n2 == 407 && authenticationInfo != null) {
                authenticationInfo.endAuthRequest();
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (n2 == 407 && authenticationInfo != null) {
                authenticationInfo.endAuthRequest();
            }
            throw throwable;
        }
        int n4 = this.requests.getKey("Proxy-authorization");
        if (n4 >= 0) {
            this.requests.set(n4, null, null);
        }
        this.responses.reset();
    }

    private void sendCONNECTRequest() throws IOException {
        int n = this.url.getPort();
        if (n == -1) {
            n = this.url.getDefaultPort();
        }
        this.requests.prepend("CONNECT " + this.url.getHost() + ":" + n + " " + httpVersion, null);
        this.requests.setIfNotSet("User-Agent", userAgent);
        String string = this.url.getHost();
        if (n != -1 && n != 80) {
            string = string + ":" + String.valueOf(n);
        }
        this.requests.setIfNotSet("Host", string);
        this.requests.setIfNotSet("Accept", acceptString);
        this.setPreemptiveProxyAuthentication(this.requests);
        this.http.writeRequests(this.requests, null);
        this.requests.set(0, null, null);
    }

    private void setPreemptiveProxyAuthentication(MessageHeader messageHeader) {
        AuthenticationInfo authenticationInfo = AuthenticationInfo.getProxyAuth(this.http.getProxyHostUsed(), this.http.getProxyPortUsed());
        if (authenticationInfo != null && authenticationInfo.supportsPreemptiveAuthorization()) {
            messageHeader.setIfNotSet(authenticationInfo.getHeaderName(), authenticationInfo.getHeaderValue(this.url, this.method));
            this.currentProxyCredentials = authenticationInfo;
        }
    }

    private AuthenticationInfo getHttpProxyAuthentication(AuthenticationHeader authenticationHeader) {
        AuthenticationInfo authenticationInfo = null;
        String string = authenticationHeader.raw();
        String string2 = this.http.getProxyHostUsed();
        int n = this.http.getProxyPortUsed();
        if (string2 != null && authenticationHeader.isPresent()) {
            Object object;
            Object object2;
            HeaderParser headerParser = authenticationHeader.headerParser();
            String string3 = headerParser.findValue("realm");
            String string4 = authenticationHeader.scheme();
            char c = "basic".equalsIgnoreCase(string4) ? (char)'B' : ("digest".equalsIgnoreCase(string4) ? (char)'D' : '\u0000');
            if (string3 == null) {
                string3 = "";
            }
            if ((authenticationInfo = AuthenticationInfo.getProxyAuth(string2, n, string3, c)) == null) {
                if (c == 'B') {
                    object2 = null;
                    try {
                        object = string2;
                        object2 = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction((String)object){
                            private final /* synthetic */ String val$finalHost;
                            {
                                this.val$finalHost = string;
                            }

                            public Object run() throws UnknownHostException {
                                return InetAddress.getByName(this.val$finalHost);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        // empty catch block
                    }
                    object = HttpURLConnection.privilegedRequestPasswordAuthentication(string2, object2, n, "http", string3, string4);
                    if (object != null) {
                        authenticationInfo = new BasicAuthentication(true, string2, n, string3, (PasswordAuthentication)object);
                    }
                } else if (c == 'D' && (object2 = HttpURLConnection.privilegedRequestPasswordAuthentication(string2, null, n, this.url.getProtocol(), string3, string4)) != null) {
                    object = new DigestAuthentication.Parameters();
                    authenticationInfo = new DigestAuthentication(true, string2, n, string3, string4, (PasswordAuthentication)object2, (DigestAuthentication.Parameters)object);
                }
            }
            if (authenticationInfo == null && defaultAuth != null && defaultAuth.schemeSupported(string4)) {
                try {
                    object2 = new URL("http", string2, n, "/");
                    object = defaultAuth.authString((URL)object2, string4, string3);
                    if (object != null) {
                        authenticationInfo = new BasicAuthentication(true, string2, n, string3, (String)object);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (authenticationInfo != null && !authenticationInfo.setHeaders(this, headerParser, string)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private AuthenticationInfo getServerAuthentication(AuthenticationHeader authenticationHeader) {
        AuthenticationInfo authenticationInfo = null;
        String string = authenticationHeader.raw();
        if (authenticationHeader.isPresent()) {
            Object object;
            int n;
            HeaderParser headerParser = authenticationHeader.headerParser();
            String string2 = headerParser.findValue("realm");
            String string3 = authenticationHeader.scheme();
            char c = "basic".equalsIgnoreCase(string3) ? (char)'B' : ("digest".equalsIgnoreCase(string3) ? (char)'D' : '\u0000');
            this.domain = headerParser.findValue("domain");
            if (string2 == null) {
                string2 = "";
            }
            authenticationInfo = AuthenticationInfo.getServerAuth(this.url, string2, c);
            InetAddress inetAddress = null;
            if (authenticationInfo == null) {
                try {
                    inetAddress = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if ((n = this.url.getPort()) == -1) {
                n = this.url.getDefaultPort();
            }
            if (authenticationInfo == null) {
                if (c == 'B' && (object = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), inetAddress, n, this.url.getProtocol(), string2, string3)) != null) {
                    authenticationInfo = new BasicAuthentication(false, this.url, string2, (PasswordAuthentication)object);
                }
                if (c == 'D' && (object = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), inetAddress, n, this.url.getProtocol(), string2, string3)) != null) {
                    this.digestparams = new DigestAuthentication.Parameters();
                    authenticationInfo = new DigestAuthentication(false, this.url, string2, string3, (PasswordAuthentication)object, this.digestparams);
                }
            }
            if (authenticationInfo == null && defaultAuth != null && defaultAuth.schemeSupported(string3) && (object = defaultAuth.authString(this.url, string3, string2)) != null) {
                authenticationInfo = new BasicAuthentication(false, this.url, string2, (String)object);
            }
            if (authenticationInfo != null && !authenticationInfo.setHeaders(this, headerParser, string)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    private void checkResponseCredentials(boolean bl) throws IOException {
        try {
            String string;
            if (!this.needToCheck) {
                return;
            }
            if (validateProxy && this.currentProxyCredentials != null) {
                string = this.responses.findValue("Proxy-Authentication-Info");
                if (bl || string != null) {
                    this.currentProxyCredentials.checkResponse(string, this.method, this.url);
                    this.currentProxyCredentials = null;
                }
            }
            if (validateServer && this.currentServerCredentials != null) {
                string = this.responses.findValue("Authentication-Info");
                if (bl || string != null) {
                    this.currentServerCredentials.checkResponse(string, this.method, this.url);
                    this.currentServerCredentials = null;
                }
            }
            if (this.currentServerCredentials == null && this.currentProxyCredentials == null) {
                this.needToCheck = false;
            }
        }
        catch (IOException iOException) {
            this.disconnectInternal();
            this.connected = false;
            throw iOException;
        }
    }

    private boolean followRedirect() throws IOException {
        URL uRL;
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int n = this.getResponseCode();
        if (n < 300 || n > 307 || n == 306 || n == 304) {
            return false;
        }
        String string = this.getHeaderField("Location");
        if (string == null) {
            return false;
        }
        try {
            uRL = new URL(string);
            if (!this.url.getProtocol().equalsIgnoreCase(uRL.getProtocol())) {
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL(this.url, string);
        }
        this.disconnectInternal();
        this.responses = new MessageHeader();
        if (n == 305) {
            this.setProxiedClient(this.url, uRL.getHost(), uRL.getPort());
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.connected = true;
        } else {
            this.url = uRL;
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect") && n != 307) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                if (!this.checkReuseConnection()) {
                    this.connect();
                }
            } else {
                if (!this.checkReuseConnection()) {
                    this.connect();
                }
                this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
                this.requests.set("Host", this.url.getHost() + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    private void reset() throws IOException {
        InputStream inputStream;
        block10: {
            this.http.reuse = true;
            this.reuseClient = this.http;
            inputStream = this.http.getInputStream();
            try {
                if (inputStream instanceof ChunkedInputStream || inputStream instanceof MeteredStream) {
                    while (inputStream.read(this.cdata) > 0) {
                    }
                    break block10;
                }
                int n = 0;
                int n2 = 0;
                try {
                    n = Integer.parseInt(this.responses.findValue("Content-Length"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int i = 0; i < n && (n2 = inputStream.read(this.cdata)) != -1; i += n2) {
                }
            }
            catch (IOException iOException) {
                this.http.reuse = false;
                this.reuseClient = null;
                this.disconnectInternal();
                return;
            }
        }
        try {
            if (inputStream instanceof MeteredStream) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.responseCode = -1;
        this.responses = new MessageHeader();
        this.connected = false;
    }

    private void disconnectInternal() {
        this.responseCode = -1;
        if (this.pe != null) {
            ProgressData.pdata.unregister(this.pe);
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.pe != null) {
            ProgressData.pdata.unregister(this.pe);
        }
        if (this.http != null) {
            if (this.inputStream != null) {
                HttpClient httpClient = this.http;
                boolean bl = httpClient.isKeepingAlive();
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (bl) {
                    httpClient.closeIdleConnection();
                }
            } else {
                this.http.closeServer();
            }
            this.http = null;
            this.connected = false;
        }
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.getProxyHostUsed() != null;
        }
        return false;
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.findValue(string);
    }

    public Map getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getHeaders();
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getValue(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getKey(n);
    }

    public void setRequestProperty(String string, String string2) {
        super.setRequestProperty(string, string2);
        this.checkMessageHeader(string, string2);
        this.requests.set(string, string2);
    }

    public void addRequestProperty(String string, String string2) {
        super.addRequestProperty(string, string2);
        this.checkMessageHeader(string, string2);
        this.requests.add(string, string2);
    }

    void setAuthenticationProperty(String string, String string2) {
        this.checkMessageHeader(string, string2);
        this.requests.set(string, string2);
    }

    public String getRequestProperty(String string) {
        if (string != null) {
            for (int i = 0; i < EXCLUDE_HEADERS.length; ++i) {
                if (!string.equalsIgnoreCase(EXCLUDE_HEADERS[i])) continue;
                return null;
            }
        }
        return this.requests.findValue(string);
    }

    public Map getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return this.requests.getHeaders(EXCLUDE_HEADERS);
    }

    public void finalize() {
    }

    String getMethod() {
        return this.method;
    }

    static {
        maxRedirects = (Integer)AccessController.doPrivileged(new GetIntegerAction("http.maxRedirects", 20));
        version = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.agent"));
        string = string == null ? "Java/" + version : string + " Java/" + version;
        userAgent = string;
        validateProxy = (Boolean)AccessController.doPrivileged(new GetBooleanAction("http.auth.digest.validateProxy"));
        validateServer = (Boolean)AccessController.doPrivileged(new GetBooleanAction("http.auth.digest.validateServer"));
        EXCLUDE_HEADERS = new String[]{"Proxy-Authorization", "Authorization"};
    }

    class HttpInputStream
    extends FilterInputStream {
        public HttpInputStream(InputStream inputStream) {
            super(inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
                Object var2_1 = null;
                HttpURLConnection.this.http = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                HttpURLConnection.this.http = null;
                HttpURLConnection.this.checkResponseCredentials(true);
                throw throwable;
            }
            HttpURLConnection.this.checkResponseCredentials(true);
        }
    }
}

