/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.kml;

import org.boehn.kmlframework.kml.AltitudeModeEnum;
import org.boehn.kmlframework.kml.Geometry;
import org.boehn.kmlframework.kml.Kml;
import org.boehn.kmlframework.kml.KmlException;

public class Point
extends Geometry {
    private Boolean extrude;
    private AltitudeModeEnum altitudeMode;
    private Double longitude;
    private Double latitude;
    private Double altitude;

    public Point() {
    }

    public Point(Double longitude, Double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public Point(Double longitude, Double latitude, Double altitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    public Point(Boolean extrude, AltitudeModeEnum altitudeMode, Double longitude, Double latitude, Double altitude) {
        this.extrude = extrude;
        this.altitudeMode = altitudeMode;
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    public Boolean getExtrude() {
        return this.extrude;
    }

    public void setExtrude(Boolean extrude) {
        this.extrude = extrude;
    }

    public AltitudeModeEnum getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(AltitudeModeEnum altitudeMode) {
        this.altitudeMode = altitudeMode;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(Double altitude) {
        this.altitude = altitude;
    }

    public void write(Kml kml) throws KmlException {
        kml.println("<Point" + this.getIdAndTargetIdFormatted(kml) + ">", 1);
        if (this.extrude != null) {
            kml.println("<extrude>" + Point.booleanToInt(this.extrude) + "</extrude>");
        }
        if (this.altitudeMode != null) {
            kml.println("<altitudeMode>" + (Object)((Object)this.altitudeMode) + "</altitudeMode>");
        }
        if (this.longitude != null && this.latitude != null) {
            kml.println("<coordinates>" + this.getLongitudeLatitudeAltitudeString() + "</coordinates>");
        }
        kml.println(-1, "</Point>");
    }

    public void writeDelete(Kml kml) throws KmlException {
        kml.println("<Point" + this.getIdAndTargetIdFormatted(kml) + "></>");
    }

    public String getLongitudeLatitudeAltitudeString() {
        return this.longitude + "," + this.latitude + (this.altitude != null ? "," + this.altitude : "");
    }
}

