/*
 * $Id: NestedRootTag.java 54929 2004-10-16 16:38:42Z germuska $ 
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.struts.taglib.nested;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.apache.struts.taglib.TagUtils;

/**
 * NestedRootTag.
 *
 * The only other addition in this nested suite of tags.
 * This tag allows for a nested structure to start without relying on the bean
 * and workings of the FormTag. Useful for view pages that don't update when
 * returning to the server, or use hyperlinks rather than form submits.
 *
 * The Bean that it uses can come out of a jsp:useBean tag or define another
 * bean that's already in scope. As long as the other Struts tags can find the
 * bean by name, it'll work.
 *
 * It's simply recognised by the helper class and it's property is added to the
 * nesting list.
 *
 * @since Struts 1.1
 * @version $Rev: 54929 $ $Date: 2004-10-16 17:38:42 +0100 (Sat, 16 Oct 2004) $
 */
public class NestedRootTag extends BodyTagSupport implements NestedNameSupport {

  /** Getter method for the <i>property</i> property
   * @return String value of the property property
   */
  public String getProperty() {
    return "";
  }
  /** Setter method for the <i>property</i> property
   * @param property new value for the property property
   */
  public void setProperty(String property) {}

  /** Getter method for the <i>name</i> property
   * @return String value of the name property
   */
  public String getName() {
    return this.name;
  }
  /** Setter method for the <i>name</i> property
   * @param name new value for the name property
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Overriding method of the heart of the tag. Gets the relative property
   * and tells the JSP engine to evaluate its body content.
   *
   * @return int JSP continuation directive.
   */
  public int doStartTag() throws JspException {
    /* set the nested reference for possible inclusions etc */
    HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();

    // get al the originals
    originalName = name;
    originalNesting = NestedPropertyHelper.getCurrentProperty(request);
    originalNestingName = NestedPropertyHelper.getCurrentName(request, this);

    // set what we have to
    if (name != null) {
      NestedPropertyHelper.setProperty(request, "");
      NestedPropertyHelper.setName(request, this.name);
    }

    // do the JSP thing
    return (EVAL_BODY_TAG);
  }

  /**
   * Render the resulting content evaluation.
   *
   * @return int JSP continuation directive.
   */
  public int doAfterBody() throws JspException {
    /* Render the output */
    if (bodyContent != null) {
      TagUtils.getInstance().writePrevious(pageContext, bodyContent.getString());
      bodyContent.clearBody();
    }

    return (SKIP_BODY);
  }

  /**
   * Evaluate the rest of the page
   *
   * @return int JSP continuation directive.
   */
  public int doEndTag() throws JspException {
    /* reset the reference */
    HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();

    if (originalNesting == null) {
      NestedPropertyHelper.deleteReference(request);
    } else {
      NestedPropertyHelper.setName(request, originalNestingName);
      NestedPropertyHelper.setProperty(request, originalNesting);
    }
    this.name = originalName;

    return (EVAL_PAGE);
  }


  /**
   * JSP method to release all resources held by the tag.
   */
  public void release() {
    super.release();
    this.name = null;
    this.originalName = null;
    this.originalNesting = null;
    this.originalNestingName = null;
  }

  /* usual member variables */
  private String name = null;
  private String originalName = "";
  private String originalNesting = "";
  private String originalNestingName = "";
}
