## Usage

```js
const cloneDeep = require('{%= name %}');

let obj = { a: 'b' };
let arr = [obj];
let copy = cloneDeep(arr);
obj.c = 'd';

console.log(copy);
//=> [{ a: 'b' }]

console.log(arr);
//=> [{ a: 'b', c: 'd' }]
```

## Heads up!

The last argument specifies whether or not to clone instances (objects that are from a custom class or are not created by the `Object` constructor. This value may be `true` or the function use for cloning instances.

When an `instanceClone` function is provided, it will be invoked to clone objects that are not "plain" objects (as defined by [`isPlainObject`](#isPlainObject)). If `instanceClone` is not specified, this library will not attempt to clone non-plain objects, and will simply copy the object reference.

## Attribution

Initially based on [mout's](https://github.com/mout/mout) implementation of deepClone.
