<?php
/**
*
* common [Croatian]
*
* @package language
* @version $Id$
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'phpbb.com.hr',
	'DIRECTION'	 => 'ltr',
	'DATE_FORMAT'	=> '|d. m. Y.|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'	 => 'hr',

	'1_DAY'			=> '1 dan',
	'1_MONTH'		=> '1 mjesec',
	'1_YEAR'		=> '1 godina',
	'2_WEEKS'		=> '2 tjedna',
	'3_MONTHS'		=> '3 mjeseci',
	'6_MONTHS'		=> '6 mjeseci',
	'7_DAYS'		=> '7 dana',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Vaš korisnički račun je već aktivan.',
	'ACCOUNT_DEACTIVATED'			=> 'Korisnički račun je deaktiviran, aktivirati ga može samo netko sa ovlastima, npr. administrator ovog foruma.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Vaš korisnički račun nije još aktivan.',
	'ACP'							=> 'Kontrol Panel Administracije',
	'ACTIVE'						=> 'aktivan|na',
	'ACTIVE_ERROR'					=> 'Navedeno korisničko ime je trenutno neaktivno. Ako imate problema sa aktiviranjem korisničkog računa, obratite se administratoru foruma.',
	'ADMINISTRATOR'					=> 'Administrator',
	'ADMINISTRATORS'				=> 'Administratori',
	'AGE'							=> 'Starost',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Dozvoljeno',
	'ALL_FILES'						=> 'Sve datoteke',
	'ALL_FORUMS'					=> 'Sve forumi',
	'ALL_MESSAGES'					=> 'Sve poruke',
	'ALL_POSTS'						=> 'Svi postovi',
	'ALL_TIMES'						=> 'Vrijeme na %1$s %2$s',
	'ALL_TOPICS'					=> 'Sve teme',
	'AND'							=> 'i',
	'ARE_WATCHING_FORUM'			=> 'Pretplaćeni ste na ovaj forum.',
	'ARE_WATCHING_TOPIC'			=> 'Pretplaćeni ste na ovu temu.',
	'ASCENDING'						=> 'Uzlazno A-Ž',
	'ATTACHMENTS'					=> 'Prilog',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Slika ili privitak koju pokušavate staviti ima grešku.',
	'AUTHOR'						=> 'Autor',
	'AUTH_NO_PROFILE_CREATED'		=> 'Neuspjelo stvaranje korisničkog računa.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Učitanje je prekinuto jer je datoteka prepoznata kao potencijalno opasna.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Ova datoteka ne može biti prikazana jer je ekstenzija <strong>%s</strong> nedozvoljena na ovom forumu. Smatrate li da je to greška kontaktirajte administratora foruma',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Avatar ne može biti učitan jer sadrži grešku ili kao takav nije dozvoljen na forumu.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Avatar je prazan. Pokušajte drugi ili ponovite ako smatrate da je u redu.',
	'AVATAR_INVALID_FILENAME'		=> '%s je nedozvoljen naziv.',
	'AVATAR_NOT_UPLOADED'			=> 'Avatar nije učitan.',
	'AVATAR_NO_SIZE'				=> 'Širinu ili visinu ili oboje nije moguće utvrditi pokušajte ih unjeti ručno.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Navedena datoteka je samo djelomično učitana.',
	'AVATAR_PHP_SIZE_NA'			=> 'Veličina avatara je prevelika.<br />Najveća veličina nije mogla biti određena.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Težina avatara je prevelika. Najveća dozvoljena težina je %1$d %2$s.<br />Molimo imajte na umu da je ovo postavljeno unutar php.ini i ne može biti zanemareno kao takvo.',
	'AVATAR_URL_INVALID'			=> 'URL koji ste naveli nije ispravan.',
	'AVATAR_URL_NOT_FOUND'			=> 'Navedena datoteka nije pronađena.',
	'AVATAR_WRONG_FILESIZE'			=> 'Avatar mora biti između 0 i %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'Dozvoljene veličina avatara je %5$d piksela širine i %6$d piksela visine. Avatari moraju biti najmanje %1$d piksela široki i %2$d piksela visine, ali ne više od %3$d piksela širine i %4$d piksela visine.',

	'BACK_TO_TOP'			=> 'Vrh',
	'BACK_TO_PREV'			=> 'Povratak na prethodnu stranu',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Ova e-mail adresa je pod zabranom na forumu. Obratite se administratoru foruma.',
	'BAN_TRIGGERED_BY_IP'	=> 'Ova IP adresa je pod zabranom na ovom forumu. Obratite se administratoru foruma.',
	'BAN_TRIGGERED_BY_USER'	=> 'Korisničko ime je pod zabranom. Obratite se administratoru foruma.',
	'BBCODE_GUIDE'			=> 'BBC kod vodič',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'Rođendan',
	'BOARD_BAN_PERM'		=> 'Vi ste <strong>trajno</strong> bannirani na ovom forumu.<br /><br />Kontaktirajte  %2$sforum administratora%3$s za više informacija.',
	'BOARD_BAN_REASON'		=> 'Razlog banniranja: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Imate zabranu logiranja na forum do <strong>%1$s</strong>.<br /><br />Imate li nejasnoća oko toga kontaktirajte %2$sforum administratora%3$s za više detalja.',
	'BOARD_DISABLE'			=> 'Oprostite ovaj forum trenutno nije dostupan.',
	'BOARD_DISABLED'		=> 'Forum trenutno nije dostupan.',
	'BOARD_UNAVAILABLE'		=> 'Oprostite ovaj forum privremeno nije dostupan, pokušajte ponovo nakon nekog vremena.',
	'BROWSING_FORUM'		=> '%1$s pregledava forum',
	'BROWSING_FORUM_GUEST'	=> '%1$s pregledava forum i %2$d gost',
	'BROWSING_FORUM_GUESTS'	=> '%1$s pregledava forum i %2$d gostiju',
	'BYTES'					=> 'Bytes',

	'CANCEL'				=> 'Odustani',
	'CHANGE'				=> 'Promjeni',
	'CHANGE_FONT_SIZE'		=> 'Promjeni veličinu slova',
	'CHANGING_PREFERENCES'	=> 'Promjena forum dozvola',
	'CHANGING_PROFILE'		=> 'Promjena postavki profila',
	'CLICK_VIEW_PRIVMSG'	=> '%sIdi u svoj sandučić%s',
	'COLLAPSE_VIEW'			=> 'Sažmi pogled',
	'CLOSE_WINDOW'			=> 'Zatvori prozor',
	'COLOUR_SWATCH'			=> 'Uzorak boje',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Potvrdi',
	'CONFIRM_CODE'			=> 'Potvrdni kod',
	'CONFIRM_CODE_EXPLAIN'	=> 'Unesite kod točno onako kako se on pojavljuje. Obrati pažnju na velika i mala slova.',
	'CONFIRM_CODE_WRONG'	=> 'Unjeli ste pogrešan kod.',
	'CONFIRM_OPERATION'		=> 'Jeste li sigurni da želite nastaviti ovaj postupak?',
	'CONGRATULATIONS'		=> 'Čestitamo',
	'CONNECTION_FAILED'		=> 'Greška u konekciji.',
	'CONNECTION_SUCCESS'	=> 'Konekcija je uspjela!',
	'COOKIES_DELETED'		=> 'Svi su kolačići uspješno obrisani.',
	'CURRENT_TIME'			=> 'Sada je %s',

	'DAY'					=> 'Dan',
	'DAYS'					=> 'Dana',
	'DELETE'				=> 'Obriši',
	'DELETE_ALL'			=> 'Obriši sve',
	'DELETE_COOKIES'		=> 'Obriši sve forum kolačiće',
	'DELETE_MARKED'			=> 'Obriši obilježeno',
	'DELETE_POST'			=> 'Obriši post',
	'DELIMITER'				=> 'Razdjeljnik',
	'DESCENDING'			=> 'Silazno Ž-A',
	'DISABLED'				=> 'Onemogućeno',
	'DISPLAY'				=> 'Prikaz',
	'DISPLAY_GUESTS'		=> 'Prikaži goste',
	'DISPLAY_MESSAGES'		=> 'Prikaz prethodnih poruka',
	'DISPLAY_POSTS'			=> 'Prikaz prethodnih postova',
	'DISPLAY_TOPICS'		=> 'Prikaz prethodnih tema',
	'DOWNLOADED'			=> 'Preuzimanje',
	'DOWNLOADING_FILE'		=> 'Preuzimanje datoteka',
	'DOWNLOAD_COUNT'		=> 'Preuzeto %d put',
	'DOWNLOAD_COUNTS'		=> 'Downloaded %d puta',
	'DOWNLOAD_COUNT_NONE'	=> 'Još nije preuzimano',
	'VIEWED_COUNT'			=> 'Pogledano %d put',
	'VIEWED_COUNTS'			=> 'Pogledano %d puta',
	'VIEWED_COUNT_NONE'		=> 'Nije još pogledano',

	'EDIT_POST'							=> 'Uredi post',
	'EMAIL'								=> 'E-mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'E-mail adresa',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Problem kod slanja emaila na <strong>Line %1$s</strong>. Odziv: %2$s.',
	'EMPTY_SUBJECT'						=> 'Kod pokretanja teme morate upisati naslov.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Kod pisanja poruke morate upisati naslov.',
	'ENABLED'							=> 'Omogućeno',
	'ENCLOSURE'							=> 'Prilog',
	'ENTER_USERNAME'					=> 'Unesite korisničko ime',
	'ERR_CHANGING_DIRECTORY'			=> 'Mapu nije moguće promijeniti.',
	'ERR_CONNECTING_SERVER'				=> 'Došlo je do pogreške prilikom povezivanja sa serverom.',
	'ERR_JAB_AUTH'						=> 'Neuspjela autorizacija na Jabber server.',
	'ERR_JAB_CONNECT'					=> 'Neuspjelo spajanje na Jabber server.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Greška prilikom prijavljivanja. Uneseno je netočno korisničko ime i/ili lozinka.',
	'ERR_UNWATCHING'					=> 'Došlo je do greške prilikom odkazivanja pretplate.',
	'ERR_WATCHING'						=> 'Greška prilikom pokušaja uspostave pretplate.',
	'ERR_WRONG_PATH_TO_PHPBB'	=> 'phpBB putanja je neispravna.',
	'EXPAND_VIEW'	=> 'Proširi prikaz',
	'EXTENSION'	=> 'Ekstenzija',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Ekstenzija <strong>%s</strong> je deaktivirana i više ne može biti prikazana.',

	'FAQ'	=> 'FAQ',
	'FAQ_EXPLAIN'	=> 'Često postavljena pitanja',
	'FILENAME'	=> 'Naziv datoteke',
	'FILESIZE'	=> 'Veličina datoteke',
	'FILEDATE'	=> 'Datum',
	'FILE_COMMENT'	=> 'Opaska',
	'FILE_NOT_FOUND'	=> 'Zatražena datoteka nije pronađena.',
	'FIND_USERNAME'	=> 'Pronađi korisničko ime',
	'FOLDER'	=> 'Mapa',
	'FORGOT_PASS'	=> 'Zaboravio sam lozinku',
	'FORM_INVALID'	=> 'Poslana forma je neispravna.<br />Pokušaj poslati ponovo.',
	'FORUM'	=> 'Forum',
	'FORUMS'	=> 'Forumi',
	'FORUMS_MARKED'	=> 'Forumi su označeni kao pročitani.',
	'FORUM_CAT'	=> 'Kategorija',
	'FORUM_INDEX'	=> 'Početna',
	'FORUM_LINK'	=> 'Link foruma',
	'FORUM_LOCATION'	=> 'Lokacija foruma',
	'FORUM_LOCKED'	=> 'Forum je zaključan',
	'FORUM_RULES'	=> 'Pravila foruma',
	'FORUM_RULES_LINK'	=> 'Pravila foruma',
	'FROM'	=> 'od',
	'FSOCK_DISABLED'	=> 'Funkcija <var>fsockopen</var> je onemoguća odnosno nije moguće povezati se za serverom poradi čega operaciju nije moguće izvršiti.',
	'FSOCK_TIMEOUT'	=> 'Prilikom čitanja mrežnog protoka došlo je do istjeka vremena.',

	'FTP_FSOCK_HOST'	=> 'FTP host',
	'FTP_FSOCK_HOST_EXPLAIN'	=> 'FTP server za spajanje na sajt.',
	'FTP_FSOCK_PASSWORD'	=> 'FTP lozinka',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Lozinka FTP korisničko imena.',
	'FTP_FSOCK_PORT'	=> 'FTP port',
	'FTP_FSOCK_PORT_EXPLAIN'	=> 'Port za spajanje na server.',
	'FTP_FSOCK_ROOT_PATH'	=> 'phpBB putanja',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Putanja do phpBB foruma u odnosu na root (direktorij).',
	'FTP_FSOCK_TIMEOUT'	=> 'FTP vremensko ograničenje',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'	=> 'Vremenski period, u sekundama, koliko će sustav čekati na odgovor od servera.',
	'FTP_FSOCK_USERNAME'	=> 'FTP korisničko ime',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Korisničko ime za spajanje na server.',

	'FTP_HOST'	=> 'FTP host',
	'FTP_HOST_EXPLAIN'	=> 'FTP server za spajanje na web.',
	'FTP_PASSWORD'	=> 'FTP lozinka',
	'FTP_PASSWORD_EXPLAIN'	=> 'Lozinka FTP korisničko imena.',
	'FTP_PORT'	=> 'FTP port',
	'FTP_PORT_EXPLAIN'	=> 'Port za spajanje na server.',
	'FTP_ROOT_PATH'	=> 'phpBB putanja',
	'FTP_ROOT_PATH_EXPLAIN'	=> 'Putanja do phpBB foruma u odnosu na root (direktorij).',
	'FTP_TIMEOUT'	=> 'FTP vremensko ograničenje',
	'FTP_TIMEOUT_EXPLAIN'	=> 'Vremenski period, u sekundama, koliko će sustav čekati na odgovor od servera.',
	'FTP_USERNAME'	=> 'FTP korisničko ime',
	'FTP_USERNAME_EXPLAIN'	=> 'Korisničko ime za spajanje na server.',

	'GENERAL_ERROR'				=> 'Generalna Greška',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Idi',
	'GOTO_PAGE'					=> 'Idi na stranu',
	'GROUP'						=> 'Grupa',
	'GROUPS'					=> 'Grupe',
	'GROUP_ERR_TYPE'			=> 'Pogrešno navedena korisnička grupa.',
	'GROUP_ERR_USERNAME'		=> 'Nije naveden naziv grupe.',
	'GROUP_ERR_USER_LONG'		=> 'Ime grupe ne može biti veće od 60 znakova. Unešen naziv je predugačak.',
	'GUEST'						=> 'Gost',
	'GUEST_USERS_ONLINE'		=> 'Imamo %d gostiju online',
	'GUEST_USERS_TOTAL'			=> '%d gostiju',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Imamo 0 gostiju online',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 gostiju',
	'GUEST_USER_ONLINE'			=> 'Imamo %d gostiju online',
	'GUEST_USER_TOTAL'			=> '%d gostiju',
	'G_ADMINISTRATORS'			=> 'Administrator',
	'G_BOTS'					=> 'Bots',
	'G_GUESTS'					=> 'Gostiju',
	'G_REGISTERED'				=> 'Registriranih korisnika',
	'G_REGISTERED_COPPA'		=> 'Registriranih COPPA korisnika',
	'G_GLOBAL_MODERATORS'		=> 'Globalni moderatori',
	'G_NEWLY_REGISTERED'		=> 'Novo registrirani korisnici',

	'HIDDEN_USERS_ONLINE'			=> '%d skrivenih korisnika online',
	'HIDDEN_USERS_TOTAL'			=> '%d skriveno',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d skriveno i ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> '0 skrivenih korisnika online',
	'HIDDEN_USERS_ZERO_TOTAL'		=> '0 skrivenih',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 skrivenih i ',
	'HIDDEN_USER_ONLINE'			=> '%d sakrivenih korisnika online',
	'HIDDEN_USER_TOTAL'				=> '%d sakriveno',
	'HIDDEN_USER_TOTAL_AND'			=> '%d sakriveni i ',
	'HIDE_GUESTS'					=> 'Sakrij goste',
	'HIDE_ME'						=> 'Sakrij moj online status',
	'HOURS'							=> 'Sati',
	'HOME'							=> 'Početna',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'ICQ status',
	'IF'						=> 'Ako',
	'IMAGE'						=> 'Slika',
	'IMAGE_FILETYPE_INVALID'	=> 'Ovaj tip slike %d kao vrsta %s nije podržana.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Neslaganje vrsta datoteke slike: očekivana ekstenzija %1$s, dana ekstenzija %2$s.',
	'IN'						=> 'u',
	'INDEX'						=> 'Početna',
	'INFORMATION'				=> 'Informacije',
	'INTERESTS'					=> 'Interesi',
	'INVALID_DIGEST_CHALLENGE'	=> 'Neispravan digest challenge.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> je najvjerojatnije netočna e-mail adresa(?).',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Vaš IP %1$s je blokiran i nalazi se na listi blokiranih. Za detalje pogledajte <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Pridružen',
	'JUMP_PAGE'				=> 'Unesite broj stranice na koju želite ići',
	'JUMP_TO'				=> 'Idi na',
	'JUMP_TO_PAGE'			=> 'Klikni za prijelaz na stranu …',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Zadnji post',
	'LAST_UPDATED'						=> 'Zadnja nadopuna',
	'LAST_VISIT'						=> 'Zadnja posjeta',
	'LDAP_NO_LDAP_EXTENSION'			=> 'LDAP ekstenzija nije dozvoljena.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Povezivanje sa LDAP serverom nije uspjelo.',
	'LDAP_SEARCH_FAILED'				=> 'Došlo je do pogreške tijekom pretraživanje LDAP direktorija.',
	'LEGEND'							=> 'Legenda',
	'LOCATION'							=> 'Lokacija',
	'LOCK_POST'							=> 'Zaključaj post',
	'LOCK_POST_EXPLAIN'					=> 'Prevent editing',
	'LOCK_TOPIC'						=> 'Zaključaj temu',
	'LOGIN'								=> 'Login',
	'LOGIN_CHECK_PM'					=> 'Logiraj se za provjeru privatnih poruka.',
	'LOGIN_CONFIRMATION'				=> 'Potvrda prijave',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Kako bi spriječili spam račune nakon određenog broja uzastopnih neuspjelih prijava trebate unjeti kod. Kod prikazan na slici trebali bi jasno vidjeti. Ukoliko ga ne vidite dobro ili ga ne vidite kontaktirajte forum %sAdministratora%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Vi ste premašili maksimalan broj dozvoljenih prijava. Osim korisničkog imena i lozinke sada morate unjeti i kod sa slike.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Niste potvrđeni od strane Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'Unjeli ste pogrešnu lozinku. Molimo Vas da provjerite svoju lozinku i pokušajte ponovno. Ako i dalje imate problema obratite se forum %sAdministratoru%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Konvertiranje tvoje lozinke prilikom ažuriranja softvera foruma nije uspjelo.<br />Zatraži novu lozinku.<br />Ukoliko ćeš i dalje imati problema sa korištenjem ovog foruma - kontaktiraj %sadministratora foruma%s.',
	'LOGIN_ERROR_USERNAME'	=> 'Unešeno je neaktivno korisničko ime.<br />Provjeri unos i pokušaj ponovo.<br />Ako ti  ne uspije - kontaktiraj %sadministratora foruma%s.',
	'LOGIN_FORUM'	=> 'Za sudjelovanje u raspravama na forumu, moraš unijeti korisničko ime i lozinku pa se prijaviti.',
	'LOGIN_INFO'	=> 'Da bi se prijavio treba se registrirati.<br />Registracijom koja traje nekoliko trenutaka dobivaš mogućnosti na forumu koje primjerice neregistrirane osobe nemaju.<br />Prije registriranja ili prijavljivanja molim prouči Uvjete korištenja te pisana Pravila koja vrijede na ovom forumu.',
	'LOGIN_VIEWFORUM'	=> 'Za pregledavanje ovog foruma moraš se prijaviti.',
	'LOGIN_EXPLAIN_EDIT'	=> 'Za uređivanje postova na forumu moraš biti prijavljen.',
	'LOGIN_EXPLAIN_VIEWONLINE'	=> 'Za pregledavanje online liste moraš biti prijavljen.',
	'LOGOUT'							=> 'Odjava',
	'LOGOUT_USER'						=> 'Odjava [ %s ]',
	'LOG_ME_IN'							=> 'Prijavi me automatski kod posjete forumu',

	'MARK'					=> 'Označi',
	'MARK_ALL'				=> 'Označi sve',
	'MARK_FORUMS_READ'		=> 'Označi forume pročitanima',
	'MARK_SUBFORUMS_READ'	=> 'Označi podforume pročitanima',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Moderatorski Kontrol Panel',
	'MEMBERLIST'			=> 'Korisnici',
	'MEMBERLIST_EXPLAIN'	=> 'Pogledaj kompletnu litu korisnika',
	'MERGE'					=> 'Spoji',
	'MERGE_POSTS'			=> 'Premjesti postove',
	'MERGE_TOPIC'			=> 'Spoji temu',
	'MESSAGE'				=> 'Poruka',
	'MESSAGES'				=> 'Poruke',
	'MESSAGE_BODY'			=> 'Tijelo poruke',
	'MINUTES'				=> 'Minute',
	'MODERATE'				=> 'Moderiranje',
	'MODERATOR'				=> 'Moderator',
	'MODERATORS'			=> 'Moderatori',
	'MONTH'					=> 'Mjesec',
	'MOVE'					=> 'Premjesti',
	'MSNM'					=> 'MSNM/WLM',

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'Naš najnoviji član <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Nova poruka',
	'NEW_MESSAGES'				=> 'Nove poruke',
	'NEW_PM'					=> '<strong>%d</strong> nova poruka',
	'NEW_PMS'					=> '<strong>%d</strong> nove poruke',
	'NEW_POST'					=> 'Novi post',	// Not used anymore
	'NEW_POSTS'					=> 'Novi post',	// Not used anymore
	'NEXT'						=> 'Sljedeće',		// Used in pagination
	'NEXT_STEP'					=> 'Sljedeće',
	'NEVER'						=> 'Nikad',
	'NO'						=> 'Ne',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Nemate dopuštenje za uređivanje ove grupe.',
	'NOT_AUTHORISED'	=> 'Za pregledavanje ovog dijela foruma foruma morate biti ovlašteni.',
	'NOT_WATCHING_FORUM'	=> 'Više nisi pretplaćen na forum.',
	'NOT_WATCHING_TOPIC'	=> 'Više nisi pretplaćen na temu.',
	'NOTIFY_ADMIN'	=> 'Molim obavijesti administratora foruma.',
	'NOTIFY_ADMIN_EMAIL'	=> 'Molim obavijesti administratora: <a href="mailto:%1$s">%1$s</a>.',
	'NO_ACCESS_ATTACHMENT'	=> 'Za pristupanje ovoj datoteci moraš biti ovlašten.',
	'NO_ACTION'	=> 'Nije određena radnja.',
	'NO_ADMINISTRATORS'	=> 'Nema administratora.',
	'NO_AUTH_ADMIN'	=> 'S obzirom da nemaš administratorske ovlasti na ovom forumu ne možeš pristupiti <em>Administriranju foruma</em>.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Ne možeš se reautentizirati kao drugi korisnik foruma.',
	'NO_AUTH_OPERATION'	=> 'Za izvršenje ove radnje nemaš zadana dopuštenja.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Povezivanje sa smtp hostom : %s : %s nije uspjelo.',
	'NO_BIRTHDAYS'	=> 'Danas nitko nema rođendan.',
	'NO_EMAIL_MESSAGE'	=> 'E-mail poruka je prazna.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Dobivanje odgovora od mail servera nije uspjelo.',
	'NO_EMAIL_SUBJECT'	=> 'Naslov e-maila nije upisan.',
	'NO_FORUM'	=> 'Odabran forum ne postoji.',
	'NO_FORUMS'	=> 'Nema otvorenih foruma',
	'NO_GROUP'	=> 'Grupa ne postoji.',
	'NO_GROUP_MEMBERS'	=> 'Grupa nema članova.',
	'NO_IPS_DEFINED'	=> 'Hostname / IP adresa nije definirana.',
	'NO_MEMBERS'	=> 'Ništa nije pronađeno.',
	'NO_MESSAGES'	=> '/',
	'NO_MODE'	=> 'Nije određen mod.',
	'NO_MODERATORS'	=> 'Nema moderatora.',
	'NO_NEW_MESSAGES'	=> 'Nema novih poruka',
	'NO_NEW_PM'	=> '<strong>0</strong> novih poruka',
	'NO_NEW_POSTS'	=> 'Nema novih postova',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'Nema registriranih korisnika',
	'NO_POSTS'					=> 'Nema postova',
	'NO_POSTS_TIME_FRAME'	=> 'U temi u zadanom vremenskom razdoblju nema postova.',
	'NO_FEED_ENABLED'	=> 'Feed je nedostupan na ovom forumu.',
	'NO_FEED'	=> 'Traženi feed je nedostupan.',
	'NO_SUBJECT'	=> 'Moraš unijeti naslov.',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'	=> 'Specificiran modul pretraživanja na forumu ne postoji.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Nema podržanih metoda provjera autentičnosti.',
	'NO_TOPIC'	=> 'Tema ne postoji.',
	'NO_TOPIC_FORUM'	=> 'Tema-forum ne postoji.',
	'NO_TOPICS'	=> 'Na forumu nema tema/postova.',
	'NO_TOPICS_TIME_FRAME'	=> 'Na forumu u zadanom vremenskom razdoblju nema tema.',
	'NO_UNREAD_PM'	=> '<strong>0</strong> nepročitanih poruka',
	'NO_UNREAD_POSTS' => 'Nema nepročitanih postova',
	'NO_UPLOAD_FORM_FOUND'	=> 'Uploadiranje je inicirano ali nije pronađena ispravna forma uploadiranja datoteka.',
	'NO_USER'	=> 'Korisničko ime na forumu ne postoji.',
	'NO_USERS'	=> 'Korisnička imena na forumu ne postoje.',
	'NO_USER_SPECIFIED'	=> 'Korisničko ime nije specificirano.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Nema postova na čekanju',		// 0
		1			=> '1 post na čekanju',		// 1
		2			=> '%d postova na čekanju',		// 2+
	),

	'OCCUPATION'				=> 'Zanimanje',
	'OFFLINE'					=> 'Odsutan',
	'ONLINE'					=> 'Prisutan',
	'ONLINE_BUDDIES'			=> 'Prijatelji',
	'ONLINE_USERS_TOTAL'	=> 'Ukupno je: <strong>%d</strong> korisnika prisutno; ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Ukupno je: <strong>0</strong> korisnika prisutno; ',
	'ONLINE_USER_TOTAL'	=> 'Ukupno je: <strong>%d</strong> korisnika prisutno; ',
	'OPTIONS'	=> 'Opcije',

	'PAGE_OF'				=> 'Strana <strong>%1$d</strong> od <strong>%2$d</strong>',
	'PASSWORD'				=> 'Lozinka',
	'PIXEL'					=> 'px',
	'PLAY_QUICKTIME_FILE'	=> 'Pokreni Quicktime datoteku',
	'PM'					=> 'PM',
	'PM_REPORTED'			=> 'Klikni i pogledaj izvješće',
	'POSTING_MESSAGE'		=> 'Posta poruku u %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Piše privatnu poruku',
	'POST'					=> 'Post',
	'POST_ANNOUNCEMENT'		=> 'Obavjest',
	'POST_STICKY'			=> 'Važno',
	'POSTED'				=> 'Postano',
	'POSTED_IN_FORUM'		=> 'u',
	'POSTED_ON_DATE'		=> 'dana',
	'POSTS'					=> 'Postovi',
	'POSTS_UNAPPROVED'	=> 'Najmanje jedan post u ovoj temi nije odobren.',
	'POST_BY_AUTHOR'	=> 'Postao/la',
	'POST_BY_FOE'	=> 'Ovaj post je postao <strong>%1$s</strong>, korisnik koji je na tvojoj Listi ignoriranih korisnika ukoliko želiš pročitati post klikni %2$sovdje%3$s.',
	'POST_DAY'	=> '%.2f posta dnevno',
	'POST_DETAILS'	=> 'Detalji o postu',
	'POST_NEW_TOPIC'	=> 'Započni novu temu',
	'POST_PCT'	=> '%.2f%% od svih postova',
	'POST_PCT_ACTIVE'	=> '%.2f%% od postova korisnika',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% od tvojih postova',
	'POST_REPLY'	=> 'Odgovori',
	'POST_REPORTED'	=> 'Pročitaj prijavu',
	'POST_SUBJECT'	=> 'Naslov',
	'POST_TIME'	=> 'Vrijeme posta',
	'POST_TOPIC'	=> 'Započni novu temu',
	'POST_UNAPPROVED'	=> 'Post čeka odobrenje.',
    'POWERED_BY'			=> 'Pokreće %s',
	'PREVIEW'	=> 'Prikaz',
	'PREVIOUS'				=> 'Prethodni',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Prethodni',
	'PRIVACY'				=> 'Pravila privatnosti',
	'PRIVATE_MESSAGE'	=> 'Pošalji privatnu poruku',
	'PRIVATE_MESSAGES'	=> 'Privatne poruke',
	'PRIVATE_MESSAGING'	=> 'Privatne poruke',
	'PROFILE'	=> 'Profil',

	'RANK'  => 'Rang',
	'READING_FORUM'	=> 'Pregledava teme u %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Čita Globalnu obavijest',
	'READING_LINK'	=> 'Slijedi link %s',
	'READING_TOPIC'	=> 'Čita teme u %s',
	'READ_PROFILE'	=> 'Profil',
	'REASON'	=> 'Razlog',
	'RECORD_ONLINE_USERS'	=> 'Najviše korisnika istovremeno na forumu bilo je: <strong>%1$s</strong>, dana %2$s.',
	'REDIRECT'	=> 'Preusmjeravanje',
	'REDIRECTS'	=> 'Preusmjereno puta',
	'REGISTER'	=> 'Registracija',
	'REGISTERED_USERS'	=> 'Registriranih korisnika:',
	'REG_USERS_ONLINE'	=> 'Ukupno je: %d registriranih korisnika i ',
	'REG_USERS_TOTAL'	=> '%d registriranih, ',
	'REG_USERS_TOTAL_AND'	=> '%d registriranih i ',
	'REG_USERS_ZERO_ONLINE'	=> 'Ukupno je: 0 registriranih korisnika i ',
	'REG_USERS_ZERO_TOTAL'	=> '0 registriranih, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 registriranih i ',
	'REG_USER_ONLINE'	=> 'Ukupno je: %d registrirani korisnik/ca i ',
	'REG_USER_TOTAL'	=> '%d registriran, ',
	'REG_USER_TOTAL_AND'	=> '%d registriran i ',
	'REMOVE'	=> 'Izbriši',
	'REMOVE_INSTALL'	=> 'Izbriši premjesti ili preimenuj mapu install.<br />Ukoliko ne izbrišeš mapu samo će <em>Administriranje foruma [AF]</em> biti dostupno.',
	'REPLIES'	=> 'Odgovori',
	'REPLY_WITH_QUOTE'	=> 'Citiraj',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Odgovara na Globalnu obavijest',
	'REPLYING_MESSAGE'	=> 'Odgovara na poruku u %s',
	'REPORT_BY'	=> 'Prijavio',
	'REPORT_POST'	=> 'Prijavi post',
	'REPORTING_POST'	=> 'Prijavljuje post',
	'RESEND_ACTIVATION'	=> 'Pošalji ponovo aktivacijski e-mail',
	'RESET'	=> 'Poništi',
	'RESTORE_PERMISSIONS'	=> 'Postavi dopuštenja na zadane vrijednosti',
	'RETURN_INDEX'				=> '%sVrati se na početnu%s',
	'RETURN_FORUM'				=> '%sVrati se na zadnje posjećenu%s',
	'RETURN_PAGE'				=> '%sVrati se na prethodnu%s',
	'RETURN_TOPIC'				=> '%sVrati se na zadnje pročitan post%s',
	'RETURN_TO'					=> 'Vrati se na:',
	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'Novosti',
	'FEED_TOPICS_ACTIVE'	=> 'Aktivne teme',
	'FEED_TOPICS_NEW'	=> 'Nove teme',
	'RULES_ATTACH_CAN'	=> '<strong>Možeš</strong> postati privitke.',
	'RULES_ATTACH_CANNOT'	=> '<strong>Ne možeš</strong> postati privitke.',
	'RULES_DELETE_CAN'	=> '<strong>Možeš</strong> izbrisati svoje postove.',
	'RULES_DELETE_CANNOT'	=> '<strong>Ne možeš</strong> izbrisati svoje postove.',
	'RULES_DOWNLOAD_CAN'	=> '<strong>Možeš</strong> preuzimati privitke.',
	'RULES_DOWNLOAD_CANNOT'	=> '<strong>Ne možeš</strong> preuzimati privitke.',
	'RULES_EDIT_CAN'	=> '<strong>Možeš</strong> uređivati svoje postove.',
	'RULES_EDIT_CANNOT'	=> '<strong>Ne možeš</strong> uređivati svoje postove.',
	'RULES_LOCK_CAN'	=> '<strong>Možeš</strong> zaključavati svoje teme.',
	'RULES_LOCK_CANNOT'	=> '<strong>Ne možeš</strong> zaključavati svoje teme.',
	'RULES_POST_CAN'	=> '<strong>Možeš</strong> započinjati nove teme.',
	'RULES_POST_CANNOT'	=> '<strong>Ne možeš</strong> započinjati nove teme.',
	'RULES_REPLY_CAN'	=> '<strong>Možeš</strong> odgovarati na postove.',
	'RULES_REPLY_CANNOT'	=> '<strong>Ne možeš</strong> odgovarati na postove.',
	'RULES_VOTE_CAN'	=> '<strong>Možeš</strong> glasovati u anketama.',
	'RULES_VOTE_CANNOT'	=> '<strong>Ne možeš</strong> glasovati u anketama.',

	'SEARCH'					=> 'Traži',
	'SEARCH_MINI'				=> 'Traži…',
	'SEARCH_ADV'				=> 'Napredna pretraga',
	'SEARCH_ADV_EXPLAIN'		=> 'Prikaz opcija napredne pretrage',
	'SEARCH_KEYWORDS'			=> 'Pretraži po riječima',
	'SEARCHING_FORUMS'			=> 'Pretraživanje foruma',
	'SEARCH_ACTIVE_TOPICS'		=> 'Pregled aktivnih tema',
	'SEARCH_FOR'				=> 'Traži prema',
	'SEARCH_FORUM'				=> 'Pretraži ovaj forum…',
	'SEARCH_NEW'				=> 'Pogledaj nove postove',
	'SEARCH_POSTS_BY'			=> 'Traži postove po',
	'SEARCH_SELF'				=> 'Pogledaj svoje postove',
	'SEARCH_TOPIC'				=> 'Pretraži ovu temu …',
	'SEARCH_UNANSWERED'			=> 'Pogledaj neodgovorene postove',
	'SEARCH_UNREAD'				=> 'Pogledajte nepročitane postove',
	'SEARCH_USER_POSTS'			=> 'Potraži postove korisnika',
	'SECONDS'					=> 'Sekundi',
	'SELECT'					=> 'Označi',
	'SELECT_ALL_CODE'			=> 'Označi sve',
	'SELECT_DESTINATION_FORUM'	=> 'Molim odaberite odredišni forum',
	'SELECT_FORUM'				=> 'Označi forum',
	'SEND_EMAIL'				=> 'E-mail',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'E-mail',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Šalji privatnu poruku',
	'SETTINGS'					=> 'Podešenja',
	'SIGNATURE'					=> 'Potpis',
	'SKIP'						=> 'Idi na sadržaj',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP server ne podržava ovu autentičnost.',
	'SORRY_AUTH_READ'			=> 'Vi nemate ovlasti za čitanje ovog foruma.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Vi nemate ovlasti za preuzimanje ovog privitka.',
	'SORT_BY'					=> 'Sortiraj po',
	'SORT_JOINED'				=> 'Datumu pristupa',
	'SORT_LOCATION'				=> 'Lokaciji',
	'SORT_RANK'					=> 'Ranku',
	'SORT_POSTS'				=> 'Postu',
	'SORT_TOPIC_TITLE'			=> 'Naslovu teme',
	'SORT_USERNAME'				=> 'Korisničkom imenu',
	'SPLIT_TOPIC'				=> 'Podjela teme',
	'SQL_ERROR_OCCURRED'		=> 'SQL pogreška pri dohvaćanju ovu stranicu. Molimo vas da kontaktirate %sforum administratora%s ukoliko se problem ponavlja.',
	'STATISTICS'				=> 'Statistika',
	'START_WATCHING_FORUM'		=> 'Pretplata na forum',
	'START_WATCHING_TOPIC'		=> 'Pretplata na temu',
	'STOP_WATCHING_FORUM'		=> 'Otkaži pretplatu sa foruma',
	'STOP_WATCHING_TOPIC'		=> 'Otkaži pretplatu teme',
	'SUBFORUM'					=> 'Podforum',
	'SUBFORUMS'					=> 'Podforumi',
	'SUBJECT'					=> 'Naslov',
	'SUBMIT'					=> 'Prihvati',

	'TERMS_USE'			=> 'Uvjeti korištenja',
	'TEST_CONNECTION'	=> 'Test konekcije',
	'THE_TEAM'			=> 'Tim',
	'TIME'				=> 'Vrijeme',
	
	'TOO_LARGE'						=> 'Vrijednost koju ste unijeli je prevelika.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'Prevelik broj! <strong>Maksimalan dozvoljen broj korisnika obuhvačenih privatnom porukom</strong> koji ste unjeli je prevelik.',

	'TOO_LONG'						=> 'Vrijednost koju ste unjeli je prevelika.',

	'TOO_LONG_AIM'	=> 'AIM uneseno korisničko ime je predugačko.',
	'TOO_LONG_CONFIRM_CODE'	=> 'Potvrdni unesen kod je predugačak.',
	'TOO_LONG_DATEFORMAT'	=> 'Format unesenog datuma je predugačak.',
	'TOO_LONG_ICQ'	=> 'Unesen ICQ broj je predugačak.',
	'TOO_LONG_INTERESTS'	=> 'Uneseni interesi su predugački .',
	'TOO_LONG_JABBER'	=> 'Jabber uneseno korisničko ime je predugačko.',
	'TOO_LONG_LOCATION'	=> 'Unesena lokacija je predugačka.',
	'TOO_LONG_MSN'	=> 'Uneseno MSNM/WLM korisničko ime je predugačko.',
	'TOO_LONG_NEW_PASSWORD'	=> 'Unešena je lozinka predugačka.',
	'TOO_LONG_OCCUPATION'	=> 'Unešeno zanimanje je predugačko.',
	'TOO_LONG_PASSWORD_CONFIRM'	=> 'Potvrda lozinke je predugačka.',
	'TOO_LONG_USER_PASSWORD'	=> 'Unešena lozinka je predugačka.',
	'TOO_LONG_USERNAME'	=> 'Unešeno korisničko ime je predugačko.',
	'TOO_LONG_EMAIL'	=> 'E-mail adresa je predugačka.',
	'TOO_LONG_EMAIL_CONFIRM'	=> 'Potvrdae-mail adrese je predugačka.',
	'TOO_LONG_WEBSITE'	=> 'Web adresa je predugačka.',
	'TOO_LONG_YIM'	=> 'YIM korisničko ime je predugačko.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Odabrano je previše opcija prilikom glasanja.',

	'TOO_SHORT'						=> 'Prekratka unešena vrijednost.',

	'TOO_SHORT_AIM'	=> 'AIM korisničko ime je prekratko.',
	'TOO_SHORT_CONFIRM_CODE'	=> 'Potvrdni kod je prekratak.',
	'TOO_SHORT_DATEFORMAT'	=> 'Format datuma je prekratak.',
	'TOO_SHORT_ICQ'	=> 'ICQ broj je prekratak.',
	'TOO_SHORT_INTERESTS'	=> 'Interes je prekratak.',
	'TOO_SHORT_JABBER'	=> 'Jabber korisničko ime je prekratko.',
	'TOO_SHORT_LOCATION'	=> 'Lokacija je prekratka.',
	'TOO_SHORT_MSN'	=> 'MSNM/WLM korisničko ime je prekratko.',
	'TOO_SHORT_NEW_PASSWORD'	=> 'Lozinka je prekratka.',
	'TOO_SHORT_OCCUPATION'	=> 'Zvanimanje je prekratko.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Potvrda lozinke je prekratka.',
	'TOO_SHORT_USER_PASSWORD'	=> 'Lozinka je prekratka.',
	'TOO_SHORT_USERNAME'	=> 'Korisničko ime je prekratko.',
	'TOO_SHORT_EMAIL'	=> 'E-mail adresa je prekratka.',
	'TOO_SHORT_EMAIL_CONFIRM'	=> 'Potvrda e-mail adrese  je prekratka.',
	'TOO_SHORT_WEBSITE'	=> 'Web adresa je prekratka.',
	'TOO_SHORT_YIM'	=> 'YIM korisničko ime je prekratko.',
	
	'TOO_SMALL'						=> 'Unešena vrijednost je premala.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'Vrijednost! <strong> Maksimalni broj dozvoljenih primatelja po privatnoj poruci! </ strong> Postavke koje ste unijeli su premale.',

	'TOPIC'	=> 'Tema',
	'TOPICS'	=> 'Teme',
	'TOPICS_UNAPPROVED'	=> 'Najmanje jedna tema na ovom forumu nije odobrena.',
	'TOPIC_ICON'	=> 'Ikona teme',
	'TOPIC_LOCKED'	=> 'Tema je zaključana [ne možeš uređivati postove ni odgovarati na postojeće].',
	'TOPIC_LOCKED_SHORT'	=> 'Tema je zaključana',
	'TOPIC_MOVED'	=> 'Premješteno',
	'TOPIC_REVIEW'	=> 'Prikaz teme',
	'TOPIC_TITLE'	=> 'Naslov teme',
	'TOPIC_UNAPPROVED'	=> 'Tema nije odobrena.',
	'TOTAL_ATTACHMENTS'	=> 'Privitak',
	'TOTAL_LOG'	=> '1 log',
	'TOTAL_LOGS'	=> '%d log(ov)a',
	'TOTAL_NO_PM'	=> '0 privatnih poruka ukupno',
	'TOTAL_PM'	=> '1 privatna poruka ukupno',
	'TOTAL_PMS'	=> '$d privatnih poruka ukupno',
	'TOTAL_POSTS'	=> 'Ukupno postova',
	'TOTAL_POSTS_OTHER'	=> 'Ukupno postova: <strong>%d</strong>.',
	'TOTAL_POSTS_ZERO'	=> 'Ukupno postova: <strong>0</strong>.',
	'TOPIC_REPORTED'	=> 'Tema je prijavljena.',
	'TOTAL_TOPICS_OTHER'	=> 'Ukupno tema: <strong>%d</strong>.',
	'TOTAL_TOPICS_ZERO'	=> 'Ukupno tema: <strong>0</strong>.',
	'TOTAL_USERS_OTHER'	=> 'Ukupno korisnika/ca: <strong>%d</strong>.',
	'TOTAL_USERS_ZERO'	=> 'Ukupno korisnika/ca: <strong>0</strong>.',
	'TRACKED_PHP_ERROR'	=> 'PHP greška: %s.',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Nije moguće utvrditi dimenzije slikovne datoteke.',
	'UNABLE_TO_DELIVER_FILE'	=> 'Isporuka datoteka nije moguća.',
	'UNKNOWN_BROWSER'	=> 'Nepoznat preglednik',
	'UNMARK_ALL'	=> 'Odoznači sve',
	'UNREAD_MESSAGES'	=> 'Nepročitane poruke',
	'UNREAD_PM'	=> '<strong>%d</strong> nepročitana poruka',
	'UNREAD_PMS'	=> '<strong>%d</strong> nepročitanih poruka',
	'UNREAD_POST'			=> 'Nepročitani post',
	'UNREAD_POSTS'			=> 'Nepročitani postovi',
	'UNWATCH_FORUM_CONFIRM'		=> 'Jeste li sigurni da želite odjaviti praćenje foruma?',
	'UNWATCH_FORUM_DETAILED'	=> 'Jeste li sigurni da želite odjaviti praćenje foruma “%s”?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Jeste li sigurni da želite odjaviti praćenje ove teme?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Jeste li sigurni da želite odjaviti praćenje temu “%s”?',
	'UNWATCHED_FORUMS'	=> 'Više nisi pretplaćen na forum(e).',
	'UNWATCHED_TOPICS'	=> 'Više nisi pretplaćen na temu(e).',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Više nisi pretplaćen na unos(e).',
	'UPDATE'	=> 'Ažuriraj',
	'UPLOAD_IN_PROGRESS'	=> 'Uploadiranje je u tijeku.',
	'URL_REDIRECT'	=> 'Ukoliko tvoj preglednik ne podržava preusmjeravanje klikni %sovdje%s kako bi “bio/la” preusmjeren.',
	'USERGROUPS'			=> 'Korisnička grupa',
	'USERNAME'				=> 'Korisničko ime',
	'USERNAMES'				=> 'Korisnička imena',
	'USER_AVATAR'			=> 'Avatar korisnika',
	'USER_CANNOT_READ'		=> 'Vi ne možete čitati post ovog foruma.',
	'USER_POST'				=> '%d Post',
	'USER_POSTS'			=> '%d Postovi',
	'USERS'					=> 'Korisnik',
	'USE_PERMISSIONS'		=> 'Test korisničkih ovlasti',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Žao nam je, ali niste ovlašteni koristiti ovu opciju. Samo registrirani ovdje mogu to koristiti i možda će morati ovisno o pravilima više sudjelovati u forumu kako bi bili u mogućnosti koristiti ovu opciju.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'	=> 'Pogledano',
	'VIEWING_FAQ'	=> 'Pregledava FAQ',
	'VIEWING_MEMBERS'	=> 'Pregledava detalje Članstva',
	'VIEWING_ONLINE'	=> 'Pregledava tko je online',
	'VIEWING_MCP'	=> 'Pregledava Moderiranje foruma',
	'VIEWING_MEMBER_PROFILE'	=> 'Pregledava profil korisnika',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Pregledava privatne poruke',
	'VIEWING_REGISTER'	=> 'Registrira se',
	'VIEWING_UCP'	=> 'Pregledava Profil',
	'VIEWS'	=> 'Pogledano',
	'VIEW_BOOKMARKS'	=> 'Oznake',
	'VIEW_FORUM_LOGS'	=> 'Logovi',
	'VIEW_LATEST_POST'			=> 'Pogledajte zadnji post',
	'VIEW_NEWEST_POST'			=> 'Pogledajte prvi nepročitani post',
	'VIEW_NOTES'				=> 'Pogledajte korisničke bilješke',
	'VIEW_ONLINE_TIME'			=> 'na temelju korisnika aktivnih u protekle %d minute',
	'VIEW_ONLINE_TIMES'			=> 'na temelju korisnika aktivnih u proteklih %d minuta',
	'VIEW_TOPIC'				=> 'Pogledaj temu',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Obavijest: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Globalna obavijest: ',
	'VIEW_TOPIC_LOCKED'			=> 'Zaključano: ',
	'VIEW_TOPIC_LOGS'			=> 'Pogledaj logove',
	'VIEW_TOPIC_MOVED'			=> 'Premješteno: ',
	'VIEW_TOPIC_POLL'			=> 'Anketa: ',
	'VIEW_TOPIC_STICKY'			=> 'Zaljepi: ',
	'VISIT_WEBSITE'				=> 'Posjeti web',

	'WARNINGS'			=> 'Upozorenja',
	'WARN_USER'			=> 'Upozori korisnika',
	'WATCH_FORUM_CONFIRM'	=> 'Jeste li sigurni da se želite pretplatiti na ovaj forum?',
	'WATCH_FORUM_DETAILED'	=> 'Jeste li sigurni da se želite pretplatiti na forum “%s”?',
	'WATCH_TOPIC_CONFIRM'	=> 'Jeste li sigurni da se želite pretplatiti na ovu temu?',
	'WATCH_TOPIC_DETAILED'	=> 'Jeste li sigurni da se želite pretplatiti na temu “%s”?',
	'WELCOME_SUBJECT'	=> 'Dobro došli na %s forum',
	'WEBSITE'			=> 'Web',
	'WHOIS'				=> 'Tko je',
	'WHO_IS_ONLINE'		=> 'Tko je online',
	'WRONG_PASSWORD'	=> 'Upisali ste pogrešnu lozinku.',

	'WRONG_DATA_ICQ'			=> 'Broj koji ste unjeli nije ispravan ICQ broj.',
	'WRONG_DATA_JABBER'			=> 'Ime koje ste naveli nije ispravno Jabber korisničko ime.',
	'WRONG_DATA_LANG'			=> 'Jezik koji ste naveli nije valjan.',
	'WRONG_DATA_WEBSITE'		=> 'Adresa web stranice mora sadržavati ispravan URL, na primjer http://www.phpbb.com.hr',
	'WROTE'						=> 'napisao',

	'YEAR'				=> 'Godina',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'				=> 'Da',
	'YIM'				=> 'YIM',
	'YOU_LAST_VISIT'	=> 'Zadnja prijava: %s',
	'YOU_NEW_PM'		=> 'Čeka vas nova privatna poruka u vašem sandučiću.',
	'YOU_NEW_PMS'		=> 'Čeka vas nova privatna poruka u vašem sandučiću.',
	'YOU_NO_NEW_PM'		=> 'Nema novih privatnih poruka za vas.',

	'datetime'			=> array(
		'TODAY'		=> 'Danas',
		'TOMORROW'	=> 'Sutra',
		'YESTERDAY'	=> 'Jučer',
		'AGO'		=> array(
			0		=> 'prije manje od minute',
			1		=> 'prije %d minut',
			2		=> 'prije %d minuta',
			60		=> 'prije 1 sat',
		),

		'Sunday'	=> 'Nedjelja',
		'Monday'	=> 'Ponedjeljak',
		'Tuesday'	=> 'Utorak',
		'Wednesday'	=> 'Srijeda',
		'Thursday'	=> 'Četvrtak',
		'Friday'	=> 'Petak',
		'Saturday'	=> 'Subota',

		'Sun'		=> 'Ned',
		'Mon'		=> 'Pon',
		'Tue'		=> 'Uto',
		'Wed'		=> 'Sri',
		'Thu'		=> 'Čet',
		'Fri'		=> 'Pet',
		'Sat'		=> 'Sub',

		'January'	=> 'Siječanj',
		'February'	=> 'Veljača',
		'March'		=> 'Ožujak',
		'April'		=> 'Travanj',
		'May'		=> 'Svibanj',
		'June'		=> 'Lipanj',
		'July'		=> 'Srpanj',
		'August'	=> 'Kolovoz',
		'September' => 'Rujanj',
		'October'	=> 'Listopad',
		'November'	=> 'Studeni',
		'December'	=> 'Prosinac',

		'Jan'	=> 'sij',
		'Feb'	=> 'vel',
		'Mar'	=> 'ožu',
		'Apr'	=> 'tra',
		'May_short'	=> 'svi',	// Kratki prikaz za "Svibanj". Svibanj se koristi jer je na Engleskom taj mjesec jednak u dugom kao i u kratkom nazivu.
		'Jun'	=> 'lip',
		'Jul'	=> 'srp',
		'Aug'	=> 'kol',
		'Sep'	=> 'ruj',
		'Oct'	=> 'lis',
		'Nov'	=> 'stu',
		'Dec'	=> 'pro',
	),

	'tz'	=> array(
		'-12'	=> 'UTC - 12 sati',
		'-11'	=> 'UTC - 11 sati',
		'-10'	=> 'UTC - 10 sati',
		'-9.5'	=> 'UTC - 9:30 sati',
		'-9'	=> 'UTC - 9 sati',
		'-8'	=> 'UTC - 8 sati',
		'-7'	=> 'UTC - 7 sati',
		'-6'	=> 'UTC - 6 sati',
		'-5'	=> 'UTC - 5 sati',
		'-4.5'	=> 'UTC - 4:30 sata',
		'-4'	=> 'UTC - 4 sata',
		'-3.5'	=> 'UTC - 3:30 sata',
		'-3'	=> 'UTC - 3 sata',
		'-2'	=> 'UTC - 2 sata',
		'-1'	=> 'UTC - 1 sat',
		'0'	=> 'UTC',
		'1'	=> 'UTC + 01:00 sata',
		'2'	=> 'UTC + 02:00 sata',
		'3'	=> 'UTC + 03:00 sata',
		'3.5'	=> 'UTC + 03:30 sata',
		'4'	=> 'UTC + 04:00 sata',
		'4.5'	=> 'UTC + 04:30 sata',
		'5'	=> 'UTC + 05:00 sati',
		'5.5'	=> 'UTC + 05:30 sati',
		'5.75'	=> 'UTC + 05:45 sati',
		'6'	=> 'UTC + 06:00 sati',
		'6.5'	=> 'UTC + 06:30 sati',
		'7'	=> 'UTC + 07:00 sati',
		'8'	=> 'UTC + 08:00 sati',
		'8.75'	=> 'UTC + 08:45 sati',
		'9'	=> 'UTC + 09:00 sati',
		'9.5'	=> 'UTC + 09:30 sati',
		'10'	=> 'UTC + 10:00 sati',
		'10.5'	=> 'UTC + 10:30 sati',
		'11'	=> 'UTC + 11:00 sati',
		'11.5'	=> 'UTC + 11:30 sati',
		'12'	=> 'UTC + 12:00 sati',
		'12.75'	=> 'UTC + 12:45 sati',
		'13'	=> 'UTC + 13:00 sati',
		'14'	=> 'UTC + 14:00 sati',
		'dst'	=> '[<abbr title="Ljetno računanje vrijemena">LJV</abbr>]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Baker Island Time',
		'-11'	=> '[UTC - 11] Niue Time, Samoa Standard Time',
		'-10'	=> '[UTC - 10] Hawaii-Aleutian Standard Time, Cook Island Time',
		'-9.5'	=> '[UTC - 9:30] Marquesas Islands Time',
		'-9'	=> '[UTC - 9] Alaska Standard Time, Gambier Island Time',
		'-8'	=> '[UTC - 8] Pacific Standard Time',
		'-7'	=> '[UTC - 7] Mountain Standard Time',
		'-6'	=> '[UTC - 6] Central Standard Time',
		'-5'	=> '[UTC - 5] Eastern Standard Time',
		'-4.5'	=> '[UTC - 4:30] Venezuelan Standard Time',
		'-4'	=> '[UTC - 4] Atlantic Standard Time',
		'-3.5'	=> '[UTC - 3:30] Newfoundland Standard Time',
		'-3'	=> '[UTC - 3] Amazon Standard Time, Central Greenland Time',
		'-2'	=> '[UTC - 2] Fernando de Noronha Time, South Georgia &amp; the South Sandwich Islands Time',
		'-1'	=> '[UTC - 1] Azores Standard Time, Cape Verde Time, Eastern Greenland Time',
		'0'		=> '[UTC] Western European Time, Greenwich Mean Time',
		'1'		=> '[UTC + 1] Central European Time, West African Time',
		'2'		=> '[UTC + 2] Eastern European Time, Central African Time',
		'3'		=> '[UTC + 3] Moscow Standard Time, Eastern African Time',
		'3.5'	=> '[UTC + 3:30] Iran Standard Time',
		'4'		=> '[UTC + 4] Gulf Standard Time, Samara Standard Time',
		'4.5'	=> '[UTC + 4:30] Afghanistan Time',
		'5'		=> '[UTC + 5] Pakistan Standard Time, Yekaterinburg Standard Time',
		'5.5'	=> '[UTC + 5:30] Indian Standard Time, Sri Lanka Time',
		'5.75'	=> '[UTC + 5:45] Nepal Time',
		'6'		=> '[UTC + 6] Bangladesh Time, Bhutan Time, Novosibirsk Standard Time',
		'6.5'	=> '[UTC + 6:30] Cocos Islands Time, Myanmar Time',
		'7'		=> '[UTC + 7] Indochina Time, Krasnoyarsk Standard Time',
		'8'		=> '[UTC + 8] Chinese Standard Time, Australian Western Standard Time, Irkutsk Standard Time',
		'8.75'	=> '[UTC + 8:45] Southeastern Western Australia Standard Time',
		'9'		=> '[UTC + 9] Japan Standard Time, Korea Standard Time, Chita Standard Time',
		'9.5'	=> '[UTC + 9:30] Australian Central Standard Time',
		'10'	=> '[UTC + 10] Australian Eastern Standard Time, Vladivostok Standard Time',
		'10.5'	=> '[UTC + 10:30] Lord Howe Standard Time',
		'11'	=> '[UTC + 11] Solomon Island Time, Magadan Standard Time',
		'11.5'	=> '[UTC + 11:30] Norfolk Island Time',
		'12'	=> '[UTC + 12] New Zealand Time, Fiji Time, Kamchatka Standard Time',
		'12.75'	=> '[UTC + 12:45] Chatham Islands Time',
		'13'	=> '[UTC + 13] Tonga Time, Phoenix Islands Time',
		'14'	=> '[UTC + 14] Line Island Time',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Sij 2007, 13:37',
		'd M Y H:i'				=> '01 Sij 2007 13:37',
		'M jS, \'y, H:i'		=> 'Sij 1, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Pon Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'Siječanj 1, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Danas, 13:37 / 01 Sij 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Danas, 1:37 pm / Siječanj 1, 2007, 1:37 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D M d, Y g:i a', // Mon Jan 01, 2007 1:37 pm

));
?>