package org.codehaus.plexus.context;

/*
 * The MIT License
 *
 * Copyright (c) 2004, The Codehaus
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

import junit.framework.TestCase;

import java.io.StringReader;
import java.io.StringWriter;

import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.IOUtil;

/**
 * Generated by JUnitDoclet, a tool provided by ObjectFab GmbH under LGPL.
 * Please see www.junitdoclet.org, www.gnu.org and www.objectfab.de for
 * informations about the tool, the licence and the authors.
 */
public class ContextMapAdapterTest
    extends TestCase
{
    public ContextMapAdapterTest( String name )
    {
        super( name );
    }

    public void testInterpolation()
        throws Exception
    {
        DefaultContext context = new DefaultContext();

        context.put( "name", "jason" );

        context.put( "occupation", "exotic dancer" );

        ContextMapAdapter adapter = new ContextMapAdapter( context );

        assertEquals( "jason", (String) adapter.get( "name" ) );

        assertEquals( "exotic dancer", (String) adapter.get( "occupation" ) );

        assertNull( adapter.get( "foo" ) );
    }

    public void testInterpolationWithContext()
        throws Exception
    {
        DefaultContext context = new DefaultContext();
        context.put( "name", "jason" );
        context.put( "noun", "asshole" );

        String foo = "${name} is an ${noun}. ${not.interpolated}";

        InterpolationFilterReader reader =
            new InterpolationFilterReader( new StringReader( foo ), new ContextMapAdapter( context ) );

        StringWriter writer = new StringWriter();
        IOUtil.copy( reader, writer );

        String bar = writer.toString();
        assertEquals( "jason is an asshole. ${not.interpolated}", bar );
    }
}
